/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPsmPortBindTableModel;
import com.cisco.dcbu.sm.client.dialogs.SmPsmTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertPsmPortBind
extends InsertForm
implements ItemListener,
ListSelectionListener {
    static final int DEV_TYPE = 1;
    static final int DEV_ADDR = 2;
    static final int SWITCH_PORTBINDINDEX = 4;
    static final int SWITCH_TYPE = 5;
    static final int SWITCH_IFINDEX = 6;
    static final int DEV_TYPE_MAC = 1;
    static final int DEV_TYPE_WILDCARD = 5;
    static final int DEV_TYPE_DEV_ALIAS = 6;
    private JTextField _wwn;
    private JList _list;
    private JList _ifList;
    JLabel _wwnLabel;
    JLabel _ifLabel;
    SmPortSetFieldPanel _portFieldPanel;
    static final String _PWwnListBoxLabel = "<html><div align=right>Available<br>(WWN, Interface)<br>Name:</html>";
    static final String _SWwnListBoxLabel = "<html><div align=right>Available<br>(Switch, WWN)<br>Name:</html>";
    static final String _deviceAliasListBoxLabel = "<html><div align=right>Available<br>(Name, Interface)<br>Name:</html>";
    boolean _cfsEnabled = false;

    public SmInsertPsmPortBind(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this._cfsEnabled = table.getCfsMaster() != null;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        GroupButtonPanel devType = (GroupButtonPanel)this._values[1];
        devType.addChangeListener(this);
        GroupButtonPanel swType = (GroupButtonPanel)this._values[5];
        swType.addChangeListener(this);
        this.updateIndex(-1);
        this._labels[4].setVisible(false);
        this._values[4].setVisible(false);
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        if (this._wwnLabel != null) {
            DialogUtil.constrain(this._container, this._wwnLabel, new GridBagConstraints(), 0, 3, 0, 14);
        }
        if (this._ifLabel != null) {
            DialogUtil.constrain(this._container, this._ifLabel, new GridBagConstraints(), 0, 7, 0, 14);
        }
        this._portFieldPanel.setNode((SnmpPeer)this._choice.getSelectedItem());
    }

    private void updateIndex(int curIndex) {
        if (curIndex == -1) {
            SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
            curIndex = ((SmPsmPortBindTableModel)this._table).getLastPortBindIndex(peer);
        }
        this.setComponentText(4, Integer.toString(++curIndex));
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        switch (index) {
            case 1: {
                return new JLabel("Type:");
            }
            case 2: {
                this._wwnLabel = new JLabel(_PWwnListBoxLabel, 4);
                return this._wwnLabel;
            }
            case 5: {
                return new JLabel("Type:");
            }
            case 6: {
                this._ifLabel = new JLabel("<html><div align=right>Available<br>Interface:</html>", 4);
                return this._ifLabel;
            }
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            this._list = new JList();
            this._list.addListSelectionListener(this);
            this._list.setSelectionMode(1);
            this._list.setCellRenderer(new WwnCellRenderer());
            JScrollPane sp = new JScrollPane(this._list);
            sp.setPreferredSize(new Dimension(300, 80));
            panel.add("Center", sp);
            this._wwn = new KTextField();
            panel.add("South", this._wwn);
            this.updatePWwnList(this._peers[0]);
            return panel;
        }
        if (index == 6) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            this._ifList = new JList();
            this._ifList.addListSelectionListener(this);
            this._ifList.setSelectionMode(1);
            this._ifList.setCellRenderer(new IfListCellRenderer());
            JScrollPane sp = new JScrollPane(this._ifList);
            sp.setPreferredSize(new Dimension(300, 80));
            panel.add("Center", sp);
            short ss = SmPortSetFieldPanel.SHOW_ISL_PC_BMP;
            ss = (short)(ss | SmPortSetFieldPanel.SHOW_F_PC_BMP);
            ss = (short)(ss | SmPortSetFieldPanel.SHOW_VFC_BMP);
            PortEditorFilter psFilter = new PortEditorFilter(new int[]{1});
            this._portFieldPanel = new SmPortSetFieldPanel(true, 20, psFilter, ss);
            panel.add("South", this._portFieldPanel);
            this.updatePWwnList(this._peers[0]);
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    ArrayList getEndPortsBySwitch(Switch sw) {
        int vsanId = ((SmPsmTableModel)this._table).getVsanId();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric f = mgmtDomain.getFabric();
        Vsan[] vsans = f.getVsansById(vsanId);
        HashedArrayList<EndPort> ports = new HashedArrayList<EndPort>();
        for (int i = 0; i < vsans.length; ++i) {
            EndPort[] vsanEPorts = vsans[i].getEndPorts();
            for (int j = 0; j < vsanEPorts.length; ++j) {
                ((ArrayList)ports).add(vsanEPorts[j]);
            }
        }
        HashedArrayList<EndPort> swPorts = new HashedArrayList<EndPort>();
        if (ports != null) {
            for (int i = 0; i < ports.size(); ++i) {
                EndPort ep = (EndPort)ports.get(i);
                if (!this._cfsEnabled) {
                    if (ep.getSwitch() != sw || ep.isISCSI() || ep.isVirtualized() || ep.isFicon()) continue;
                    ((ArrayList)swPorts).add(ep);
                    continue;
                }
                if (ep.isISCSI() || ep.isVirtualized() || ep.isFicon()) continue;
                ((ArrayList)swPorts).add(ep);
            }
        }
        return swPorts;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        char c = ((JToggleButton)e.getSource()).getText().charAt(0);
        if (((JToggleButton)e.getSource()).getParent() == this._values[1]) {
            this._wwn.setEnabled(c != 'a');
            if (this._list != null) {
                this._list.setEnabled(c == 'p' || c == 'n' || c == 's' || c == 'd');
                if (c == 'p' || c == 'n') {
                    this.updatePWwnList((SnmpPeer)this._choice.getSelectedItem());
                    this._ifList.setListData(new Object[0]);
                } else if (c == 's') {
                    this.updateSWwnList((SnmpPeer)this._choice.getSelectedItem());
                } else if (c == 'd') {
                    this.updateDeviceAliasList((SnmpPeer)this._choice.getSelectedItem());
                }
            }
        } else {
            this._ifList.setEnabled(c != 'a');
            this._portFieldPanel.getButton().setEnabled(c == 'i');
            this.updateInterfaceField();
        }
    }

    void updatePWwnList(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList ports = this.getEndPortsBySwitch(sw);
        if (ports != null) {
            this._list.setListData(ports.toArray(new EndPort[ports.size()]));
        } else {
            this._list.setListData(new EndPort[0]);
        }
        if (this._wwnLabel != null) {
            this._wwnLabel.setText(_PWwnListBoxLabel);
        }
        this._wwn.setText("");
        if (this._portFieldPanel != null) {
            this._portFieldPanel.setText("");
        }
    }

    void updateSWwnList(SnmpPeer peer) {
        int vsanId = ((SmPsmTableModel)this._table).getVsanId();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric f = mgmtDomain.getFabric();
        Vsan[] vsans = f.getVsansById(vsanId);
        ArrayList<Switch> sws = new ArrayList<Switch>();
        for (int i = 0; i < vsans.length; ++i) {
            Switch[] vsanSws = vsans[i].getSwitches();
            if (vsanSws == null) continue;
            for (int j = 0; j < vsanSws.length; ++j) {
                sws.add(vsanSws[j]);
            }
        }
        if (sws != null) {
            this._list.setListData(sws.toArray(new Switch[sws.size()]));
        } else {
            this._list.setListData(new Switch[0]);
        }
        if (this._wwnLabel != null) {
            this._wwnLabel.setText(_SWwnListBoxLabel);
        }
        this._wwn.setText("");
        if (this._portFieldPanel != null) {
            this._portFieldPanel.setText("");
        }
    }

    void updateDeviceAliasList(SnmpPeer peer) {
        int vsanId = ((SmPsmTableModel)this._table).getVsanId();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric f = mgmtDomain.getFabric();
        ArrayList<DeviceAlias> devAliasList = f.getDeviceAliases(vsanId);
        DeviceAlias[] devAlias = devAliasList.toArray(new DeviceAlias[devAliasList.size()]);
        if (devAlias != null) {
            this._list.setListData(devAlias);
        } else {
            this._list.setListData(new DeviceAlias[0]);
        }
        if (this._wwnLabel != null) {
            this._wwnLabel.setText(_deviceAliasListBoxLabel);
        }
        this._wwn.setText("");
        if (this._portFieldPanel != null) {
            this._portFieldPanel.setText("");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if ((JList)e.getSource() == this._list) {
            DeviceAlias devAlias;
            Object sel = this._list.getSelectedValue();
            if (sel instanceof EndPort) {
                EndPort ep = (EndPort)sel;
                if (ep != null) {
                    boolean isNwwn = ((GroupButtonPanel)this._values[1]).getSelected() == 0;
                    this._wwn.setText(SnmpString.toHexString(isNwwn ? ep.getNodeWwn().getValue() : ep.getPortWwn().getValue()));
                    SnmpPeer selPeer = (SnmpPeer)this._choice.getSelectedItem();
                    Switch selSw = ClientController.findFabricSwitchByIpAddress(selPeer.getAddress());
                    Switch epConnectedSw = ep.getSwitch();
                    GroupButtonPanel swType = (GroupButtonPanel)this._values[5];
                    if (epConnectedSw != selSw && this._cfsEnabled) {
                        swType.setSelected(0);
                        byte[] swWwn = epConnectedSw.getWwn().getValue();
                        byte[] prtWWN = epConnectedSw.ifIndex2wwn(ep.getIfIndex(), swWwn);
                        this._portFieldPanel.setText(SnmpString.toHexString(prtWWN));
                    } else {
                        swType.setSelected(1);
                        String epIntName = ep.getIfIndexName();
                        String vfcBindTo = ep.getVFCBindTo();
                        if (vfcBindTo != null) {
                            epIntName = epIntName.replaceAll("\\(" + vfcBindTo + "\\)", "");
                        }
                        this._portFieldPanel.setText(epIntName);
                    }
                }
            } else if (sel instanceof Switch) {
                Wwn w;
                Switch sw = (Switch)sel;
                if (sw != null && (w = sw.getWwn()) != null) {
                    this._wwn.setText(SnmpString.toHexString(w.getValue()));
                    GroupButtonPanel swType = (GroupButtonPanel)this._values[5];
                    swType.setSelected(1);
                    this._portFieldPanel.setText("");
                    this._ifList.setListData(this.getIslsIfIndexList(sw, sw.isVersionGreaterThanEqual("4.1(1)")));
                }
            } else if (sel instanceof DeviceAlias && (devAlias = (DeviceAlias)sel) != null) {
                this._wwn.setText(devAlias.getAlias());
                EndPort ep = devAlias.getEndPort();
                if (ep != null) {
                    GroupButtonPanel swType = (GroupButtonPanel)this._values[5];
                    swType.setSelected(1);
                    this._portFieldPanel.setText(ep.getIfIndexNameBrief());
                }
            }
        } else {
            this.updateInterfaceField();
        }
    }

    Integer[] getIslsIfIndexList(Switch bindDevSw) {
        return this.getIslsIfIndexList(bindDevSw, false);
    }

    Integer[] getIslsIfIndexList(Switch bindDevSw, boolean includeFcPortChannel) {
        int ifIndex2;
        int ifIndex1;
        Switch sw2;
        Switch sw1;
        int i;
        Fabric f = ClientController.getInstance().getFabric();
        Isl[] isls = f.getIsls();
        NpvLink[] npvLinks = f.getNpvLinks();
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch targetSw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList<Integer> islList = new ArrayList<Integer>();
        for (i = 0; i < isls.length; ++i) {
            if (isls[i].isFCIP() || isls[i].isFcipPortChannel() || isls[i].isPortChannel() && !includeFcPortChannel) continue;
            sw1 = isls[i].getSwitch1();
            sw2 = isls[i].getSwitch2();
            ifIndex1 = isls[i].getIfIndex1();
            ifIndex2 = isls[i].getIfIndex2();
            if (targetSw == sw1 && bindDevSw == sw2) {
                islList.add(new Integer(ifIndex1));
                continue;
            }
            if (targetSw != sw2 || bindDevSw != sw1) continue;
            islList.add(new Integer(ifIndex2));
        }
        if (npvLinks != null) {
            for (i = 0; i < npvLinks.length; ++i) {
                if (npvLinks[i].isPortChannel() && !includeFcPortChannel) continue;
                sw1 = npvLinks[i].getCoreSwitch();
                sw2 = npvLinks[i].getEdgeSwitch();
                ifIndex1 = npvLinks[i].getFPortIfIndex();
                ifIndex2 = npvLinks[i].getNpPortIfIndex();
                if (targetSw == sw1 && bindDevSw == sw2) {
                    islList.add(new Integer(ifIndex1));
                    continue;
                }
                if (targetSw != sw2 || bindDevSw != sw1) continue;
                islList.add(new Integer(ifIndex2));
            }
        }
        return islList.toArray(new Integer[islList.size()]);
    }

    void updateInterfaceField() {
        Integer sel = (Integer)this._ifList.getSelectedValue();
        if (sel != null) {
            SnmpPeer peer;
            Switch sw;
            GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[5];
            String strSel = grpPanel.getButton(grpPanel.getSelected()).getText();
            if (strSel.equals("interface")) {
                try {
                    this._portFieldPanel.setText(this.getSelectedIfIndexIf().ifIndexToName(sel));
                }
                catch (Exception ex) {
                    this._portFieldPanel.setText("");
                }
            } else if (strSel.equals("fWWN") && (sw = ClientController.findFabricSwitchByIpAddress((peer = (SnmpPeer)this._choice.getSelectedItem()).getAddress())) != null) {
                byte[] swWwn = sw.getWwn().getValue();
                byte[] prtWWN = sw.ifIndex2wwn(sel, swWwn);
                this._portFieldPanel.setText(SnmpString.toHexString(prtWWN));
            }
            return;
        }
        this._portFieldPanel.setText("");
    }

    @Override
    protected boolean toGetComponentValue(int index) {
        if (index == 2) {
            GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[1];
            String strSel = grpPanel.getButton(grpPanel.getSelected()).getText();
            return !strSel.equals("any");
        }
        if (index == 6) {
            GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[5];
            String strSel = grpPanel.getButton(grpPanel.getSelected()).getText();
            return !strSel.equals("any");
        }
        return super.toGetComponentValue(index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            if (this._wwn.getText().length() == 0) {
                throw new Exception("Bind Device WWN: invalid entry");
            }
            SnmpInt type = (SnmpInt)super.getComponentValue(1);
            if (type.getValue() == 6) {
                return new SnmpString(this._wwn.getText());
            }
            return new SnmpWWN(this._wwn.getText(), false);
        }
        if (index == 6) {
            GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[5];
            String strSel = grpPanel.getButton(grpPanel.getSelected()).getText();
            String strSwitchIf = this._portFieldPanel.getText();
            if ((strSel.equals("fWWN") || strSel.equals("interface")) && strSwitchIf.length() == 0) {
                throw new Exception("Interface: invalid entry");
            }
            if (strSel.equals("fWWN")) {
                return new SnmpWWN(strSwitchIf, false);
            }
            if (strSel.equals("interface")) {
                int ifIndex = this.getSelectedIfIndexIf().nameToIfIndex(strSwitchIf);
                byte[] b = new byte[4];
                b[3] = (byte)(ifIndex & 0xFF);
                b[2] = (byte)(ifIndex >> 8 & 0xFF);
                b[1] = (byte)(ifIndex >> 16 & 0xFF);
                b[0] = (byte)(ifIndex >> 24 & 0xFF);
                return new SnmpString(b);
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected String getErrMsgFieldName(String mibVar, int index) {
        if (index == 2) {
            return "Bind Device WWN";
        }
        if (index == 6) {
            return "Interface";
        }
        return super.getErrMsgFieldName(mibVar, index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = new int[]{1, ((SmPsmTableModel)this._table).getVsanId(), (int)((SnmpUnsignedInt)values[4]).getValue()};
        return index;
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
        int curIndex = Integer.parseInt(this.getComponentText(4));
        this.updateIndex(curIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                this.updateIndex(-1);
                this._portFieldPanel.setNode(peer);
                this._portFieldPanel.setText("");
                GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[1];
                char c = grpPanel.getButton(grpPanel.getSelected()).getText().charAt(0);
                if (c == 'p' || c == 'n') {
                    this.updatePWwnList((SnmpPeer)this._choice.getSelectedItem());
                } else if (c == 's') {
                    this.updateSWwnList((SnmpPeer)this._choice.getSelectedItem());
                } else if (c == 'd') {
                    this.updateDeviceAliasList((SnmpPeer)this._choice.getSelectedItem());
                }
                this._ifList.setListData(new Object[0]);
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public void dispose() {
        PortSetEditor.getInstance(BrowserFrame.getInstance()).hideDlg();
    }

    class IfListCellRenderer
    extends DefaultListCellRenderer {
        IfListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            try {
                this.setText(SmInsertPsmPortBind.this.getSelectedIfIndexIf().ifIndexToName((Integer)value));
            }
            catch (Exception ex) {
                this.setText("");
            }
            return retValue;
        }
    }

    class WwnCellRenderer
    extends DefaultListCellRenderer {
        WwnCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            StringBuffer buf = new StringBuffer();
            if (value instanceof EndPort) {
                EndPort ep = (EndPort)value;
                this.endportNameAndIfName(buf, ep);
            } else if (value instanceof Switch) {
                Switch sw = (Switch)value;
                buf.append(sw.toString());
                buf.append(",");
                buf.append(sw.getWwn());
            } else if (value instanceof DeviceAlias) {
                EndPort ep = ((DeviceAlias)value).getEndPort();
                this.endportNameAndIfName(buf, ep);
            } else {
                buf.append(value);
            }
            this.setText(buf.toString());
            return retValue;
        }

        void endportNameAndIfName(StringBuffer buf, EndPort ep) {
            buf.append(ep.toString());
            buf.append(",");
            if (SmInsertPsmPortBind.this._cfsEnabled) {
                SnmpPeer selPeer = (SnmpPeer)SmInsertPsmPortBind.this._choice.getSelectedItem();
                Switch selSw = ClientController.findFabricSwitchByIpAddress(selPeer.getAddress());
                Switch epConnectedSw = ep.getSwitch();
                if (epConnectedSw != selSw) {
                    buf.append(epConnectedSw);
                    buf.append(" ");
                }
            }
            buf.append(ep.getIfIndexName());
        }
    }
}

