/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JTextField;

public class SmInsertRmonAlarm
extends InsertForm {
    private static final int VARIABLE = 2;
    private static final int STARTUP_ALARM = 4;
    private static final int RISING_THRESHOLD = 5;
    private static final int RISING_EVENT = 6;
    private static final int FALLING_THRESHOLD = 7;
    private static final int FALLING_EVENT = 8;
    private static final int OWNER = 9;

    public SmInsertRmonAlarm(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this.setInsertValidate(1);
    }

    @Override
    public void build() throws Exception {
        super.build();
        ((RadioButtonPanel)this.getComponentAt(4)).setSelected(0);
        ((JTextField)this.getComponentAt(2)).addFocusListener(new OwnerListener());
        ((JTextField)this.getComponentAt(5)).addFocusListener(new OwnerListener());
        ((JTextField)this.getComponentAt(7)).addFocusListener(new OwnerListener());
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            String var = this.getComponentText(index);
            if (var.length() == 0) {
                throw new Exception("Please enter a value for Variable");
            }
            if (Character.isLetter(var.charAt(0))) {
                if (var.indexOf(46) != -1) {
                    int dot = var.indexOf(46) + 1;
                    String ifName = var.substring(dot);
                    try {
                        int ifIndex = this.getSelectedIfIndexIf().nameToIfIndex(ifName);
                        var = var.substring(0, dot) + Integer.toString(ifIndex);
                    }
                    catch (Exception ex) {
                        var = var.substring(0, dot) + ifName;
                    }
                }
                int[] oid = MibNode.parseName(var);
                return new SnmpOID(oid);
            }
            String[] oids = StringUtil.tokenize(var, ".");
            int[] oid = new int[oids.length];
            for (int i = 0; i < oid.length; ++i) {
                oid[i] = Integer.valueOf(oids[i]);
            }
            return new SnmpOID(oid);
        }
        return super.getComponentValue(index);
    }

    class OwnerListener
    extends FocusAdapter {
        OwnerListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String text;
            if (e.getSource() == SmInsertRmonAlarm.this._values[5]) {
                if (((JTextField)SmInsertRmonAlarm.this._values[7]).getText().equals("")) {
                    text = ((JTextField)SmInsertRmonAlarm.this._values[5]).getText();
                    int rising = Integer.parseInt(text);
                    ((JTextField)SmInsertRmonAlarm.this._values[7]).setText(Integer.toString(rising - 1));
                }
            } else if (e.getSource() == SmInsertRmonAlarm.this._values[7] && ((JTextField)SmInsertRmonAlarm.this._values[5]).getText().equals("")) {
                text = ((JTextField)SmInsertRmonAlarm.this._values[7]).getText();
                int rising = Integer.parseInt(text);
                ((JTextField)SmInsertRmonAlarm.this._values[5]).setText(Integer.toString(rising + 1));
            }
            String mibVar = SmInsertRmonAlarm.this.getComponentText(2);
            try {
                SmInsertRmonAlarm.this.setComponentText(9, mibVar + "@" + InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }
}

