/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertRouteFlow
extends InsertForm {
    JComboBox _moduleList;

    public SmInsertRouteFlow(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.setComponentText(1, "1");
        this.setComponentText(3, "1");
        this.setComponentText(6, "0xffffff");
        ((JCheckBox)this.getComponentAt(2)).addActionListener(this);
        for (int i = 4; i <= 6; ++i) {
            this.setEnabled(i, false);
        }
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.loadModuleList();
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._moduleList = new JComboBox();
            this._moduleList.setEditable(false);
            return this._moduleList;
        }
        if (index == 2) {
            return new JCheckBox("Use DestId, SrcId");
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            int curCardSel = (Integer)this._moduleList.getSelectedItem();
            return new SnmpInt(curCardSel + 21);
        }
        if (index == 2) {
            byte[] b = new byte[1];
            int len = ((JCheckBox)this._values[index]).isSelected() ? 3 : 1;
            int[] selected = new int[len];
            selected[0] = 1;
            if (len > 1) {
                selected[1] = 2;
                selected[2] = 3;
            }
            for (int i = 0; i < selected.length; ++i) {
                SnmpString.setBit(b, selected[i]);
            }
            return new SnmpString(b);
        }
        return super.getComponentValue(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            boolean isSelected = ((JCheckBox)e.getSource()).isSelected();
            this.setEnabled(4, isSelected);
            this.setEnabled(5, isSelected);
            this.setEnabled(6, isSelected);
        } else {
            String cmd = e.getActionCommand();
            switch (cmd.charAt(0)) {
                case 'L': {
                    this.loadModuleList();
                    return;
                }
            }
            super.actionPerformed(e);
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Module:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    void loadModuleList() {
        Card[] cards;
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList<Integer> cardlist = new ArrayList<Integer>();
        if (sw != null && (cards = sw.getCards()) != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null) continue;
                cardlist.add(new Integer(cards[i].getSlotId()));
            }
            if (cardlist.size() != 0) {
                Collections.sort(cardlist);
                Integer[] ssmCardIds = cardlist.toArray(new Integer[cardlist.size()]);
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(ssmCardIds);
                this._moduleList.setModel(model);
                this._moduleList.setSelectedIndex(0);
            }
        }
    }
}

