/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.LinkSecurityUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SmInsertSA
extends InsertForm {
    static final int SID = 0;
    static final int SALT = 1;
    static final int KEY = 2;

    public SmInsertSA(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, true);
        this.setSwVersionSupportedGreaterThanEqual("4.2(0)");
    }

    @Override
    protected void build() throws Exception {
        super.build();
    }

    @Override
    public SnmpPeer[] getValidPeers() {
        if (this._swVersionSupportedGreater != null || this._swVersionSupportedGreaterEqual != null || this._swVersionSupportedLessThan != null || this._swVersionSupportedLessThanEqual != null) {
            ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>();
            for (int i = 0; i < this._peers.length; ++i) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
                boolean isFCSPESPSupport = sw.isContainModules(FRUConstants.getAllFCSP_ESPCapableCardTypes());
                if (!this.isVersionSupported(sw) || !isFCSPESPSupport) continue;
                peersValid.add(this._peers[i]);
            }
            this._peers = peersValid.toArray(new SnmpPeer[0]);
        }
        return this._peers;
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            JButton keyGen = new JButton("Key Generator");
            keyGen.addActionListener(this);
            keyGen.setMargin(DialogUtil.getInsets());
            return new FieldPanel(20, (JComponent)keyGen);
        }
        if (index == 1) {
            JButton keyGen = new JButton("Salt Generator");
            keyGen.addActionListener(this);
            keyGen.setMargin(DialogUtil.getInsets());
            return new FieldPanel(10, (JComponent)keyGen);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        String keyString;
        if (index == 2 && (keyString = this.getComponentText(index)) != null) {
            byte[] b = SnmpString.fromHexString(keyString, keyString.indexOf(58) != -1);
            if (b.length != 16) {
                throw new NumberFormatException("wrong size(16 bytes hex format)");
            }
            return new SnmpString(b);
        }
        return super.getComponentValue(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((JButton)e.getSource()).getText().startsWith("Key")) {
            this.setComponentText(2, LinkSecurityUtil.generateKey());
        } else if (((JButton)e.getSource()).getText().startsWith("Salt")) {
            this.setComponentText(1, Long.toString(LinkSecurityUtil.generateSalt()));
        }
        super.actionPerformed(e);
    }
}

