/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmInsertHideVsan;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;

public class SmInsertSdv
extends SmInsertHideVsan {
    private static int INDEX_MIB = 1;
    private static int NAME_MIB = 2;
    private static int DOMAIN_MIB = 3;
    private static int FCID_MIB = 4;
    private static int OPTION_MIB = 5;

    public SmInsertSdv(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateInputFields();
    }

    void updateInputFields() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isAbove4dot1 = sw.isVersionGreaterThanEqual("4.1(0)");
        this.setComponentVisibleAt(OPTION_MIB, isAbove4dot1);
        this.setEnabled(OPTION_MIB, isAbove4dot1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateInputFields();
                return;
            }
        }
        super.actionPerformed(e);
    }
}

