/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmInsertSdv;
import com.cisco.dcbu.sm.client.dialogs.SmSdvRealDeviceTableModel;
import com.cisco.dcbu.sm.client.dialogs.SmVsanCentricTableModel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertSdvRealDevice
extends SmInsertSdv
implements ItemListener,
ListSelectionListener {
    static final int VSAN_Id = 0;
    static final int VIRTUAL_DEV_ID = 1;
    static final int ID = 2;
    static final int DEV_TYPE = 3;
    static final int DEV_NAME = 4;
    static final int MAP_TYPE = 5;
    static final int DEV_TYPE_PWWN_VALUE = 1;
    static final int DEV_TYPE_DEV_ALIAS_VALUE = 2;
    private JTextField _wwn;
    private JList _list;
    JLabel _wwnLabel;
    private FieldPanel _virutalDevIdListcmbx;
    private HashMap _peer2VirtualDeviceId = new HashMap();
    static final String _PWwnListBoxLabel = "<html><div align=right>Available<br>(WWN)<br>Name:</html>";
    static final String _deviceAliasListBoxLabel = "<html><div align=right>Available<br>Name:</html>";
    static final int[] _cFcSdvVdNameOid = MibNode.get("cFcSdvVdName").getOid();

    public SmInsertSdvRealDevice(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        GroupButtonPanel devType = (GroupButtonPanel)this._values[3];
        devType.addChangeListener(this);
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        if (this._wwnLabel != null) {
            DialogUtil.constrain(this._container, this._wwnLabel, new GridBagConstraints(), 0, 5, 0, 14);
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        switch (index) {
            case 3: {
                return new JLabel("Type:");
            }
            case 4: {
                this._wwnLabel = new JLabel(_PWwnListBoxLabel, 4);
                return this._wwnLabel;
            }
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 4) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            this._list = new JList();
            this._list.addListSelectionListener(this);
            this._list.setSelectionMode(1);
            this._list.setCellRenderer(new WwnCellRenderer());
            JScrollPane sp = new JScrollPane(this._list);
            sp.setPreferredSize(new Dimension(300, 80));
            panel.add("Center", sp);
            this._wwn = new KTextField();
            panel.add("South", this._wwn);
            this.updatePWwnList(this._peers[0]);
            return panel;
        }
        if (index == 1) {
            KTextField tf = new KTextField(50);
            Dimension d = tf.getPreferredSize();
            tf.setColumns(0);
            tf.setPreferredSize(d);
            this._virutalDevIdListcmbx = new FieldPanel(tf, (JComponent)new VirtualDeviceIdButton(null));
            return this._virutalDevIdListcmbx;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        char c = ((JToggleButton)e.getSource()).getText().charAt(0);
        if (((JToggleButton)e.getSource()).getParent() == this._values[3] && this._list != null) {
            if (c == 'p') {
                this.updatePWwnList((SnmpPeer)this._choice.getSelectedItem());
            } else if (c == 'd') {
                this.updateDeviceAliasList((SnmpPeer)this._choice.getSelectedItem());
            }
        }
    }

    ArrayList getEndPortsBySwitch(Switch sw) {
        int vsanId = ((SmVsanCentricTableModel)this._table).getVsanId();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric f = mgmtDomain.getFabric();
        Vsan[] vsans = f.getVsansById(vsanId);
        HashedArrayList<EndPort> ports = new HashedArrayList<EndPort>();
        for (int i = 0; i < vsans.length; ++i) {
            EndPort[] vsanEPorts = vsans[i].getEndPorts();
            for (int j = 0; j < vsanEPorts.length; ++j) {
                ((ArrayList)ports).add(vsanEPorts[j]);
            }
        }
        return ports;
    }

    void updatePWwnList(SnmpPeer peer) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList ports = this.getEndPortsBySwitch(sw);
        if (ports != null) {
            this._list.setListData(ports.toArray(new EndPort[ports.size()]));
        } else {
            this._list.setListData(new EndPort[0]);
        }
        if (this._wwnLabel != null) {
            this._wwnLabel.setText(_PWwnListBoxLabel);
        }
        this._wwn.setText("");
    }

    void updateDeviceAliasList(SnmpPeer peer) {
        int vsanId = ((SmSdvRealDeviceTableModel)this._table).getVsanId();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        Fabric f = mgmtDomain.getFabric();
        ArrayList<DeviceAlias> devAliasList = f.getDeviceAliases(vsanId);
        DeviceAlias[] devAlias = devAliasList.toArray(new DeviceAlias[devAliasList.size()]);
        if (devAlias != null) {
            this._list.setListData(devAlias);
        } else {
            this._list.setListData(new DeviceAlias[0]);
        }
        if (this._wwnLabel != null) {
            this._wwnLabel.setText(_deviceAliasListBoxLabel);
        }
        this._wwn.setText("");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if ((JList)e.getSource() == this._list) {
            Object sel = this._list.getSelectedValue();
            if (sel instanceof EndPort) {
                EndPort ep = (EndPort)sel;
                if (ep != null) {
                    this._wwn.setText(SnmpString.toHexString(ep.getPortWwn().getValue()));
                }
            } else if (sel instanceof DeviceAlias) {
                DeviceAlias devAlias = (DeviceAlias)sel;
                this._wwn.setText(devAlias.getAlias());
            }
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 4) {
            if (this._wwn.getText().length() == 0) {
                throw new Exception("Name: invalid entry");
            }
            SnmpInt type = (SnmpInt)super.getComponentValue(3);
            if (type.getValue() == 2) {
                return new SnmpString(this._wwn.getText());
            }
            return new SnmpWWN(this._wwn.getText(), false);
        }
        return super.getComponentValue(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                GroupButtonPanel grpPanel = (GroupButtonPanel)this._values[3];
                char c = grpPanel.getButton(grpPanel.getSelected()).getText().charAt(0);
                if (c == 'p') {
                    this.updatePWwnList((SnmpPeer)this._choice.getSelectedItem());
                } else if (c == 'd') {
                    this.updateDeviceAliasList((SnmpPeer)this._choice.getSelectedItem());
                }
                return;
            }
        }
        super.actionPerformed(e);
    }

    String[] getVirtualDeviceList(SnmpPeer peer) {
        ArrayList<String> list = new ArrayList<String>();
        SnmpFetch f = new SnmpFetch();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(_cFcSdvVdNameOid, this._table.getTableIndex())));
        try {
            SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
            vbl = resp.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                SnmpVarBind vb = vbl.getVb(i);
                int[] oid = vb.getOid().getValue();
                int virtualDevId = oid[_cFcSdvVdNameOid.length + 1];
                list.add(virtualDevId + ":" + vb.getVar());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return list.toArray(new String[list.size()]);
    }

    class VirtualDeviceIdButton
    extends MenuButton {
        SnmpPeer _peer;

        public VirtualDeviceIdButton(JMenu menu) {
            super(menu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                String source = ((JMenuItem)e.getSource()).getText();
                ((FieldPanel)this.getParent()).setText(source.substring(0, source.indexOf(":")));
                return;
            }
            SnmpPeer selectedPeer = null;
            selectedPeer = SmInsertSdvRealDevice.this._choice != null ? (SnmpPeer)SmInsertSdvRealDevice.this._choice.getSelectedItem() : SmInsertSdvRealDevice.this._peers[0];
            if (selectedPeer != this._peer) {
                this._peer = selectedPeer;
                Object[] virtualDeviceIdList = (String[])SmInsertSdvRealDevice.this._peer2VirtualDeviceId.get(selectedPeer);
                if (virtualDeviceIdList == null) {
                    virtualDeviceIdList = SmInsertSdvRealDevice.this.getVirtualDeviceList(selectedPeer);
                    SmInsertSdvRealDevice.this._peer2VirtualDeviceId.put(selectedPeer, virtualDeviceIdList);
                }
                this.buildMenu(virtualDeviceIdList);
            }
            super.actionPerformed(e);
        }
    }

    class WwnCellRenderer
    extends DefaultListCellRenderer {
        WwnCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            StringBuffer buf = new StringBuffer();
            if (value instanceof EndPort) {
                EndPort ep = (EndPort)value;
                buf.append(ep.toString());
            } else {
                buf.append(value);
            }
            this.setText(buf.toString());
            return retValue;
        }
    }
}

