/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertSmeInterface
extends InsertForm {
    protected int _smeTimeout = 60000;
    static final int CARD = 0;
    static final int NODE = 1;
    static final String VER_STR_4_2_0 = "4.2(0)";
    static final String VER_STR_5_2_6 = "5.2(6)";
    static final int INT_NODE_MAX_NUM = 4;
    JComboBox _moduleList = new JComboBox();
    JComboBox _nodeList = new JComboBox();
    JLabel _nodeLabel = new JLabel("Node:", 4);
    ArrayList<Integer> _cardTypes = new ArrayList();
    boolean _isSSN16Support = false;

    public SmInsertSmeInterface(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._moduleList.setEditable(false);
            this._moduleList.addActionListener(this);
            this._moduleList.setActionCommand("MODULE");
            return this._moduleList;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            return this.getVarFromString(null, index);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Module:");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void layoutForm() {
        if (this.isVersionGreaterThanEqual(VER_STR_4_2_0)) {
            JComponent[] labels = new JLabel[this._labels.length + 1];
            labels[0] = this._labels[0];
            System.arraycopy(this._labels, 1, labels, 2, this._labels.length - 1);
            labels[1] = this._nodeLabel;
            JComponent[] values = new JComponent[this._values.length + 1];
            values[0] = this._values[0];
            System.arraycopy(this._values, 1, values, 2, this._values.length - 1);
            for (int i = 1; i <= 4; ++i) {
                this._nodeList.addItem(i);
            }
            values[1] = this._nodeList;
            DialogUtil.buildPanel(this._container, labels, values);
        } else {
            super.layoutForm();
        }
    }

    protected void updateParamsUponSwitchListChange() {
        this.loadModuleList(this._moduleList);
    }

    protected void updateParamsUponModuleListChange(ActionEvent e) {
        JComboBox cBox = (JComboBox)e.getSource();
        int index = cBox.getSelectedIndex();
        if (this.isSSN16Supported(this._cardTypes.get(index))) {
            this.displayNodeComponent(true);
            this._isSSN16Support = true;
        } else {
            this.displayNodeComponent(false);
            this._isSSN16Support = false;
        }
    }

    @Override
    public SnmpPeer[] getValidPeers() {
        ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>();
        block0: for (int i = 0; i < this._peers.length; ++i) {
            Card[] cards;
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
            if (sw == null) continue;
            for (Card card : cards = sw.getCards()) {
                if (card == null || !this.isValidCard(card)) continue;
                peersValid.add(this._peers[i]);
                continue block0;
            }
        }
        this._peers = peersValid.toArray(new SnmpPeer[0]);
        return super.getValidPeers();
    }

    @Override
    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        if (index == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("sme");
            sb.append(this._moduleList.getSelectedItem());
            if (this._isSSN16Support) {
                sb.append("/");
                sb.append(this._nodeList.getSelectedItem());
            } else {
                sb.append("/1");
            }
            return super.getVarFromString(sb.toString(), index);
        }
        return super.getVarFromString(text, index);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateParamsUponSwitchListChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateParamsUponSwitchListChange();
                return;
            }
            case 'M': {
                this.updateParamsUponModuleListChange(e);
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected boolean isValidCard(Card card) {
        boolean result = card.getType() == 39 || card.getType() == 41 || card.getType() == 44 && this.isVersionGreaterThanEqual(VER_STR_4_2_0);
        return result;
    }

    protected boolean isSSN16Supported(int cardType) {
        boolean result = cardType == 44 && this.isVersionGreaterThanEqual(VER_STR_4_2_0);
        return result;
    }

    protected void loadModuleList(JComboBox moduleList) {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        ArrayList<Integer> cardlist = new ArrayList<Integer>();
        this._cardTypes.clear();
        if (sw != null) {
            Card[] cards;
            for (Card card : cards = sw.getCards()) {
                if (cards == null || !this.isValidCard(card)) continue;
                cardlist.add(new Integer(card.getSlotId()));
                this._cardTypes.add(new Integer(card.getType()));
            }
            if (cardlist.size() != 0) {
                Integer[] ssmCardIds = cardlist.toArray(new Integer[cardlist.size()]);
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(ssmCardIds);
                moduleList.setModel(model);
                moduleList.setSelectedIndex(0);
            }
        }
    }

    private void displayNodeComponent(boolean flag) {
        this._nodeLabel.setVisible(flag);
        this._nodeList.setVisible(flag);
    }

    protected boolean isVersionGreaterThanEqual(String ver) {
        SnmpPeer peer = this._choice != null ? (SnmpPeer)this._choice.getSelectedItem() : this._peers[0];
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        return sw.isVersionGreaterThanEqual(ver);
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        SnmpPDU pdu = super.getInsertPDU(peer, vbl);
        if (this.isVersionGreaterThanEqual(VER_STR_5_2_6)) {
            pdu.setTimeout(this._smeTimeout);
        }
        return pdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(Object o) {
        try {
            Object object = o;
            synchronized (object) {
                o.wait(this._smeTimeout * (SnmpPeer._Retries + 1) + 5000);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

