/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmIpInterfaceTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmIpIfTableModel
extends SmIpInterfaceTableModel {
    static final int MTU_COL = 3;
    static final int CDP_COL = 9;
    static final int ADDR_COL = 10;
    static final int[] _ipPrefixOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();

    public SmIpIfTableModel(int ipIfType, boolean getIPS) {
        super(ipIfType, getIPS);
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[10] = true;
        this.setEditable(isEditable);
    }

    @Override
    protected SnmpPDU buildGetTablePdu(SnmpPeer node, int[] index) {
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList(this._mibNodes.length));
        for (int j = this._offset; j < this._mibNodes.length; ++j) {
            if (j == 10) {
                pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), index[0] + 1));
                continue;
            }
            pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), index));
        }
        return pdu;
    }

    @Override
    public VarBindList buildGetVbl(VarBindList vbl, SnmpPeer node, int[] index) {
        int ifIndex = index[0];
        for (int i = this._offset; i < this._mibNodes.length; ++i) {
            if (i != 10) {
                vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[i].getOid(), ifIndex - 1)));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[i].getOid(), ifIndex)));
        }
        return vbl;
    }

    @Override
    protected void fetchTableCols(SnmpFetch f, SnmpPeer peer, VarBindList vbl) throws SnmpException {
        f.getNext(peer, vbl, this);
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        int[] oid = vb.getOid().getValue();
        int rowIfindex = index.getValue()[0];
        if (col == 9) {
            if (SnmpOID.startsWith(oid, mibNode.getOid()) && oid[oid.length - 1] == rowIfindex) {
                return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
            }
            return Boolean.FALSE;
        }
        if (col == 10) {
            if (vb.getVar().getType() != 5 && oid[_ipPrefixOid.length] == rowIfindex) {
                if (oid[_ipPrefixOid.length + 1] == 1) {
                    SnmpOID ip = new SnmpOID(oid, oid.length - 4, 4);
                    return new SnmpString(ip.toString() + "/" + vb.getVar().toString());
                }
                if (oid[_ipPrefixOid.length + 1] == 2) {
                    return new SnmpString(SnmpIpAddress.toHexString(oid, _ipPrefixOid.length + 3, oid.length) + "/" + vb.getVar().toString());
                }
                return new SnmpString("");
            }
            return new SnmpString("n/a");
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        if (peer != null) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw.isN5K() && this._ifType == 1) {
                return false;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        if (peer != null) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            int[] index = ((SnmpOID)this.getValueAt(row, 1)).getValue();
            int indexType = sw.getType(index[0]);
            if (col == 3) {
                return this._ifType == 1;
            }
            if (col == 9) {
                return indexType == 2 || indexType == 26 || indexType == 5;
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (!changedCellOid.startsWith(_ipPrefixOid)) {
            return super.processChangedCell(cell, pdu, changedCellOid, index);
        }
        int[] indexOid = ((SnmpOID)this.getValueAt(cell._row, 1)).getValue();
        int ifIndex = indexOid[indexOid.length - 1];
        SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
        String newIpAddress = ((SnmpString)changedCellVar).toString();
        if (newIpAddress.equals("")) {
            newIpAddress = "n/a";
        }
        Object[] changed = (Object[])this.getValueAt(cell._row, this.getHeaders().length);
        String oldIpAddress = ((SnmpString)changed[10])._value;
        SharedUtil.getSetIpAddressPDU(pdu, pdu, ifIndex, newIpAddress, oldIpAddress);
        return changedCellVar;
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        int ifType;
        int ifIndex = index[0];
        int[] addrId = vbl.getVb(10 - this._offset).getOid().getValue();
        if (this._ifType == 1 && (IfIndexUtil.getType(ifIndex) == 2 || IfIndexUtil.getType(ifIndex) == 26)) {
            return false;
        }
        if (this._ifType == 2 && IfIndexUtil.getType(ifIndex) == 4 && (ifType = vbl.intValue(vbl.size() - 1)) == 56) {
            addrId[addrId.length - 7] = ifIndex;
            return true;
        }
        return super.isSkip(peer, req, firstVb, index, vbl, reqId);
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        int vsanId;
        int processorId;
        Object[] row = (Object[])this.getData().elementAt(rowN);
        SnmpPeer peer = (SnmpPeer)row[0];
        int ifIndex = this.getIndex(rowN)[0];
        if (IfIndexUtil.getType(ifIndex) == 5) {
            return pdu;
        }
        int[] index = null;
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (IfIndexUtil.getType(ifIndex) == 8 && sw.ifIndex2Card(ifIndex) + 1 == 32) {
            processorId = sw.getSupProcessorId();
            vsanId = this.getIndex(rowN)[0] - 0x8F80000;
        } else {
            int module = sw.ifIndex2Card(ifIndex);
            processorId = sw.getModuleProcessorId(module);
            vsanId = ifIndex & 0xFFF;
        }
        index = new int[]{processorId, 1, vsanId};
        pdu.addVar(new SnmpOID(this.getRowStatus(), index), new SnmpInt(this.getDeleteValue()));
        return pdu;
    }

    @Override
    public SnmpPDU buildGetPdu(SnmpPeer node, int[] index) {
        VarBindList vbl = this.buildGetVbl(node, index);
        SnmpPDU pdu = new SnmpPDU(-95, vbl);
        return pdu;
    }

    @Override
    protected boolean enableDeleteButton(SnmpKTable table) {
        boolean en = super.enableDeleteButton(table);
        int[] sels = table.getSelectedRows();
        boolean vsanType = false;
        for (int i = 0; i < sels.length; ++i) {
            int ifIndex = this.getIndex(sels[i])[0];
            if (IfIndexUtil.getType(ifIndex) != 8) continue;
            vsanType = true;
            break;
        }
        return en && vsanType;
    }

    @Override
    protected boolean removeRow(int row) {
        int ifIndex = this.getIndex(row)[0];
        return IfIndexUtil.getType(ifIndex) == 8;
    }
}

