/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmIscsiInterfaceTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmIscsiTcpTableModel
extends SmIscsiInterfaceTableModel {
    public static final int MIB_iscsiIfTcpLocalTcpPort = 10;
    public static final int MIB_iscsiIfTcpLocalPort = 17;

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean isVer21Above = sw.isVersionGreaterThanEqual("2.1(0)");
        if (!isVer21Above) {
            row[10 + this._offset] = row[17 + this._offset];
        }
        return row;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 17 + this._offset) {
            Object[] rowdata = (Object[])this.getData().elementAt(row);
            SnmpPeer node = (SnmpPeer)rowdata[0];
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            boolean isVer21Above = sw.isVersionGreaterThanEqual("2.1(0)");
            return isVer21Above;
        }
        return super.isCellActive(row, col);
    }
}

