/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SmLmGeneralTableModel
extends SmTableModel
implements ActionListener {
    HashMap _peers2RowN = new HashMap();
    Array _peers2GetCfgStatus;
    HashMap _peers2SpinLock;
    VarBindList _spinLockVB = new VarBindList();
    VarBindList _cfgStatusVB;
    protected Timer _statusTimer;
    static final int[] _clmLicenseFileURI = MibNode.get("clmLicenseFileURI").getOid();
    static final int[] _clmLicenseFileTargetName = MibNode.get("clmLicenseFileTargetName").getOid();
    static final int[] _clmLicenseConfigCommand = MibNode.get("clmLicenseConfigCommand").getOid();
    static final int[] _clmLicenseConfigSpinLock = MibNode.get("clmLicenseConfigSpinLock").getOid();
    static final int CFG_CMD_COL = 4;
    static final int CFG_STATUS_COL = 5;
    static final int CFG_STATUS_DETAIL_COL = 6;
    static final int CFG_CMD_NOSELECTION = 3;
    static final int CFG_STATUS_SUCCESS = 1;
    static final int CFG_STATUS_IN_PROGESS = 2;

    public SmLmGeneralTableModel() {
        this._spinLockVB.add(new SnmpVarBind(new SnmpOID(MibNode.get("clmLicenseConfigSpinLock").getOid(), 0)));
        this._cfgStatusVB = new VarBindList();
        this._cfgStatusVB.add(new SnmpVarBind(new SnmpOID(MibNode.get("clmLicenseConfigCommandStatus").getOid(), 0)));
        this._statusTimer = new Timer(3000, this);
        this._peers2GetCfgStatus = new Array();
        this._peers2SpinLock = new HashMap();
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[6] = false;
        this.setEditable(isEditable);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        row[5] = "";
        row[6] = "";
        this._peers2RowN.put(node, new Integer(this._responseData.size() - 1));
        return row;
    }

    @Override
    public boolean applyChanges() throws Exception {
        this._peers2GetCfgStatus.clear();
        this._peers2SpinLock.clear();
        this._peers2SpinLock.clear();
        this.getSpinLock();
        super.applyChanges(this);
        if (this._peers2GetCfgStatus.size() != 0) {
            this._statusTimer.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSpinLock() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return;
        }
        HashMap<SnmpPeer, SnmpPeer> peersChanged = new HashMap<SnmpPeer, SnmpPeer>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            if (peersChanged.get(node) != null) continue;
            peersChanged.put(node, node);
        }
        this._state = 1;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peersChanged.keySet()) {
                SnmpFetch f = new SnmpFetch();
                try {
                    f.get(peer, this._spinLockVB, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        HashMap pdus = super.buildSendPdus();
        for (SnmpPeer peer : pdus.keySet()) {
            SnmpPDU pdu = (SnmpPDU)pdus.get(peer);
            pdu.addVar(new SnmpOID(_clmLicenseConfigSpinLock, 0), (SnmpInt)this._peers2SpinLock.get(peer));
        }
        return pdus;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2GetCfgStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < this._peers2GetCfgStatus.size(); ++i) {
                SnmpPeer peer = (SnmpPeer)this._peers2GetCfgStatus.elementAt(i);
                SnmpFetch f = new SnmpFetch();
                try {
                    f.get(peer, this._cfgStatusVB, this);
                    this._numOutstanding.increment();
                    continue;
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (this.checkSnmpCallbackErr(peer, pdu, timedOut) || pdu.getVariables().size() <= 0) {
            return;
        }
        SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
        if (firstOid.startsWith(this._firstOid)) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        this._numOutstanding.decrement();
        int rowN = (Integer)this._peers2RowN.get(peer);
        Object[] row = (Object[])this.getData().elementAt(rowN);
        if (timedOut) {
            row[5] = "Failed";
            row[6] = "timedout";
        } else if (pdu.getError() != 0) {
            row[5] = "Failed";
            row[6] = this._state == 5 ? "setErr" : "getErr";
        } else if (this._state == 1) {
            if (firstOid.startsWith(_clmLicenseConfigSpinLock)) {
                SnmpInt spinLock = (SnmpInt)pdu.getVar(0);
                this._peers2SpinLock.put(peer, spinLock);
            } else {
                int status = pdu.getVariables().intValue(0);
                if (status != 2) {
                    String strStatusDetail = MibEnum.getLabel(MibNode.get("clmLicenseConfigCommandStatus").getEnums(), status);
                    row[5] = status == 1 ? "Success" : "Failed";
                    row[6] = strStatusDetail;
                    this._peers2GetCfgStatus.removeElement(peer);
                }
            }
        }
        this.fireTableDataChanged();
        if (this._numOutstanding.get() <= 0) {
            try {
                SyncedInt status = this._numOutstanding;
                synchronized (status) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        int rowN = (Integer)this._peers2RowN.get(peer);
        Object[] row = (Object[])this.getData().elementAt(rowN);
        if (err.length() == 0) {
            row[5] = "inProgress";
            row[6] = "";
            VarBindList vbl = pdu.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                SnmpOID oid = vbl.getVb(i).getOid();
                if (!oid.startsWith(_clmLicenseConfigCommand)) continue;
                this._peers2GetCfgStatus.addElement(peer);
                break;
            }
        } else {
            row[5] = "Failed";
            row[6] = "setErr";
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }
}

