/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.util.HashMap;

public class SmMultiIndexedEditTableModel
extends SmTableModel {
    protected DataView _dataView;
    HashMap _peer2Indeces = new HashMap();
    HashMap _reqId2Index = new HashMap();

    public SmMultiIndexedEditTableModel(DataView view) {
        this._dataView = view;
    }

    @Override
    protected void setViewFilter(SmFilter[] filter) {
        this._dataView._filter = filter;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getNextTableVars(invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getNextTableVars(SmFilter[] invoker) throws SnmpException {
        this._responseData = new Array();
        if (invoker == null || invoker.length == 0) {
            return this._responseData;
        }
        this._reqId2Index.clear();
        this.setViewFilter(invoker);
        this._state = 2;
        this.setData(this._responseData);
        this._timedoutPeers.clear();
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < invoker.length; ++i) {
                SnmpPeer peer;
                if (invoker[i] == null || !this.isVersionSupported(peer = invoker[i].getSnmpPeer())) continue;
                int[][] indices = this.getTableVarsIndices(invoker[i]);
                for (int j = 0; j < indices.length; ++j) {
                    SnmpPDU pdu = this.buildGetTablePdu(peer, indices[j]);
                    int reqId = peer.send(pdu, this);
                    this._reqId2Index.put(new Integer(reqId), indices[j]);
                    this._numOutstanding.increment();
                }
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
            this._tableFiltered = true;
        }
        return this._responseData;
    }

    @Override
    protected int sendGetNextPdu(SnmpPeer node, SnmpPDU pdu) throws SnmpException {
        int oldReqId = pdu.getReqid();
        int reqId = super.sendGetNextPdu(node, pdu);
        if (this._reqId2Index.size() != 0) {
            int[] indices = (int[])this._reqId2Index.get(new Integer(oldReqId));
            this._reqId2Index.remove(new Integer(oldReqId));
            this._reqId2Index.put(new Integer(reqId), indices);
        }
        return reqId;
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        boolean isEnd = super.isEnd(peer, req, vb, index, reqId);
        if (isEnd || this._reqId2Index.size() == 0) {
            return isEnd;
        }
        int[] indices = (int[])this._reqId2Index.get(new Integer(reqId));
        int[] lookupOid = new int[this._firstOid.length + indices.length];
        System.arraycopy(this._firstOid, 0, lookupOid, 0, this._firstOid.length);
        System.arraycopy(indices, 0, lookupOid, this._firstOid.length, indices.length);
        return !SnmpOID.startsWith(lookupOid, vb.getOid().getValue());
    }
}

