/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.sm.client.dialogs.SmPsmTableModel;
import com.cisco.dcbu.sm.client.model.Vsan;

public class SmPsmActionTableModel
extends SmPsmTableModel {
    static final int CLEAR_AUTOLEARN_ACTION_COL = 7;
    static final int CLEAR_AUTOLEARN_IF_COL = 8;
    static final int CLEAR_AUTOLEARN_VSAN = 1;
    static final int CLEAR_AUTOLEARN_IF = 2;

    public SmPsmActionTableModel(int vsanId) {
        super(vsanId);
    }

    public SmPsmActionTableModel(Vsan vsan) {
        super(vsan);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 8) {
            return this.isClearAutoLearnIf(row);
        }
        return super.isCellActive(row, col);
    }

    boolean isClearAutoLearnIf(int row) {
        int autoLearnAction = ((JnmMibEnum)this.getValueAt(row, 7)).getValue();
        return autoLearnAction == 2;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (cell._col == 8) {
            if (this.isClearAutoLearnIf(cell._row)) {
                return super.processChangedCell(cell, pdu, changedCellOid, index);
            }
            return null;
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }
}

