/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;

public class SmPsmTableModel
extends SmTableModel {
    protected Vsan _vsan;
    protected int _vsanId;
    static final int PSM_PortBindDevType_NWWN = 2;
    static final int PSM_PortBindDevType_PWWN = 3;
    static final int PSM_PortBindDevType_SWWN = 4;
    static final int PSM_PortBindSwPortType_FWWN = 1;
    static final int PSM_ACTIVE_FORCEACTIVATE = 3;
    static final int PSM_ACTIVE_FORCEACTIVATE_AUTO_LEARN_OFF = 4;

    public SmPsmTableModel(int vsanId) {
        this._vsanId = vsanId;
    }

    public SmPsmTableModel(Vsan vsan) {
        this._vsan = vsan;
        this._vsanId = this._vsan.getId();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        if (invoker[0].getIndicesCount(0) != 1) {
            return super.getTableVars(invoker);
        }
        SnmpPeer[] peers = super.getWrkingPeers();
        return this._isScalar ? this.getVars(peers) : this.getTableVars(peers);
    }

    @Override
    protected int[] getIndex() {
        int[] index = new int[]{1, this._vsanId};
        return index;
    }

    @Override
    public int[] getIndex(int row) {
        if (this._isScalar) {
            return this.getIndex();
        }
        return super.getIndex(row);
    }

    public int getVsanId() {
        return this._vsanId;
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        boolean isEnd = super.isEnd(peer, req, vb, index, reqId);
        if (!isEnd && this._vsanId != 0 && index.length > 1 && index[1] != this._vsanId) {
            return true;
        }
        return isEnd;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        byte[] sWwn;
        Switch sw;
        if ((var.equals("cpsmFabricBindSwitchWwn") || var.equals("cpsmFabricBindEnfSwitchWwn") || var.equals("cpsmFabricBindDiffSwitchWwn") || var.equals("cpsmFabricBindSwwnR1")) && (sw = ClientController.findFabricSwitchByWwn(new Wwn(sWwn = ((SnmpString)vb.getVar()).getValue()))) != null) {
            return WwnDictionary.get(sWwn) + " (" + sw.getName() + ')';
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }
}

