/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.TimerDialog;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class SmTimersTableModel
extends SmTableModel
implements ActionListener {
    static final int TIMER_R_A_TOV = 1;
    static final int TIMER_D_S_TOV = 2;
    static final int TIMER_E_D_TOV = 3;
    static final int TIMER_TRUNK_PROTOCOL = 8;
    TimerDialog _timerdlg = null;
    private static final String[] NEW_BUTTON = new String[]{null, "Change Timeouts...", "T"};

    public SmTimersTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        JButton changeTimerBtn = dataView.insertButton(0, new String[][]{NEW_BUTTON}, new ActionListener[]{this});
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[1] = false;
        isEditable[3] = false;
        isEditable[2] = false;
        this.setEditable(isEditable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.changeTimers();
        }
    }

    void changeTimers() {
        if (this._responseData.size() != 0) {
            long[] curTimeoutValues = new long[3];
            Object[] row = (Object[])this._responseData.elementAt(0);
            curTimeoutValues[0] = ((SnmpGauge)row[1]).getValue();
            curTimeoutValues[1] = ((SnmpGauge)row[2]).getValue();
            curTimeoutValues[2] = ((SnmpGauge)row[3]).getValue();
            this._timerdlg = new TimerDialog(BrowserFrame.getInstance(), curTimeoutValues);
            this._timerdlg.setVisible(true);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._timerdlg != null) {
            this._timerdlg.dispose();
            this._timerdlg = null;
        }
    }

    @Override
    public boolean isCellActive(int row, int col) {
        Switch sw;
        if (col == 8 && (sw = ClientController.findFabricSwitchByIpAddress(this.getRowPeer(row).getAddress())).isN5K() && sw.isNpvEnabled()) {
            return false;
        }
        return super.isCellActive(row, col);
    }
}

