/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmUtilizationTableModel
extends SmTableModel {
    static final int BOOTFLASH_SIZE = 2;
    static final int PROCESS_RAM_SIZE = 5;
    static final int RAM_SIZE = 6;
    static final int RAM_USED = 7;
    int[] _newProcessRAMSizeOidFor64bit = MibNode.get("ceExtHCProcessorRam").getOid();

    @Override
    public SnmpPDU buildGetPdu(SnmpPeer node, int[] index) {
        int[] flashIndex = new int[]{1, 1};
        VarBindList vbl = new VarBindList();
        for (int i = this._offset; i < this._mibNodes.length; ++i) {
            int[] mibOid = this.getMibOid(node, i);
            if (i >= 5) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                int processorId = sw.getSupProcessorId();
                vbl.add(new SnmpVarBind(new SnmpOID(mibOid, processorId)));
                continue;
            }
            if (i > 2) {
                vbl.add(new SnmpVarBind(new SnmpOID(mibOid, flashIndex)));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(mibOid, 0)));
        }
        SnmpPDU getPdu = new SnmpPDU(-96, vbl);
        return getPdu;
    }

    private int[] getMibOid(SnmpPeer node, int index) {
        if (index == 5) {
            return this.getProcessorRAMOid(node);
        }
        return this._mibNodes[index].getOid();
    }

    private int[] getProcessorRAMOid(SnmpPeer node) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (sw.isN5K() && sw.isVersionGreaterThanEqual("5.0(2)")) {
            return this._newProcessRAMSizeOidFor64bit;
        }
        if (!sw.isN5K() && sw.isVersionGreaterThanEqual("6.2(1)")) {
            return this._newProcessRAMSizeOidFor64bit;
        }
        return this._mibNodes[5].getOid();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        SnmpPeer[] peers = new SnmpPeer[invoker.length];
        for (int i = 0; i < invoker.length; ++i) {
            peers[i] = invoker[i].getSnmpPeer();
        }
        return this.getVars(peers);
    }
}

