/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;

public class UnzonedTableModel
extends SmTableModel {
    static final String[] LABELS = new String[]{"VSAN Id", "Switch Interface", "Name", "FcId"};

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        this.setHeaders(LABELS);
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain) throws SnmpException {
        this._responseData = new Array();
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return this._responseData;
        }
        Vsan v = mgmtDomain.isVsan() ? (Vsan)mgmtDomain : ((EnforcedZone)mgmtDomain).getVsan();
        ArrayList ports = v.getUnzonedPorts();
        for (int i = 0; i < ports.size(); ++i) {
            EndPort ep = (EndPort)ports.get(i);
            Vsan[] vsans = ep.getVsans();
            if (vsans == null) continue;
            for (int vs = 0; vs < vsans.length; ++vs) {
                Object[] row = new Object[LABELS.length];
                row[1] = ep.getSwitch() + " " + ep.getIfIndexName();
                row[0] = Integer.toString(vsans[vs].getVsanId());
                row[2] = ep;
                row[3] = ep.getFcIdAsString();
                this._responseData.addElement(row);
            }
        }
        return this._responseData;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[2];
    }
}

