/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeWizardBase;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardChooserTableModel;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.client.dmmsewizard.WizardInstance;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.common.dto.SSHConfigInfo;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class DmmSeSelectModuleStep
extends WizardPanel {
    public static final String StepTitle = ": Select modules for setup.";
    public static final String StepDespA = "Select one or more ";
    public static final String StepDescB = " capable modules";
    static final String[] _ColLabels = new String[]{"Select", "Switch/Module(Type)"};
    static final int[] _CfsDistCtrl = MibNode.get("cfsDistCtrl").getOid();
    static final int _DISABLE = 2;
    static final int _ENABLED = 1;
    static final String _CfsDistMessage = "DMM / FC-Redirect requires CFS distribution be enabled on the ES/NS/Host and DMM switches.\nWe have detected that CFS distrubution is disabled for the following switches. \n Do you want to continue anyway?";
    private int _instanceID;
    private List<SwitchCardContainer> _allSwitches = new ArrayList<SwitchCardContainer>();
    private KTable _swCardTable;
    private SwitchCardChooserTableModel _swCardTableModel;
    private DmmSeWizardBase.WizardType _type;

    public DmmSeSelectModuleStep(DmmSeWizardBase wizard, int stepNumber, DmmSeWizardBase.WizardType type, int instanceID) {
        super("Step " + stepNumber + StepTitle, StepDespA + (type == DmmSeWizardBase.WizardType.DMM_WIZARD ? "Data Mobility Manager" : type.getName()) + StepDescB, wizard, wizard.getIcon());
        this._instanceID = instanceID;
        this._allSwitches.clear();
        try {
            this._allSwitches.addAll(wizard.getCapableSwitchesForUserSelection());
            if (this._allSwitches.isEmpty()) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "None of the modules are found to be " + type.getName() + " preconfigurable.\n" + "To be eligible for preconfiguration the following must be true for the module:\n" + "- switch is running the minimum supported OS version. \n" + "- " + type.getName() + " is not already enabled.\n" + "- module is of supported blade type.\n" + "- module is up.");
                this.getWizard().dispose();
            }
        }
        catch (Exception e) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Received error while trying to retrieve module list, error:" + e.getMessage());
            this.getWizard().dispose();
        }
        this._type = type;
        this.initialize();
    }

    @Override
    public void doNext() {
        List<SwitchCardContainer> selectedSwitchMods;
        block6: {
            selectedSwitchMods = this._swCardTableModel.getSelectedDDMSwitches();
            if (selectedSwitchMods.isEmpty()) {
                Util.errorMessage((Component)this.getWizard(), new Exception("There are no switch modules selected."));
                return;
            }
            if (this._type == DmmSeWizardBase.WizardType.DMM_WIZARD) {
                try {
                    List<Switch> noCfsDist = this.checkForSwitchesWithNoCfsDistribute(selectedSwitchMods);
                    if (noCfsDist.size() > 0) {
                        JScrollPane scrollList = new JScrollPane(new JList<Object>(noCfsDist.toArray()));
                        Object[] msgObj = new Object[]{_CfsDistMessage, scrollList};
                        int response = JOptionPane.showConfirmDialog(this.getWizard(), msgObj, "Continue?", 0, 2);
                        if (response == 1) {
                            return;
                        }
                    }
                }
                catch (SnmpException se) {
                    int response = JOptionPane.showConfirmDialog(this.getWizard(), "Unable to check that all switches have CFS Distribution enabled.\n Do you want to continue?", "Warning: Continue? ", 0, 1);
                    if (response != 1) break block6;
                    return;
                }
            }
        }
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        ((DmmSeWizardBase)this.getWizard()).setSelectedSwitchModules(selectedSwitchMods);
        List<Switch> selectedSwitches = ((DmmSeWizardBase)this.getWizard()).getSelectedSwitches();
        QuerySSHThread queryTh = new QuerySSHThread(this, selectedSwitches);
        queryTh.start();
    }

    protected List<Switch> checkForSwitchesWithNoCfsDistribute(List<SwitchCardContainer> swCards) throws SnmpException {
        ArrayList<Fabric> fabrics = new ArrayList<Fabric>();
        for (SwitchCardContainer nextSwCard : swCards) {
            Fabric nextFab = nextSwCard.getFabric();
            if (fabrics.contains(nextFab)) continue;
            fabrics.add(nextFab);
        }
        HashMap<SnmpPeer, Switch> allSwitchesToCheck = new HashMap<SnmpPeer, Switch>();
        for (Fabric nextFab : fabrics) {
            Switch[] switches = nextFab.getSwitches();
            for (int index = 0; index < switches.length; ++index) {
                Switch nextSw = switches[index];
                if (!nextSw.isCisco()) continue;
                SnmpPeer nextPeer = nextSw.getPeer();
                if (nextSw == null || nextPeer == null) continue;
                allSwitchesToCheck.put(nextPeer, nextSw);
            }
        }
        SnmpPeer[] peers = allSwitchesToCheck.keySet().toArray(new SnmpPeer[allSwitchesToCheck.size()]);
        VarBindList varBindList = new VarBindList(1);
        varBindList.add(_CfsDistCtrl, 0);
        SnmpAggregrate agg = new SnmpAggregrate();
        SnmpPDU[] pdus = agg.get(peers, varBindList);
        ArrayList<Switch> results = new ArrayList<Switch>();
        for (int index = 0; index < pdus.length; ++index) {
            SnmpPDU nextPdu = pdus[index];
            VarBindList vbl = nextPdu.getVariables();
            int cfsDist = vbl.intValue(0);
            if (cfsDist == 1) continue;
            SnmpPeer rsPeer = nextPdu.getPeer();
            results.add((Switch)allSwitchesToCheck.get(rsPeer));
        }
        return results;
    }

    protected void doNextNoChecking() {
        if (!((WizardInstance)((Object)this.getWizard())).isDisposed(this._instanceID)) {
            this.setDataValid(false);
            super.doNext();
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        }
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    private void initialize() {
        this._swCardTableModel = new SwitchCardChooserTableModel(this._allSwitches, _ColLabels);
        this._swCardTableModel.setEditable(new boolean[]{true, false});
        this._swCardTable = new KTable(this._swCardTableModel);
        DmmSeWizardBase.setColumnWidth(this._swCardTable, new int[]{12, 125});
        this._swCardTable.setSelectionMode(2);
        this._swCardTable.setAutoResizeMode(3);
        this._swCardTable.getTableHeader().addMouseListener(new HeaderListener());
        this._swCardTable.setSortable(true);
        ChangedBooleanCellRenderer booleanRenderer = new ChangedBooleanCellRenderer();
        this._swCardTable.setDefaultRenderer(Boolean.class, booleanRenderer);
        booleanRenderer.setHorizontalAlignment(0);
        ((JLabel)((Object)this._swCardTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        JScrollPane _scrPanel = new JScrollPane(this._swCardTable);
        this.add((Component)_scrPanel, "Center");
    }

    class QuerySSHThread
    extends Thread {
        ProgressWindow progressWindow = null;
        List<Switch> selectedSwitches;
        DmmSeSelectModuleStep callingStep;

        public QuerySSHThread(DmmSeSelectModuleStep step, List<Switch> switches) {
            this.selectedSwitches = switches;
            this.callingStep = step;
            this.progressWindow = new ProgressWindow(DmmSeSelectModuleStep.this.getWizard(), DmmSeSelectModuleStep.this.getWizard().getTitle(), "Retrieving SSH configuration.");
            this.progressWindow.setIndeterminate(true);
            this.progressWindow.start();
        }

        @Override
        public void run() {
            ArrayList<SwitchBase> swBases = new ArrayList<SwitchBase>();
            for (Switch next : this.selectedSwitches) {
                swBases.add(next.getSwitchBase());
            }
            try {
                Map<SwitchBase, SSHConfigInfo> sshInfo = ClientController.getInstance().getDDMServerRif().getSSHConfig(swBases);
                ((DmmSeWizardBase)DmmSeSelectModuleStep.this.getWizard()).setSSHConfigInfo(sshInfo);
                this.progressWindow.stop();
                this.callingStep.doNextNoChecking();
            }
            catch (Exception e) {
                Util.errorMessage((Component)DmmSeSelectModuleStep.this.getWizard(), "Unable to retrieve SSH configuration from all switches.\nUnable to continue at this time.\nError received: " + e.getMessage());
                this.progressWindow.stop();
                DmmSeSelectModuleStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                return;
            }
        }
    }
}

