/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.Arrays;

public class SwitchIPMaskTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;

    public SwitchIPMaskTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public int getSwitchIndex(Switch sw) {
        Array data = this.getData();
        Integer index = -1;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!sw.equals(row[Column.SWITCH.ordinal()])) continue;
            index = i;
            break;
        }
        return index;
    }

    public synchronized void addEntry(Switch sw, SnmpIpAddress ip, int prefix) throws Exception {
        if (this.getSwitchIndex(sw) != -1) {
            throw new Exception("Entry already exists");
        }
        Object[] row = new Object[this.ColumnSize];
        row[Column.SWITCH.ordinal()] = sw;
        row[Column.IPADDR.ordinal()] = ip;
        row[Column.MASK.ordinal()] = prefix;
        this.getData().addElement(row);
        this.fireTableDataChanged();
    }

    public synchronized void deleteEntriesFor(Switch sw) {
        Array data = this.getData();
        Integer index = this.getSwitchIndex(sw);
        if (index != -1) {
            data.removeElementAt(index);
            this.fireTableDataChanged();
        }
    }

    public synchronized void clearAll() {
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public synchronized Switch[] deleteRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return new Switch[0];
        }
        ArrayList<Switch> deletedSwitchRows = new ArrayList<Switch>();
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            Switch result = this.deleteRow(rowIndexes[i], false);
            if (result == null) continue;
            deletedSwitchRows.add(result);
        }
        this.fireTableDataChanged();
        return deletedSwitchRows.toArray(new Switch[deletedSwitchRows.size()]);
    }

    private synchronized Switch deleteRow(int rowIndex, boolean fireDataChanged) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(rowIndex);
        Switch sw = (Switch)row[Column.SWITCH.ordinal()];
        this.getData().removeElementAt(rowIndex);
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
        return sw;
    }

    public static enum Column {
        SWITCH,
        IPADDR,
        MASK;

    }
}

