/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardIpRouteTableModel;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ViewNecessaryRoutesDialog
extends JDialog
implements ActionListener {
    KTable _routeTable;
    SwitchCardIpRouteTableModel _routeTableModel;
    JScrollPane _scrPanel;
    Map<SwitchCardContainer, String> _cardVsanIpMap;
    List<Card> _cardsNeedingRoutes;

    public ViewNecessaryRoutesDialog(JWizard parent, Map<SwitchCardContainer, String> cardVsanIpMap, List<Card> cardsNeedingRoutes) {
        super((Dialog)parent, "Necessary Default Gateways");
        this.setModal(true);
        this._cardVsanIpMap = cardVsanIpMap;
        this._cardsNeedingRoutes = cardsNeedingRoutes;
        this.setSize(550, 400);
        this.setResizable(true);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ViewNecessaryRoutesDialog.this.dispose();
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        JTextArea summaryText = new JTextArea("The following is a list of necessary default gateways, each module needs a default gateway to the switch VSAN 1 IP Address.  The \"Already Exists?\" column indicates if the default gateway exists, only those that don't exist will be created:");
        summaryText.setWrapStyleWord(true);
        summaryText.setEditable(false);
        summaryText.setLineWrap(true);
        summaryText.setOpaque(false);
        summaryText.setFont((Font)UIManager.getDefaults().get("Table.font"));
        summaryText.setPreferredSize(new Dimension(500, 50));
        textPanel.add(summaryText);
        textPanel.add(new DialogSeparator());
        this.add((Component)textPanel, "North");
        JPanel top = new JPanel(new BorderLayout());
        top.setBorder(BorderFactory.createEtchedBorder(1));
        this._routeTableModel = new SwitchCardIpRouteTableModel(new String[]{"Switch,Module", "VSAN 1 IP Address/Mask", "Already existings?"});
        this._routeTableModel.setEditable(new boolean[]{false, false, false});
        this._routeTableModel.setData(this._cardVsanIpMap, this._cardsNeedingRoutes);
        this._routeTable = new KTable(this._routeTableModel);
        this._routeTable.getTableHeader().addMouseListener(new HeaderListener());
        this._routeTable.setSortable(true);
        this._scrPanel = new JScrollPane(this._routeTable);
        top.add((Component)this._scrPanel, "Center");
        this.add((Component)top, "Center");
        JButton b = new JButton("Close");
        b.setActionCommand("C");
        b.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(b);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("C")) {
            this.dispose();
        }
    }
}

