/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.lib.util.TimeWatch;
import com.cisco.dcbu.sm.common.event.QueueListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractTask
implements Runnable,
QueueListener {
    public static final Logger logger = Logger.getLogger(AbstractTask.class);
    protected TimeWatch timer = new TimeWatch();
    protected long taskTimeout = 60000L;
    protected long messageTimeout = 2000L;
    protected String taskName = "Unidentified";
    protected Map<Long, Object> remainingJobs = new HashMap<Long, Object>();
    protected State state = State.INIT;

    public AbstractTask(String taskname) {
        this.taskName = taskname;
    }

    private AbstractTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AbstractTask abstractTask = this;
            synchronized (abstractTask) {
                this.timer.start();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this + " is starting at " + this.timer.getTimeDisplay()));
                }
                this.startTask();
                while (this.isTaskRunning()) {
                    block19: {
                        try {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)(this + " waiting at " + this.timer.getTimeDisplay()));
                            }
                            if (this.messageTimeout > 0L) {
                                this.wait(this.messageTimeout);
                            } else {
                                this.wait();
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)(this + " woke up at " + this.timer.getTimeDisplay()));
                            }
                        }
                        catch (InterruptedException e) {
                            if (!logger.isTraceEnabled()) break block19;
                            logger.trace((Object)(this + " interrupted at " + this.timer.getTimeDisplay()));
                        }
                    }
                    if (this.taskTimeout <= 0L || this.timer.getTime() <= this.taskTimeout) continue;
                    StringBuilder msg = new StringBuilder(this + " task timeout at " + this.timer.getTimeDisplay());
                    if (this.remainingJobs.size() > 0) {
                        msg.append("\n\nRemaining status not received: \n");
                        for (long id : this.remainingJobs.keySet()) {
                            msg.append("Request " + id + " for " + this.remainingJobs.get(id) + "\n\n");
                        }
                    }
                    throw new Exception(msg.toString());
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)(this + " cannot complete with exception " + ex));
            this.handleException(ex);
        }
        finally {
            this.timer.stop();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + " stopping at " + this.timer.getTimeDisplay()));
            }
            this.endTask();
        }
    }

    protected void handleException(Exception e) {
        this.setState(State.END);
        this.updateFailStatus(e);
    }

    public boolean isTaskRunning() {
        return this.getState() != State.END;
    }

    protected State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public boolean isStarted() {
        return this.getState() == State.INIT;
    }

    public boolean isEnded() {
        return this.getState() == State.END;
    }

    protected abstract void startTask() throws Exception;

    protected abstract void endTask();

    protected abstract void updateFailStatus(Exception var1);

    protected abstract void updateStatus(String var1);

    public String toString() {
        return this.taskName;
    }

    public static enum State {
        INIT("Init"),
        RUNNING("Running"),
        END("End"),
        CLOSE("Close");

        private String name;

        private State(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

