/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fa.FACfgComparator;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.view.RadioTable;
import com.cisco.dcbu.sm.client.fa.view.ReplaceTableModel;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.CardLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FAReplaceController
implements ItemListener {
    public static final int ALL = 0;
    public static final int UP = 1;
    public static final int AUTO_OR_DOWN = 2;
    private CardLayout card;
    private JPanel panel;
    private Map<SwitchBase, List<FlexAtahCfg>> faCfg;
    private Map<SwitchBase, KTable> tableMap = new HashMap<SwitchBase, KTable>();
    private SwitchBase current;
    private int state;

    public FAReplaceController(CardLayout card, JPanel panel, Map<SwitchBase, List<FlexAtahCfg>> faCfg, int state) {
        this.card = card;
        this.panel = panel;
        this.faCfg = faCfg;
        this.state = state;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ArrayList<FlexAtahCfg> newList;
        SwitchBase sw = (SwitchBase)e.getItem();
        if (this.tableMap.containsKey(sw)) {
            this.card.show(this.panel, sw.getName());
            this.current = sw;
            return;
        }
        List<FlexAtahCfg> cfg = this.faCfg.get(sw);
        if (this.state == 1) {
            newList = new ArrayList<FlexAtahCfg>();
            for (FlexAtahCfg c : cfg) {
                String admin = MibEnum.getLabel(FAClientHelper.adminStatEnums, c.getOperStatus());
                if (!"up".equalsIgnoreCase(admin)) continue;
                newList.add(c);
            }
            cfg = newList;
        } else if (this.state == 2) {
            newList = new ArrayList();
            for (FlexAtahCfg c : cfg) {
                String admin = MibEnum.getLabel(FAClientHelper.adminStatEnums, c.getOperStatus());
                if ("up".equalsIgnoreCase(admin)) continue;
                newList.add(c);
            }
            cfg = newList;
        }
        KTable table = this.createReplaceTable(sw, cfg);
        JScrollPane scroller = new JScrollPane(table);
        this.panel.add(sw.getName(), scroller);
        this.tableMap.put(sw, table);
        this.card.show(this.panel, sw.getName());
        this.current = sw;
    }

    private KTable createReplaceTable(SwitchBase sw, List<FlexAtahCfg> cfgs) {
        Collections.sort(cfgs, new FACfgComparator());
        ReplaceTableModel model = new ReplaceTableModel(sw, cfgs);
        RadioTable table = new RadioTable(model);
        return table;
    }

    public boolean stopCellEditing() {
        KTable table = this.tableMap.get(this.current);
        if (table == null) {
            return true;
        }
        table.getEditingColumn();
        return true;
    }

    public FlexAtahCfg getSelection() {
        RadioTable table = (RadioTable)this.tableMap.get(this.current);
        ReplaceTableModel model = (ReplaceTableModel)table.getModel();
        if (!this.hasSelection()) {
            return null;
        }
        int row = table.getSelectedRow();
        return model.getDataAt(row);
    }

    public boolean hasSelection() {
        RadioTable table = (RadioTable)this.tableMap.get(this.current);
        return table.getSelectedRowCount() == 1;
    }

    public void removeFromTable(SwitchBase sw, int ifIndex) {
        RadioTable table = (RadioTable)this.tableMap.get(sw);
        if (table != null) {
            int row = table.getSelectedRow();
            int selectedCol = table.getSelectedColumn();
            int selectedIfIndex = -1;
            ReplaceTableModel model = (ReplaceTableModel)table.getModel();
            if (row >= 0 && row < table.getRowCount()) {
                selectedIfIndex = model.getDataAt(row).getIfIndex();
            }
            model.remove(ifIndex);
            if (ifIndex != selectedIfIndex) {
                Array _data = model.getData();
                for (int i = 0; i < _data.size(); ++i) {
                    Object[] val = (Object[])_data.elementAt(i);
                    FlexAtahCfg cfg = (FlexAtahCfg)val[ReplaceTableModel.Column.values().length + 2];
                    if (cfg.getIfIndex() != selectedIfIndex) continue;
                    table.getSelectionModel().setSelectionInterval(i, i);
                    if (selectedCol < 0 || selectedCol >= table.getColumnCount()) break;
                    table.getColumnModel().getSelectionModel().setSelectionInterval(selectedCol, selectedCol);
                    break;
                }
            }
        }
    }
}

