/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.client.fa.AbstractTask;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.client.fa.wizard.ReplaceDestStep;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;

public class MoveTask
extends AbstractTask {
    public static final String TASK = "Move";
    protected SwitchBase sw;
    protected SwitchBase toSw;
    protected FlexAtahCfg fromCfg;
    protected FlexAtahCfg toCfg;
    protected Wwn sFromVPWWN;
    protected boolean delVPWWN;
    protected SnmpUserOpt userOptFrom;
    protected SnmpUserOpt userOptTo;
    private PtoPEventHandler handler;
    protected ReplaceDestStep step;
    protected FAPreConfigFinishPanel progress;
    protected boolean failed = false;

    public MoveTask(SwitchBase fromSw, FlexAtahCfg fromCfg, SwitchBase toSw, FlexAtahCfg toCfg, Wwn serverVPWWNFrom, SnmpUserOpt snmpUserOptFrom, SnmpUserOpt snmpUserOptTo, FAPreConfigFinishPanel progressPanel) {
        super(TASK);
        this.sw = fromSw;
        this.fromCfg = fromCfg;
        this.toSw = toSw;
        this.toCfg = toCfg;
        this.sFromVPWWN = serverVPWWNFrom;
        this.userOptFrom = snmpUserOptFrom;
        this.userOptTo = snmpUserOptTo;
        this.progress = progressPanel;
    }

    @Override
    public void startTask() throws Exception {
        try {
            if (!this.isStarted()) {
                this.failed = true;
                throw new IllegalStateException(this + " is in an illegal state. It has already been started.");
            }
            this.handler = PtoPEventFactory.getInstance().getPtoPHandler("jms/queue/FlexAtah", this);
            if (this.handler == null) {
                this.failed = true;
                throw new Exception(this + " cannot communicate with remote");
            }
            long requestID = -1L;
            this.setState(AbstractTask.State.RUNNING);
            this.progress.postMessage("Applying flex attach configuration...");
            this.progress.postMessage("Source: " + this.sw.getSysName() + " - " + this.sw.ifIndexToName(this.fromCfg.getIfIndex()) + " (VSAN " + this.fromCfg.getPortVsan() + ")");
            this.progress.postMessage("Target: " + this.toSw.getSysName() + " - " + this.toSw.ifIndexToName(this.toCfg.getIfIndex()) + " (VSAN " + this.toCfg.getPortVsan() + ")");
            if (this.fromCfg.getPortVsan() != this.toCfg.getPortVsan()) {
                this.progress.postMessage("New target port VSAN: " + this.fromCfg.getPortVsan());
            }
            this.progress.postMessage("Moving server from source to target...");
            requestID = FAClientHelper.getRemote().moveFlexAttachToEmptyPort(this.sw, this.fromCfg.getIfIndex(), this.toSw, this.toCfg.getIfIndex(), this.sFromVPWWN, this.userOptFrom, this.userOptTo, this.handler.getCommunicationObject());
            if (requestID < 0L) {
                throw new Exception("Unable to create request.");
            }
            this.remainingJobs.put(requestID, this.sw);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("setting flex attach cfg, request ID = " + requestID));
                logger.trace((Object)("From " + this.sw.getSysName() + " " + this.fromCfg.getIfIndex() + " with VSAN " + this.fromCfg.getPortVsan() + " vPWWN " + this.sFromVPWWN + " to " + this.toSw.getSysName() + " " + this.toCfg.getIfIndex() + " " + "Handler: " + this.handler));
            }
        }
        catch (Exception ex) {
            this.failed = true;
            logger.warn((Object)(this + " failed to start: "), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected void endTask() {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + " task ending"));
            }
            this.setState(AbstractTask.State.END);
            if (this.handler != null) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + " closing P2P queue: " + this.handler));
                    }
                    try {
                        FAClientHelper.getRemote().destroyPtoPQueue(this.handler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        logger.error((Object)"error cleaning up P to P Queue on Server");
                    }
                    this.handler.stop();
                }
                catch (Exception ex) {
                    logger.debug((Object)"Exception caught closing P2P queue", (Throwable)ex);
                }
            }
            this.handler = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void updateFailStatus(Exception error) {
        this.progress.postError(error.getMessage() + "\n");
    }

    protected void updateFailStatus(String msg) {
        this.progress.postError(msg + "\n");
    }

    @Override
    protected void updateStatus(String msg) {
        this.progress.updateProgress(1);
        this.progress.postMessage(msg + "\n");
    }

    @Override
    public void onMessage(Object event) {
        QueueResponseObject response = (QueueResponseObject)event;
        Exception ex = response.getException();
        String status = response.getStatusStr();
        if (this.remainingJobs.get(response.getRequestId()) == null) {
            logger.info((Object)("[MoveTask] Unidentified message " + response.getRequestId() + " received."));
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[MoveTask] message " + response.getRequestId() + " received."));
        }
        SwitchBase rSw = (SwitchBase)this.remainingJobs.get(response.getRequestId());
        String name = rSw.getSysName();
        if (ex == null) {
            this.updateStatus("Configuration applied: " + status);
        } else {
            this.updateFailStatus("Error: " + ex.getMessage());
            this.failed = true;
        }
        this.remainingJobs.remove(response.getRequestId());
        if (this.remainingJobs.size() <= 0) {
            this.endTask();
        }
    }

    public boolean isFailed() {
        return this.failed;
    }
}

