/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fa.AbstractTask;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PreConfigWwnTask
extends AbstractTask {
    protected static final String TASK = "Pre Configure";
    protected FAPreConfigFinishPanel step;
    protected List<SwitchBase> switches;
    protected List<List<FlexAtahVPWWN>> vPWWNList;
    protected List<SnmpUserOpt> snmpUserOpts;
    private PtoPEventHandler handler;
    private List<SwitchBase> trackSwitches;
    private long requestID = -1L;
    private int numProgress;
    private int totalProgress = 1;

    public PreConfigWwnTask(FAPreConfigFinishPanel step, List<SwitchBase> switches, List<List<FlexAtahVPWWN>> vPWWNList, List<SnmpUserOpt> snmpUserOpts) {
        super(TASK);
        this.step = step;
        this.switches = switches;
        this.vPWWNList = vPWWNList;
        this.snmpUserOpts = snmpUserOpts;
    }

    public PreConfigWwnTask(FAPreConfigFinishPanel step, Map<SwitchBase, List<FlexAtahVPWWN>> wwnMap) {
        super(TASK);
        this.step = step;
        this.snmpUserOpts = this.snmpUserOpts;
        if (wwnMap == null) {
            throw new IllegalArgumentException("Virtual PWWN to PWWN mapping is null");
        }
        this.switches = new ArrayList<SwitchBase>();
        this.vPWWNList = new ArrayList<List<FlexAtahVPWWN>>();
        this.snmpUserOpts = new ArrayList<SnmpUserOpt>();
        if (wwnMap != null) {
            for (SwitchBase sw : wwnMap.keySet()) {
                this.switches.add(sw);
                this.vPWWNList.add(wwnMap.get(sw));
                ClientController.getInstance();
                this.snmpUserOpts.add(ClientController.findFabricSwitchByWwn(sw.getWwn()).getFabric().getSnmpUserOpt());
            }
        }
    }

    @Override
    public void startTask() throws Exception {
        try {
            if (!this.isStarted()) {
                throw new IllegalStateException(this + " is in an illegal state. It has already been started.");
            }
            this.handler = PtoPEventFactory.getInstance().getPtoPHandler("jms/queue/FlexAtah", this);
            if (this.handler == null) {
                throw new Exception(this + " cannot communicate with remote");
            }
            this.step.postMessage("Configuring virtual PWWN \n");
            this.createTrackerList();
            this.requestID = FAClientHelper.getRemote().setFlexAtahVPWWN(this.switches, this.vPWWNList, this.snmpUserOpts, this.handler.getCommunicationObject());
            if (this.requestID < 0L) {
                throw new Exception("Unable to create request.");
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("setting virtual PWWN, request ID = " + this.requestID));
                logger.trace((Object)(this.switches.toString() + " VPWWNList: " + this.vPWWNList.toString() + " Handler: " + this.handler));
            }
        }
        catch (Exception ex) {
            logger.warn((Object)(this + " failed to start: "), (Throwable)ex);
            throw ex;
        }
    }

    private void createTrackerList() {
        this.trackSwitches = new ArrayList<SwitchBase>();
        for (SwitchBase sw : this.switches) {
            this.trackSwitches.add(sw);
        }
    }

    @Override
    protected void endTask() {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + " task ending"));
            }
            this.setState(AbstractTask.State.END);
            if (this.handler != null) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + " closing P2P queue: " + this.handler));
                    }
                    try {
                        FAClientHelper.getRemote().destroyPtoPQueue(this.handler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                    }
                    this.handler.stop();
                }
                catch (Exception ex) {
                    logger.debug((Object)"Exception caught closing P2P queue", (Throwable)ex);
                }
            }
            this.handler = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void updateFailStatus(Exception error) {
        this.step.postError(error.getMessage() + "\n");
    }

    protected void updateFailStatus(String msg) {
        this.step.postError(msg + "\n");
    }

    @Override
    protected void updateStatus(String msg) {
        this.step.updateProgress(1);
        this.step.postMessage(msg + "\n");
    }

    @Override
    protected void handleException(Exception e) {
        this.setState(AbstractTask.State.END);
        this.updateFailStatus(e);
    }

    @Override
    public void onMessage(Object event) {
        QueueResponseObject response = (QueueResponseObject)event;
        if (this.requestID != response.getRequestId()) {
            logger.info((Object)("[PreConfigWwnTask] Unidentified message " + response.getRequestId() + " received."));
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[PreConfigWwnTask] message " + response.getRequestId() + " received."));
        }
        Exception ex = response.getException();
        String status = response.getStatusStr();
        SwitchBase sw = response.getSwitchBase();
        if (this.trackSwitches.contains(sw)) {
            if (ex == null) {
                this.updateStatus("Configuration for " + sw.getName() + " applied: " + status);
            } else {
                this.updateFailStatus("Error: " + ex.getMessage());
            }
            this.trackSwitches.remove(sw);
        }
        if (this.trackSwitches.size() <= 0) {
            this.setState(AbstractTask.State.END);
        }
    }
}

