/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.client.fa.AbstractTask;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;

public class VerifyTask
extends AbstractTask {
    public static final String TASK = "Verify";
    protected SwitchBase toSw;
    protected FlexAtahCfg toCfg;
    protected Wwn sFromVPWWN;
    protected SnmpUserOpt userOptTo;
    private PtoPEventHandler handler;
    protected FAPreConfigFinishPanel progress;

    public VerifyTask(SwitchBase toSw, FlexAtahCfg toCfg, Wwn WWN, SnmpUserOpt userOptTo, FAPreConfigFinishPanel progress) {
        super(TASK);
        this.toSw = toSw;
        this.toCfg = toCfg;
        this.sFromVPWWN = WWN;
        this.userOptTo = userOptTo;
        this.progress = progress;
    }

    @Override
    public void startTask() throws Exception {
        try {
            if (!this.isStarted()) {
                throw new IllegalStateException(this + " is in an illegal state. It has already been started.");
            }
            this.progress.postMessage("Verifying server on " + this.toSw.getSysName() + " - " + this.toSw.ifIndexToName(this.toCfg.getIfIndex()) + "...");
            this.handler = PtoPEventFactory.getInstance().getPtoPHandler("jms/queue/FlexAtah", this);
            if (this.handler == null) {
                throw new Exception(this + " cannot communicate with remote");
            }
            this.setState(AbstractTask.State.RUNNING);
            long requestID = FAClientHelper.getRemote().verifyFlexAttachUp(this.toSw, this.toCfg.getIfIndex(), this.sFromVPWWN, this.userOptTo, this.handler.getCommunicationObject());
            if (requestID <= 0L) {
                throw new Exception("Invalid request ID...unable to create request.");
            }
            this.remainingJobs.put(requestID, this.toSw);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("setting flex attach cfg, request ID = " + requestID));
            }
        }
        catch (Exception ex) {
            logger.warn((Object)(this + " failed to start: "), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected void endTask() {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + " task ending"));
            }
            this.setState(AbstractTask.State.END);
            if (this.handler != null) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + " closing P2P queue: " + this.handler));
                    }
                    try {
                        FAClientHelper.getRemote().destroyPtoPQueue(this.handler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        logger.error((Object)"error cleaning up P to P Queue on Server");
                    }
                    this.handler.stop();
                }
                catch (Exception ex) {
                    logger.debug((Object)"Exception caught closing P2P queue", (Throwable)ex);
                }
            }
            this.handler = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void updateFailStatus(Exception error) {
        this.progress.postError(error.getMessage() + "\n");
    }

    protected void updateFailStatus(String msg) {
        this.progress.postError(msg + "\n");
    }

    @Override
    protected void updateStatus(String msg) {
        this.progress.updateProgress(1);
        this.progress.postMessage(msg + "\n");
    }

    @Override
    public void onMessage(Object event) {
        QueueResponseObject response = (QueueResponseObject)event;
        Exception ex = response.getException();
        String status = response.getStatusStr();
        long requestID = response.getRequestId();
        SwitchBase sw = (SwitchBase)this.remainingJobs.get(requestID);
        if (sw == null) {
            logger.info((Object)("[VerifyTask] Unidentified message " + requestID + " received."));
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[VerifyTask] message " + response.getRequestId() + " received."));
        }
        String name = sw.getName();
        if (ex == null) {
            this.updateStatus("Configuration for " + name + " verified.");
        } else {
            this.updateFailStatus("Error: " + ex.getMessage());
        }
        this.remainingJobs.remove(requestID);
        if (this.remainingJobs.size() <= 0) {
            this.endTask();
        }
    }
}

