/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.view;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdvancedTableModel
extends KTableModel {
    @Override
    public boolean isCellEditable(int row, int col) {
        boolean editable = super.isCellEditable(row, col);
        boolean editableCol = true;
        if (col == Column.vPWWN.ordinal()) {
            String faType = (String)this.getValueAt(row, Column.FAType.ordinal());
            Object[] val = (Object[])this.getData().elementAt(row);
            FlexAtahCfg cfg = (FlexAtahCfg)val[Column.values().length + 2];
            String portType = FAClientHelper.getAdminPort(cfg);
            editableCol = !"Auto".equalsIgnoreCase(faType) && "F".equals(portType);
        } else if (col == Column.Vsan.ordinal() || col == Column.FAType.ordinal() || col == Column.Status.ordinal()) {
            Object[] val = (Object[])this.getData().elementAt(row);
            FlexAtahCfg cfg = (FlexAtahCfg)val[Column.values().length + 2];
            String portType = FAClientHelper.getAdminPort(cfg);
            editableCol = "F".equals(portType);
        }
        return editable && editableCol;
    }

    public AdvancedTableModel() {
        String[] HEADERS = new String[Column.values().length];
        Column[] vals = Column.values();
        for (int i = 0; i < vals.length; ++i) {
            HEADERS[i] = vals[i].title();
        }
        this.setHeaders(HEADERS);
        this.setEditable(new boolean[]{false, false, true, true, true, true});
    }

    public void setData(SwitchBase sw, List<FlexAtahCfg> cfgs) {
        Array<Object[]> _data = this.getData();
        if (_data != null) {
            _data.clear();
        } else {
            _data = new Array<Object[]>();
        }
        for (FlexAtahCfg cfg : cfgs) {
            Object[] row = this.toRow(sw, cfg);
            _data.addElement(row);
        }
        this.setData(_data);
        this.fireTableDataChanged();
    }

    public void setData(Map<SwitchBase, List<FlexAtahCfg>> swMap) {
        Array<Object[]> _data = this.getData();
        if (_data != null) {
            _data.clear();
        } else {
            _data = new Array<Object[]>();
        }
        for (SwitchBase sw : swMap.keySet()) {
            List<FlexAtahCfg> cfgs = swMap.get(sw);
            for (FlexAtahCfg cfg : cfgs) {
                Object[] row = this.toRow(sw, cfg);
                _data.addElement(row);
            }
        }
        this.setData(_data);
        this.fireTableDataChanged();
    }

    private Object[] toRow(SwitchBase sw, FlexAtahCfg config) {
        Object[] val = new Object[Column.values().length + 3];
        val[Column.Desc.ordinal()] = config.getIfName();
        val[Column.FAType.ordinal()] = config.getIsAuto() ? "Auto" : "Manual";
        val[Column.Interface.ordinal()] = sw.ifIndexToName(config.getIfIndex());
        val[Column.Status.ordinal()] = MibEnum.getLabel(FAClientHelper.adminStatEnums, config.getAdminStatus());
        val[Column.vPWWN.ordinal()] = new SnmpWWN(config.getIfVPWWN().getValue());
        val[Column.Vsan.ordinal()] = config.getPortVsan();
        val[Column.values().length] = null;
        val[Column.values().length + 1] = sw;
        val[Column.values().length + 2] = config;
        return val;
    }

    @Override
    protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
        Object[] params;
        Class[] types;
        Class c = this.getColumnClass(row, col);
        Constructor con = c.getConstructor(types = new Class[]{aValue.getClass()});
        Object newValue = con.newInstance(params = new Object[]{aValue});
        if (newValue == null || newValue.toString() == null) {
            return;
        }
        this.markUndo(row, col, aValue);
        values[col] = newValue;
    }

    public Object[] getChangedRow(int row) {
        if (this.getEditable() == null || row >= this.getData().size()) {
            return null;
        }
        Object changed = ((Object[])this.getData().elementAt(row))[this.getHeaders().length];
        return (Object[])changed;
    }

    public List<FlexAtahCfg> getChangedConfig() {
        ArrayList<FlexAtahCfg> ret = new ArrayList<FlexAtahCfg>();
        Array cells = this.getChanged();
        Array _data = this.getData();
        if (cells == null) {
            return ret;
        }
        int previous = -1;
        for (int i = 0; i < cells.size(); ++i) {
            int row = ((Cell)cells.elementAt((int)i))._row;
            if (row == previous) continue;
            Object[] val = (Object[])_data.elementAt(row);
            SwitchBase sw = (SwitchBase)val[Column.values().length + 1];
            FlexAtahCfg config = (FlexAtahCfg)val[Column.values().length + 2];
            int ifIndex = sw.nameToIfIndex((String)val[Column.Interface.ordinal()]);
            int operMode = config.getAdminMode();
            String ifName = config.getIfName();
            int adminStatus = MibEnum.getValue(FAClientHelper.adminStatEnums, (String)val[Column.Status.ordinal()]);
            int operStatus = config.getOperStatus();
            int portVsan = (Integer)val[Column.Vsan.ordinal()];
            boolean isAuto = "Auto".equals((String)val[Column.FAType.ordinal()]);
            Wwn ifVPWWN = isAuto ? config.getIfVPWWN() : new Wwn(((SnmpWWN)val[Column.vPWWN.ordinal()]).getValue());
            FlexAtahCfg cfg = new FlexAtahCfg(ifIndex, operMode, ifName, adminStatus, operStatus, portVsan, isAuto, ifVPWWN, config.getIsAuto(), config.getIfVPWWN());
            ret.add(cfg);
            previous = row;
        }
        return ret;
    }

    static enum Column {
        Interface(8, "Interface"),
        Desc(10, "Description"),
        Status(8, "Status Admin"),
        Vsan(5, "VSAN"),
        FAType(5, "Auto"),
        vPWWN(15, "Interface vPWWN");

        int width;
        String name;

        private Column(int colWidth, String n2) {
            this.width = colWidth;
            this.name = n2;
        }

        public String title() {
            return this.name;
        }

        public int getValue() {
            return this.width;
        }
    }
}

