/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.view;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fa.AdvancedConfig;
import com.cisco.dcbu.sm.client.fa.view.AdminStatusEditor;
import com.cisco.dcbu.sm.client.fa.view.AdvancedTableModel;
import com.cisco.dcbu.sm.client.fa.view.FATypeEditor;
import com.cisco.dcbu.sm.client.fa.view.PListModel;
import com.cisco.dcbu.sm.client.fa.view.VPWWNTableModel;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class ListListener
extends JLabel
implements ListSelectionListener,
ActionListener,
TableModelListener,
ListCellRenderer,
MouseListener {
    protected Map<SwitchBase, List<FlexAtahCfg>> swMap;
    protected Map<SwitchBase, List<FlexAtahVPWWN>> wwnMap;
    protected Map<SwitchBase, List<Integer>> vsans;
    protected CardLayout cards;
    protected JPanel parent;
    protected JList list;
    protected Map<SwitchBase, AdvTablePanel> cardMap;
    protected SwitchBase current;
    protected Boolean initFaAuto;
    protected Map<SwitchBase, Array> vOrigMap = new HashMap<SwitchBase, Array>();
    protected Map<SwitchBase, Boolean> faAutos;

    public ListListener(JList list) {
        this.list = list;
        this.cardMap = new HashMap<SwitchBase, AdvTablePanel>();
    }

    public void updateValue(CardLayout cards, JPanel parent, Map<SwitchBase, List<FlexAtahCfg>> swMap, Map<SwitchBase, List<FlexAtahVPWWN>> wwnMap, Map<SwitchBase, List<Integer>> vsans, Map<SwitchBase, Boolean> faAutos) {
        this.cards = cards;
        this.parent = parent;
        this.swMap = swMap;
        this.wwnMap = wwnMap;
        this.vsans = vsans;
        this.faAutos = faAutos;
        this.addFirst();
    }

    public void addFirst() {
        this.list.setSelectedIndex(0);
    }

    private SnmpKTable createVPWwnTable(SwitchBase sw, List<FlexAtahVPWWN> vMap) {
        VPWWNTableModel model = new VPWWNTableModel();
        model.addTableModelListener(this);
        model.setHeaders(new String[]{"pWWN", "Virtual pWWN"});
        model.setEditable(new boolean[]{false, true});
        final SnmpKTable table = new SnmpKTable(model){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (e.getActionCommand().charAt(0)) {
                    case 'C': {
                        this.copy();
                        break;
                    }
                    case 'V': {
                        this.paste();
                        break;
                    }
                    case 'Z': {
                        ((KTableModel)this.getModel()).undo();
                        Array data = ((KTableModel)this.getModel()).getData();
                        if (data == null) break;
                        for (int i = data.size() - 1; i >= 0; --i) {
                            Object[] val = (Object[])data.elementAt(i);
                            if (val[0] != null && !"".equals(val[0]) && val[1] != null && !"".equals(val[1])) continue;
                            data.removeElementAt(i);
                        }
                        break;
                    }
                    case 'P': {
                        try {
                            this.print("job");
                        }
                        catch (PrinterException ex) {
                            Util.errorMessage((Component)this, ex);
                        }
                        break;
                    }
                    case 'E': {
                        String fName = Util.getFileName(Util.getFrameAncestor(this), "*.txt", 1);
                        if (fName == null) break;
                        this.export(fName);
                    }
                }
            }
        };
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        DefaultCellEditor wwnEditor = new DefaultCellEditor(new JTextField()){

            @Override
            public boolean stopCellEditing() {
                if (!table.isEditing()) {
                    return super.stopCellEditing();
                }
                String val = (String)this.getCellEditorValue();
                try {
                    SnmpWWN wwn = new SnmpWWN(val);
                    if (wwn == null || wwn.getValue() == null) {
                        throw new Exception("wwn is null");
                    }
                    int row = table.getEditingRow();
                    Wwn pWwn = (Wwn)table.getValueAt(row, 0);
                    if (pWwn.toString().equals(val)) {
                        this.cancelCellEditing();
                        JOptionPane.showMessageDialog(ListListener.this.getParent(), "Real Port WWN and virtual WWN cannot be the same.", "Flex Attach: Pre-Configure Server", 0);
                        return false;
                    }
                }
                catch (Exception ex) {
                    table.editingStopped(null);
                    int row = table.getEditingRow();
                    if (row != -1) {
                        table.setRowSelectionInterval(row, row);
                        if (((SnmpWWN)table.getValueAt(row, 1)).toString().equals(val)) {
                            return super.stopCellEditing();
                        }
                    }
                    return false;
                }
                return super.stopCellEditing();
            }
        };
        table.getColumnModel().getColumn(1).setCellEditor(wwnEditor);
        Array<Object[]> data = new Array<Object[]>();
        Set<SwitchBase> keys = this.wwnMap.keySet();
        if (vMap != null) {
            for (int i = 0; i < vMap.size(); ++i) {
                Object[] obj = new Object[3];
                obj[0] = vMap.get(i).getSvrWWN();
                obj[1] = new SnmpWWN(vMap.get(i).getSvrVPWWN().getValue());
                data.addElement(obj);
            }
        }
        model.setData(data);
        model.fireTableDataChanged();
        return table;
    }

    private SnmpKTable createFaTable(SwitchBase sw, List<FlexAtahCfg> cfgs, List<Integer> vsans) {
        AdvancedTableModel.Column[] cols;
        AdvancedTableModel tm = new AdvancedTableModel();
        final SnmpKTable table = new SnmpKTable(tm);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        TableColumnModel tcm = table.getColumnModel();
        for (AdvancedTableModel.Column col : cols = AdvancedTableModel.Column.values()) {
            tcm.getColumn(col.ordinal()).setPreferredWidth(col.getValue() * 10);
        }
        String[] vsanStrs = new String[vsans.size()];
        for (int i = 0; i < vsans.size(); ++i) {
            vsanStrs[i] = vsans.get(i).toString();
        }
        tm.addTableModelListener(this);
        DefaultComboBoxModel<String> vModel = new DefaultComboBoxModel<String>(vsanStrs);
        DefaultCellEditor vEditor = new DefaultCellEditor(new JComboBox<String>(vModel));
        DefaultComboBoxModel<String> faModel = new DefaultComboBoxModel<String>(new String[]{"Auto", "Manual"});
        DefaultComboBoxModel<String> shutModel = new DefaultComboBoxModel<String>(new String[]{"up", "down"});
        FATypeEditor faTypeEditor = new FATypeEditor(faModel, table, AdvancedTableModel.Column.vPWWN.ordinal());
        AdminStatusEditor adminStatusEditor = new AdminStatusEditor(shutModel, table, AdvancedTableModel.Column.Status.ordinal());
        DefaultCellEditor wwnEditor = new DefaultCellEditor(new JTextField()){

            @Override
            public boolean stopCellEditing() {
                if (!table.isEditing()) {
                    return super.stopCellEditing();
                }
                String val = (String)this.getCellEditorValue();
                try {
                    SnmpWWN wwn = new SnmpWWN(val);
                    wwn.toString();
                }
                catch (Exception ex) {
                    table.editingStopped(null);
                    int row = table.getEditingRow();
                    if (row != -1) {
                        table.setRowSelectionInterval(row, row);
                        if (((SnmpWWN)table.getValueAt(row, 1)).toString().equals(val)) {
                            return super.stopCellEditing();
                        }
                    }
                    return false;
                }
                return super.stopCellEditing();
            }
        };
        table.getColumnModel().getColumn(AdvancedTableModel.Column.Vsan.ordinal()).setCellEditor(vEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.FAType.ordinal()).setCellEditor(faTypeEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.Status.ordinal()).setCellEditor(adminStatusEditor);
        table.getColumnModel().getColumn(AdvancedTableModel.Column.vPWWN.ordinal()).setCellEditor(wwnEditor);
        tm.setData(sw, cfgs);
        return table;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.list.setSelectedValue(this.current, true);
            return;
        }
        SwitchBase sw = (SwitchBase)this.list.getSelectedValue();
        if (sw == null) {
            this.list.setSelectedIndex(0);
            return;
        }
        if (!this.cardMap.containsKey(sw)) {
            SnmpKTable table = this.createFaTable(sw, this.swMap.get(sw), this.vsans.get(sw));
            SnmpKTable vTable = this.createVPWwnTable(sw, this.wwnMap.get(sw));
            AdvTablePanel tPanel = new AdvTablePanel(sw, table, vTable, this);
            this.parent.add(sw.getName(), tPanel);
            this.cardMap.put(sw, tPanel);
        }
        this.current = sw;
        this.cards.show(this.parent, sw.getName());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        char c = evt.getActionCommand().charAt(0);
        AdvTablePanel tablePanel = this.cardMap.get(this.current);
        SnmpKTable table = tablePanel.getTable();
        AdvancedTableModel model = (AdvancedTableModel)table.getModel();
        switch (c) {
            case 'R': {
                model.setData(this.current, this.swMap.get(this.current));
                break;
            }
            case 'S': {
                int row = model.getRowCount();
                for (int i = 0; i < row; ++i) {
                    int col = AdvancedTableModel.Column.FAType.ordinal();
                    if (!table.isCellEditable(i, col)) continue;
                    table.setValueAt("Auto", i, col);
                }
                model.fireTableDataChanged();
                break;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        AdvTablePanel panel = this.cardMap.get(this.current);
        if (panel == null) {
            return;
        }
        SnmpKTable table = panel.getTable();
        if (table == null) {
            return;
        }
        KTableModel model = (KTableModel)table.getModel();
        this.list.revalidate();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof SwitchBase)) {
            return this;
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setOpaque(true);
        if (list != null) {
            this.changeList(list, value);
            ListModel model = list.getModel();
            if (model instanceof PListModel) {
                ((PListModel)model).fireContentsChanged(index);
            }
        }
        return this;
    }

    private void updateFont(JList list, SwitchBase sw) {
        AdvTablePanel tablePanel = this.cardMap.get(sw);
        Font font = this.getFont();
        this.setEnabled(list.isEnabled());
        if (tablePanel == null) {
            Font newFont = new Font(font.getName(), 0, font.getSize());
            this.setFont(newFont);
            return;
        }
        if (tablePanel.getTable() == null) {
            return;
        }
        boolean bold = tablePanel.isChanged();
        Font curFont = this.getFont();
        Font newFont = new Font(font.getName(), bold ? 1 : 0, font.getSize());
        this.setFont(newFont);
        this.setOpaque(true);
    }

    private void changeList(JList list, Object value) {
        String val = value.toString();
        this.setText(val);
    }

    public Map<SwitchBase, AdvancedConfig> getSelection() {
        HashMap<SwitchBase, AdvancedConfig> retMap = new HashMap<SwitchBase, AdvancedConfig>();
        Set<SwitchBase> sws = this.cardMap.keySet();
        for (SwitchBase sw : sws) {
            AdvTablePanel tablePanel = this.cardMap.get(sw);
            AdvancedTableModel model = (AdvancedTableModel)tablePanel.getTable().getModel();
            VPWWNTableModel vModel = (VPWWNTableModel)tablePanel.getVTable().getModel();
            if (!model.isChanged() && !vModel.isChanged()) continue;
            List<FlexAtahCfg> faList = model.getChangedConfig();
            List<FlexAtahVPWWN> vPWWNList = vModel.getChangedVPWWN();
            AdvancedConfig cfg = new AdvancedConfig(sw, faList);
            retMap.put(sw, cfg);
        }
        return retMap;
    }

    public boolean stopCellEditing() {
        if (!this.stopFaCellEditing()) {
            return false;
        }
        return this.stopVCellEditing();
    }

    private boolean stopFaCellEditing() {
        AdvTablePanel panel = this.cardMap.get(this.current);
        if (panel == null) {
            return true;
        }
        SnmpKTable table = panel.getTable();
        TableCellEditor editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.Vsan.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.Status.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.FAType.ordinal()).getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        editor = table.getColumnModel().getColumn(AdvancedTableModel.Column.vPWWN.ordinal()).getCellEditor();
        return editor == null || editor.stopCellEditing();
    }

    private boolean stopVCellEditing() {
        AdvTablePanel panel = this.cardMap.get(this.current);
        if (panel == null) {
            return true;
        }
        TableCellEditor editor = panel.getVTable().getColumnModel().getColumn(1).getCellEditor();
        return editor == null || editor.stopCellEditing();
    }

    public boolean isChanged() {
        Set<SwitchBase> sws = this.cardMap.keySet();
        for (SwitchBase sw : sws) {
            AdvTablePanel pane = this.cardMap.get(sw);
            if (!pane.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.stopCellEditing()) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    class AdvTablePanel
    extends JPanel
    implements ChangeListener {
        SnmpKTable table;
        SnmpKTable vTable;
        SwitchBase sw;
        private JButton allAutoBtn = new JButton("Set All Auto");
        private JButton resetBtn = new JButton("Reset All");

        public AdvTablePanel(SwitchBase sw, SnmpKTable tbl, SnmpKTable vWwnTable, ActionListener l) {
            this.resetBtn.setActionCommand("Reset");
            this.allAutoBtn.setToolTipText(this.allAutoBtn.getText());
            this.resetBtn.setToolTipText(this.resetBtn.getText());
            this.sw = sw;
            this.table = tbl;
            this.vTable = vWwnTable;
            this.setLayout(new BorderLayout());
            JTabbedPane tabs = new JTabbedPane();
            tabs.addMouseListener(ListListener.this);
            tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JTabbedPane pane = (JTabbedPane)e.getSource();
                    int idx = pane.getSelectedIndex();
                    if (idx == 1 && !ListListener.this.stopFaCellEditing()) {
                        pane.setSelectedIndex(0);
                    }
                    if (idx == 0 && !ListListener.this.stopVCellEditing()) {
                        pane.setSelectedIndex(1);
                    }
                }
            });
            JPanel toolPane = new JPanel(new FlowLayout(0));
            toolPane.add(this.allAutoBtn);
            toolPane.add(this.resetBtn);
            this.allAutoBtn.addActionListener(l);
            this.resetBtn.addActionListener(l);
            JScrollPane scroller = new JScrollPane(this.table);
            JPanel interfaceTable = new JPanel(new BorderLayout());
            interfaceTable.add((Component)toolPane, "North");
            interfaceTable.add((Component)scroller, "Center");
            JPanel vPanel = new JPanel(new BorderLayout());
            JPanel btnPane = new JPanel(new FlowLayout(0));
            JButton newBtn = new JButton("Add Row...");
            newBtn.setActionCommand("Add");
            newBtn.setToolTipText("Create pWWN to Virtual pWWN mapping");
            JButton delBtn = new JButton("Delete Row");
            delBtn.setToolTipText("Delete pWWN to Virtual pWWN mapping");
            delBtn.setActionCommand("Del");
            ActionListener aListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellEditor vEditor = AdvTablePanel.this.vTable.getColumnModel().getColumn(1).getCellEditor();
                    if (vEditor != null && !vEditor.stopCellEditing()) {
                        return;
                    }
                    char c = e.getActionCommand().charAt(0);
                    switch (c) {
                        case 'A': {
                            int ret;
                            Object[] options = new Object[]{"Create", "Cancel"};
                            WwnInput input = new WwnInput();
                            while ((ret = JOptionPane.showOptionDialog(AdvTablePanel.this.vTable.getParent(), input, "Flex Attach: Pre-Configure Server:  PWWN to Virtual PWWN", 2, -1, null, options, options[0])) == 0) {
                                try {
                                    Wwn pWwn = new Wwn(input.pTF.getText().trim());
                                    Wwn vPWwn = new Wwn(input.vTF.getText().trim());
                                    int row = AdvTablePanel.this.vTable.getRowCount();
                                    Array data = ((KTableModel)AdvTablePanel.this.vTable.getModel()).getData();
                                    for (int i = 0; i < data.size(); ++i) {
                                        Wwn wwn;
                                        Object[] val = (Object[])data.elementAt(i);
                                        if (val == null || val[0] == null || !pWwn.equals(wwn = (Wwn)val[0])) continue;
                                        JOptionPane.showMessageDialog(AdvTablePanel.this.vTable.getParent(), "This entry already exist.", "PWWN to Virtual PWWN", 0);
                                        return;
                                    }
                                    if (pWwn.equals(vPWwn)) {
                                        JOptionPane.showMessageDialog(AdvTablePanel.this.vTable.getParent(), "Real port WWN and virtual WWN cannot be the same.", "PWWN to Virtual PWWN", 0);
                                        return;
                                    }
                                    Object[] val = new Object[]{pWwn, new SnmpWWN(vPWwn.getValue()), new Object[]{"", ""}};
                                    data.addElement(val);
                                    ((KTableModel)AdvTablePanel.this.vTable.getModel()).setData(data);
                                    ((KTableModel)AdvTablePanel.this.vTable.getModel()).fireTableDataChanged();
                                }
                                catch (Exception ex) {
                                    Util.errorMessage((Component)AdvTablePanel.this.vTable.getParent(), ex);
                                }
                            }
                            break;
                        }
                        case 'D': {
                            int[] rows = AdvTablePanel.this.vTable.getSelectedRows();
                            Arrays.sort(rows);
                            Array _data = ((KTableModel)AdvTablePanel.this.vTable.getModel()).getData();
                            for (int i = rows.length - 1; i >= 0; --i) {
                                _data.removeElementAt(rows[i]);
                            }
                            ((KTableModel)AdvTablePanel.this.vTable.getModel()).setData(_data);
                            ((KTableModel)AdvTablePanel.this.vTable.getModel()).fireTableDataChanged();
                            break;
                        }
                    }
                }
            };
            newBtn.addActionListener(aListener);
            delBtn.addActionListener(aListener);
            btnPane.add(newBtn);
            btnPane.add(delBtn);
            vPanel.add((Component)btnPane, "North");
            vPanel.add(new JScrollPane(this.vTable));
            tabs.addTab("Interface", interfaceTable);
            tabs.addTab("PWWN to vPWWN", vPanel);
            this.add(tabs);
        }

        public SnmpKTable getTable() {
            return this.table;
        }

        public SnmpKTable getVTable() {
            return this.vTable;
        }

        public boolean isChanged() {
            boolean vPWwnChanged = ((KTableModel)this.vTable.getModel()).isChanged();
            if (!vPWwnChanged) {
                Array _data = new Array();
                _data.append(((KTableModel)this.vTable.getModel()).getData());
                ArrayList faWWNMap = new ArrayList(ListListener.this.wwnMap.get(this.sw));
                for (int j = faWWNMap.size() - 1; j >= 0; --j) {
                    FlexAtahVPWWN faPW = (FlexAtahVPWWN)faWWNMap.get(j);
                    Wwn wwn1 = faPW.getSvrWWN();
                    for (int i = _data.size() - 1; i >= 0; --i) {
                        SnmpWWN wwn2;
                        Object[] val = (Object[])_data.elementAt(i);
                        if (!wwn1.equals(val[0]) || !(wwn2 = new SnmpWWN(faPW.getSvrVPWWN().getValue())).toString().equals(val[1].toString())) continue;
                        _data.removeElementAt(i);
                        faWWNMap.remove(j);
                    }
                }
                if (faWWNMap.size() > 0 || _data.size() > 0) {
                    vPWwnChanged = true;
                }
            }
            boolean cfgChanged = ((AdvancedTableModel)this.table.getModel()).isChanged();
            return vPWwnChanged || cfgChanged;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCheckBox faAuto = (JCheckBox)e.getSource();
            boolean sel = faAuto.isSelected();
            ListListener.this.changeList(ListListener.this.list, ListListener.this.list.getSelectedValue());
        }
    }

    class WwnInput
    extends JPanel {
        JLabel pLabel = new JLabel("pWWN: ");
        JLabel vLabel = new JLabel("Virtual pWWN: ");
        JTextField pTF = new JTextField("", 40);
        JTextField vTF = new JTextField("", 40);

        public WwnInput() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.add((Component)this.pLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this.pTF, gbc);
            --gbc.gridx;
            ++gbc.gridy;
            this.add((Component)this.vLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this.vTF, gbc);
        }
    }
}

