/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.FabricCheckNonResolvableTable;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.model.Switch;

class FabricCheckAAATable
extends FabricCheckNonResolvableTable {
    FabricCheckAAATable() {
    }

    static boolean isAAASupported(SnmpPeer peer) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        return sw != null && sw.isVersionGreaterThanEqual("1.3(0)");
    }

    Array getAAASupportingPeers(Array peers) {
        Array<SnmpPeer> peers13 = new Array<SnmpPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer peer = (SnmpPeer)peers.elementAt(i);
            if (!FabricCheckAAATable.isAAASupported(peer)) continue;
            peers13.addElement(peer);
        }
        return peers13;
    }

    @Override
    protected int findRow(FabricCheckTable.SnmpRow sRow, Array target) {
        FabricCheckTable.SnmpRow row = null;
        int category = sRow._index[0];
        for (int i = 0; i < target.size(); ++i) {
            row = (FabricCheckTable.SnmpRow)target.elementAt(i);
            if (category != row._index[0] || this.compareValue(sRow, row) != 0) continue;
            return i;
        }
        return -1;
    }

    final int compareValue(FabricCheckTable.SnmpRow src, FabricCheckTable.SnmpRow dest) {
        if (null == src && null == dest) {
            return 0;
        }
        if (null == src || null == dest) {
            return -1;
        }
        SnmpVarBind[] srcVrbnd = src._vars;
        SnmpVarBind[] destVrbnd = dest._vars;
        if (null != destVrbnd && null != srcVrbnd && destVrbnd.length == srcVrbnd.length && srcVrbnd.length > 1) {
            SnmpString destVar;
            SnmpString srcVar = (SnmpString)srcVrbnd[0].getVar();
            if (!srcVar.equals(destVar = (SnmpString)destVrbnd[0].getVar())) {
                return -1;
            }
        } else {
            return -1;
        }
        return 0;
    }
}

