/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.fc.ResolveData;

class FabricCheckSysLogServerTable
extends FabricCheckTable {
    static final int OFFSET = 2;

    FabricCheckSysLogServerTable() {
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        if (!this._checkMismatch) {
            return;
        }
        StringBuffer mismatch = new StringBuffer();
        Array<SnmpString> mismatchedServers = new Array<SnmpString>();
        Array<SnmpInt> mismatchedServersAddType = new Array<SnmpInt>();
        int MAXK = target.size();
        for (int k = 0; k < MAXK; ++k) {
            FabricCheckTable.SnmpRow row = (FabricCheckTable.SnmpRow)target.elementAt(k);
            SnmpVarBind vbndTrg = row._vars[1];
            SnmpVarBind vbndTrg0 = row._vars[0];
            if (!(vbndTrg.getVar() instanceof SnmpString)) continue;
            mismatchedServers.addElement((SnmpString)vbndTrg.getVar());
            mismatchedServersAddType.addElement((SnmpInt)vbndTrg0.getVar());
        }
        byte[] addTrg = null;
        MibNode mibNdSev = null;
        MibNode mibNdFac = null;
        block1: for (int i = 0; i < source.size(); ++i) {
            FabricCheckTable.SnmpRow sRow = (FabricCheckTable.SnmpRow)source.elementAt(i);
            FabricCheckTable.SnmpRow row = null;
            SnmpVarBind vbndTrg = sRow._vars[0];
            int addTypeSrc = ((SnmpInt)vbndTrg.getVar()).getValue();
            vbndTrg = sRow._vars[1];
            byte[] addSrc = ((SnmpString)vbndTrg.getVar()).getValue();
            vbndTrg = sRow._vars[2];
            if (null == mibNdSev) {
                mibNdSev = MibNode.oidToNode(vbndTrg.getOid().getValue());
            }
            int addSevSrc = ((SnmpInt)vbndTrg.getVar()).getValue();
            vbndTrg = sRow._vars[3];
            if (null == mibNdFac) {
                mibNdFac = MibNode.oidToNode(vbndTrg.getOid().getValue());
            }
            int addFacilitySrc = ((SnmpInt)vbndTrg.getVar()).getValue();
            boolean addMatch = false;
            int MAXK2 = target.size();
            for (int k = 0; k < MAXK2; ++k) {
                row = (FabricCheckTable.SnmpRow)target.elementAt(k);
                vbndTrg = row._vars[0];
                int addTypeTrg = ((SnmpInt)vbndTrg.getVar()).getValue();
                vbndTrg = row._vars[1];
                addTrg = ((SnmpString)vbndTrg.getVar()).getValue();
                vbndTrg = row._vars[2];
                int addSevTrg = ((SnmpInt)vbndTrg.getVar()).getValue();
                vbndTrg = row._vars[3];
                int addFacilityTrg = ((SnmpInt)vbndTrg.getVar()).getValue();
                if (addTypeSrc == addTypeTrg && addSrc.length == addTrg.length) {
                    addMatch = true;
                    int MAXJ = addTrg.length;
                    for (int j = 0; j < MAXJ; ++j) {
                        if (addTrg[j] == addSrc[j]) continue;
                        addMatch = false;
                        break;
                    }
                    if (addMatch) {
                        mismatchedServers.removeElement((SnmpString)row._vars[1].getVar());
                        mismatchedServersAddType.removeElement((SnmpInt)row._vars[0].getVar());
                        if (addSevSrc != addSevTrg || addFacilitySrc != addFacilityTrg) {
                            if (mismatch.length() == 0) {
                                mismatch.append("Mismatch: ");
                            }
                            mismatch.append(" Server ");
                            mismatch.append(new SnmpIpAddress(addTrg));
                        }
                        if (addSevSrc != addSevTrg) {
                            mismatch.append(" Severity:");
                            mismatch.append(MibEnum.getLabel(mibNdSev.getEnums(), addSevTrg));
                        }
                        if (addFacilitySrc != addFacilityTrg) {
                            mismatch.append(" Facility:");
                            mismatch.append(MibEnum.getLabel(mibNdFac.getEnums(), addFacilityTrg));
                        }
                        addMatch = true;
                        continue block1;
                    }
                }
                if (addMatch) continue block1;
            }
        }
        boolean bShow = true;
        if (null == addTrg) {
            mismatch.append("Mismatch: No Syslog Server ");
            bShow = false;
        } else {
            int MAXI = mismatchedServers.size();
            for (int i = 0; i < MAXI; ++i) {
                if (mismatch.length() == 0) {
                    mismatch.append("Mismatch ");
                }
                mismatch.append(" Different Server: ");
                if (((SnmpInt)mismatchedServersAddType.elementAt(i)).getValue() == 16) {
                    mismatch.append(((SnmpString)mismatchedServers.elementAt(i)).toString());
                    continue;
                }
                mismatch.append(SnmpIpAddress.toString(((SnmpString)mismatchedServers.elementAt(i)).getValue()));
            }
        }
        if (mismatch.length() > 0) {
            Object[] obVbnds = this.buildVarBind(source, target);
            this.addData(peer, bShow, name, mismatch.toString(), new ResolveData(obVbnds, this._rndr, null));
        }
    }

    Object[] buildVarBind(Array source, Array target) {
        FabricCheckTable.SnmpRow row;
        Array<SnmpVarBind> varbinds;
        int i;
        Object[] obVbnd = new Object[target.size() + source.size()];
        int MAXI = target.size();
        for (i = 0; i < MAXI; ++i) {
            varbinds = new Array<SnmpVarBind>();
            row = (FabricCheckTable.SnmpRow)target.elementAt(i);
            varbinds.addElement(new SnmpVarBind(new SnmpOID(this._rowAddRm.getValue(), row._index), new SnmpInt(6)));
            obVbnd[i] = varbinds;
        }
        MAXI = source.size();
        for (i = 0; i < MAXI; ++i) {
            varbinds = new Array();
            row = (FabricCheckTable.SnmpRow)source.elementAt(i);
            varbinds.addElement(new SnmpVarBind(new SnmpOID(this._rowAddRm.getValue(), row._index), new SnmpInt(4)));
            int MAXJ = row._vars.length;
            for (int j = 0; j < MAXJ; ++j) {
                varbinds.addElement(row._vars[j]);
            }
            obVbnd[i + target.size()] = varbinds;
        }
        return obVbnd;
    }
}

