/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.fc.ResolveData;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import org.w3c.dom.Node;

class FabricCheckUsersTable
extends FabricCheckTable {
    static final int USERNAME_OFFSET = 15;

    FabricCheckUsersTable() {
    }

    @Override
    protected String getVarName(SnmpVarBind vb, MibEnum[] enums) {
        int[] oid = vb.getOid().getValue();
        StringBuffer sb = new StringBuffer();
        return SnmpString.toString(oid, 15, oid.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd) throws SnmpException {
        VarBindList response;
        MibNode mbNd;
        String[] attrs = chkAttrs._attrs;
        this._chkAttr = chkAttrs;
        this._data = data;
        this._attrName = category;
        this._rndr = chkAttrs._rndr;
        this._peers = peers;
        if (rowAddRm != null && null != (mbNd = MibNode.get(rowAddRm))) {
            this._rowAddRm = new SnmpOID(mbNd.getOid());
        }
        VarBindList request = this.buildRequest(attrs);
        if (null == rtNd) {
            ClientController.getInstance();
            Switch sww = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sww == null || !sww.isVersionGreaterThanEqual("3.0(0)")) {
                if (sww != null) {
                    System.out.println("Skiping SNMP User comparison for " + sww + ", Version:" + sww.getVersion());
                }
                return;
            }
            response = this.getRefData(attrs, peer);
        } else {
            String refVersion = this.getSwVersionFromFile(rtNd);
            if (new SwitchVersion(refVersion).compareTo(new SwitchVersion("3.0(0)")) < 0) {
                System.out.println("Skiping SNMP User comparison for file with reference switch Version:" + refVersion);
                return;
            }
            response = this.readCategoryFromPolicyFile(rtNd, this._attrName);
            if (response.size() == 0) {
                return;
            }
        }
        this._attrLen = attrs.length;
        Switch sw = null;
        if (null == rtNd) {
            ClientController.getInstance();
            sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        }
        this._attr = this.buildRows(response, this.getAttributeLength(), sw);
        this.checkResponse(peer, this._attrName, this._attr);
        ArrayList<SnmpPeer> Switches30 = new ArrayList<SnmpPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer thPr = (SnmpPeer)peers.elementAt(i);
            ClientController.getInstance();
            Switch sww = ClientController.findFabricSwitchByIpAddress(thPr.getAddress());
            if (sww != null && sww.isVersionGreaterThanEqual("3.0(0)")) {
                Switches30.add(thPr);
                continue;
            }
            if (sww == null) continue;
            System.out.println("Skiping SNMP User comparison for " + sww + ", Version:" + sww.getVersion());
        }
        if (Switches30.size() > 0) {
            int i;
            this._numReqs = Switches30.size();
            SnmpPeer[] p = new SnmpPeer[this._numReqs];
            for (i = 0; i < p.length; ++i) {
                p[i] = (SnmpPeer)peers.elementAt(i);
            }
            for (i = 0; i < p.length; ++i) {
                new SnmpFetch().getBulk(p[i], request, (SnmpCallbackIf)this);
            }
            try {
                Array i2 = this._data;
                synchronized (i2) {
                    this._data.wait(12000L);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public final void addData(SnmpPeer peer, boolean resolvable, String type, String description, ResolveData data) {
        super.addData(peer, false, type, description, data);
    }
}

