/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.model.Switch;
import org.w3c.dom.Node;

class FabricCheckVersion
extends FabricCheckTable {
    FabricCheckVersion() {
    }

    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd) throws SnmpException {
        this._data = data;
        if (rtNd != null) {
            this.check(peers, category, this.getSwVersionFromFile(rtNd));
        } else {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw != null) {
                this.check(peers, category, sw.getVersion());
            }
        }
    }

    private void check(Array peers, String category, String version) {
        if (version == null) {
            return;
        }
        for (int i = 0; i < peers.size(); ++i) {
            SnmpPeer thePeer = (SnmpPeer)peers.elementAt(i);
            Switch sw = ClientController.findFabricSwitchByIpAddress(thePeer.getAddress());
            if (sw == null || sw.getVersion() == null) {
                this.addData(thePeer, false, category, "Unknown version", null);
                continue;
            }
            if (sw.getVersion().equals(version)) continue;
            this.addData(thePeer, false, category, "Mismatch " + sw.getVersion(), null);
        }
    }
}

