/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.fcip.EtherPort;
import com.cisco.dcbu.sm.client.fcip.FcipWizard;
import com.cisco.dcbu.sm.client.fcip.IpSecurityController;
import com.cisco.dcbu.sm.client.fcip.SwitchInfo;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IPAddressPanel
extends WizardPanel
implements ActionListener {
    static String[] _LABELS = new String[]{null, "Associated Ether Port IP Address:", null, null, "Associated Ether Port IP Address:", null};
    static String[] ROUTE_LABELS = new String[]{"Dest/Mask:", "Gateway:", "Metric"};
    static final String Description = "Please supply Ethernet Port IP Address.  Specify Route if the Port addresses are in different subnet.\nNote: The changes to IP Address and IP Route Addition will be applied on pressing the Next button.";
    static final int SW1_DLGSEP = 0;
    static final int SW1_IP_ADDRESS = 1;
    static final int SW1_IP_ADDROUTE = 2;
    static final int SW2_DLGSEP = 3;
    static final int SW2_IP_ADDRESS = 4;
    static final int SW2_IP_ADDROUTE = 5;
    static final int IP_ROUTE_DESTID = 0;
    static final int IP_ROUTE_MERICID = 2;
    static final int IP_ROUTE_GATEWAYID = 1;
    private boolean _panelCreated;
    private JComponent[] _fields;
    private JComponent[] _Labels;
    JCheckBox addRoute1 = new JCheckBox("Add IP Route:");
    private FieldPanel[] iproute1 = new FieldPanel[3];
    private JLabel[] route1Label;
    JCheckBox addRoute2 = new JCheckBox("Add IP Route:");
    private FieldPanel[] iproute2 = new FieldPanel[3];
    private JLabel[] route2Label;
    private SnmpPeer _sw1;
    private SnmpPeer _sw2;
    private EtherPort[] _etherPorts;
    public static final String _Fcip_Wiz_Sig = "FCIP";

    private IPAddressPanel() {
        this((JWizard)null);
    }

    public IPAddressPanel(JWizard wizard) {
        super("3 of 5: Specify IP Address/Route", Description, wizard, FcipWizard._ImageFcip);
        JLabel[] theLbls = DialogUtil.buildLabels(_LABELS);
        this._Labels = new JComponent[_LABELS.length];
        for (int i = 0; i < theLbls.length; ++i) {
            this._Labels[i] = theLbls[i];
        }
        this._Labels[2] = this.addRoute1;
        this._Labels[5] = this.addRoute2;
        this._fields = new JComponent[this._Labels.length];
        this._fields[1] = new FieldPanel(18, (JComponent)new JLabel("e.g. 10.1.1.1/24"));
        this.route1Label = DialogUtil.buildLabels(ROUTE_LABELS);
        this._fields[2] = this.buildIpRoutePanel(this.iproute1, this.route1Label);
        this._fields[4] = new FieldPanel(18, (JComponent)new JLabel("e.g. 10.1.1.1/24"));
        this.route2Label = DialogUtil.buildLabels(ROUTE_LABELS);
        this._fields[5] = this.buildIpRoutePanel(this.iproute2, this.route2Label);
        this.addRoute1.addActionListener(this);
        this.addRoute2.addActionListener(this);
    }

    private JPanel buildIpRoutePanel(FieldPanel[] iproute, JLabel[] labels) {
        iproute[0] = new FieldPanel(10, (JComponent)new JLabel("e.g. 10.1.0.0/16"));
        iproute[2] = new FieldPanel(10, 0, 0, 32766);
        iproute[1] = new FieldPanel(10, (JComponent)new JLabel("e.g. 11.1.1.1"));
        for (int i = 0; i < iproute.length; ++i) {
            iproute[i].setEnabled(false);
            labels[i].setEnabled(false);
        }
        return DialogUtil.buildPanel(labels, iproute);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FieldPanel[] cmp = null;
        JLabel[] cmp1 = null;
        if (e.getSource() == this.addRoute1) {
            cmp = this.iproute1;
            cmp1 = this.route1Label;
        } else if (e.getSource() == this.addRoute2) {
            cmp = this.iproute2;
            cmp1 = this.route2Label;
        }
        if (cmp != null) {
            JComponent[] cmp2 = new JComponent[cmp.length + cmp1.length];
            System.arraycopy(cmp, 0, cmp2, 0, cmp.length);
            System.arraycopy(cmp1, 0, cmp2, cmp.length, cmp1.length);
            boolean selected = ((JCheckBox)e.getSource()).isSelected();
            this.setEnabledAll(selected, cmp2);
        }
    }

    private void setEnabledAll(boolean selected, JComponent[] cmp) {
        if (cmp != null) {
            for (int i = 0; i < cmp.length; ++i) {
                cmp[i].setEnabled(selected);
            }
        }
    }

    @Override
    public boolean refresh() {
        SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
        SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
        Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
        this._sw1 = (SnmpPeer)this.getModelValue("PEER_A");
        this._sw2 = (SnmpPeer)this.getModelValue("PEER_B");
        this._etherPorts = (EtherPort[])this.getModelValue("ETHER_PORTS");
        String address = this._etherPorts[0]._address == null ? "" : SnmpIpAddress.toString(this._etherPorts[0]._address) + "/" + this._etherPorts[0]._mask;
        ((JLabel)this._Labels[1]).setText("IP Address/Mask:");
        ((FieldPanel)this._fields[1]).setText(address);
        ((FieldPanel)this._fields[1]).getField().setEditable(true);
        address = this._etherPorts[1]._address == null ? "" : SnmpIpAddress.toString(this._etherPorts[1]._address) + "/" + this._etherPorts[1]._mask;
        ((JLabel)this._Labels[4]).setText("IP Address/Mask:");
        ((FieldPanel)this._fields[4]).setText(address);
        ((FieldPanel)this._fields[4]).getField().setEditable(true);
        String sep1 = "Switch " + this._sw1 + " (" + this._etherPorts[0].getIfName() + ")";
        String sep2 = "Switch " + this._sw2 + " (" + this._etherPorts[1].getIfName() + ")";
        if (!this._panelCreated) {
            this._fields[0] = new DialogSeparator(sep1);
            this._fields[3] = new DialogSeparator(sep2);
            JPanel p = new JPanel(new GridBagLayout());
            DialogUtil.buildPanel(p, this._Labels, this._fields);
            this.add((Component)p, "Center");
            this._panelCreated = true;
        } else {
            ((DialogSeparator)this._fields[0]).setLabel(sep1);
            ((DialogSeparator)this._fields[3]).setLabel(sep2);
        }
        return true;
    }

    private String getGigiPortAddress(String addressMask) throws SnmpException {
        int ind = addressMask.indexOf(47);
        if (-1 == ind) {
            new SnmpException("Bad ip address");
        }
        return addressMask.substring(0, ind);
    }

    boolean validateEtherAddress(byte[] add1, int mask1, byte[] add2, int mask2) throws SnmpException {
        if (mask1 != mask2) {
            return false;
        }
        byte[] subnet1 = SnmpIpAddress.getSubNet(add1, mask1);
        byte[] subnet2 = SnmpIpAddress.getSubNet(add2, mask2);
        return SnmpString.equals(subnet1, subnet2);
    }

    @Override
    public void doNext() {
        try {
            JComponent[] cmp;
            IpSecurityController con;
            Object[] ipAdd1Ob = this.getAddressMask(((FieldPanel)this._fields[1]).getText().trim(), false, "IP Address");
            Object[] ipAdd2Ob = this.getAddressMask(((FieldPanel)this._fields[4]).getText().trim(), false, "IP Address");
            byte[] ipAdd1 = (byte[])ipAdd1Ob[0];
            byte[] ipAdd2 = (byte[])ipAdd2Ob[0];
            int ipMsk1 = (Integer)ipAdd1Ob[1];
            int ipMsk2 = (Integer)ipAdd2Ob[1];
            if (SnmpString.equals(ipAdd1, ipAdd2)) {
                Util.errorMessage((Component)this, "Please specify different IP Address for the Gigi ports.");
                return;
            }
            Object[] ipDest1Ob = null;
            Object[] ipGateway1Ob = null;
            int ipMetric1 = -1;
            if (this.addRoute1.isSelected()) {
                ipDest1Ob = this.getAddressMask(this.iproute1[0].getText().trim(), false, "Route Destination subnet");
                ipGateway1Ob = this.getAddressMask(this.iproute1[1].getText().trim(), false, "Route Gateway");
                ipMetric1 = this.iproute1[2].getInt();
            }
            Object[] ipDest2Ob = null;
            Object[] ipGateway2Ob = null;
            int ipMetric2 = -1;
            if (this.addRoute2.isSelected()) {
                ipDest2Ob = this.getAddressMask(this.iproute2[0].getText().trim(), false, "Route Destination subnet");
                ipGateway2Ob = this.getAddressMask(this.iproute2[1].getText().trim(), false, "Route Gateway");
                ipMetric2 = this.iproute2[2].getInt();
            }
            if ((this._etherPorts[0]._address != null && !SnmpString.equals(ipAdd1, this._etherPorts[0]._address) || this._etherPorts[0]._mask != ipMsk1 || this._etherPorts[1]._address != null && !SnmpString.equals(ipAdd2, this._etherPorts[1]._address) || this._etherPorts[1]._mask != ipMsk2) && (con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER")) != null && con.isSecure() && JOptionPane.showConfirmDialog(this.getWizard(), "The selected gigi port(s)are secured & changing IP Address can make FCIP link unsecure.\nPlease reconfigure security from Tables by selecting Physical Attributes/Switches/Security/IPSEC,\nif the IP address is changed. Continue? ", this.getTitle(), 0, 2) != 0) {
                return;
            }
            Boolean mtu = (Boolean)this.getModelValue("MTU");
            this.setEtherProperties(this._sw1, this._etherPorts[0], (byte[])ipAdd1Ob[0], (Integer)ipAdd1Ob[1], mtu);
            this.setEtherProperties(this._sw2, this._etherPorts[1], (byte[])ipAdd2Ob[0], (Integer)ipAdd2Ob[1], mtu);
            if (this.addRoute1.isSelected()) {
                this.addRoute(this._sw1, this._etherPorts[0], (byte[])ipDest1Ob[0], (Integer)ipDest1Ob[1], ipMetric1, (byte[])ipGateway1Ob[0]);
                this.addRoute1.setSelected(false);
                cmp = new JComponent[this.iproute1.length + this.route1Label.length];
                System.arraycopy(this.iproute1, 0, cmp, 0, this.iproute1.length);
                System.arraycopy(this.route1Label, 0, cmp, this.iproute1.length, this.route1Label.length);
                this.setEnabledAll(false, cmp);
            }
            if (this.addRoute2.isSelected()) {
                this.addRoute(this._sw2, this._etherPorts[1], (byte[])ipDest2Ob[0], (Integer)ipDest2Ob[1], ipMetric2, (byte[])ipGateway2Ob[0]);
                this.addRoute2.setSelected(false);
                cmp = new JComponent[this.iproute2.length + this.route2Label.length];
                System.arraycopy(this.iproute2, 0, cmp, 0, this.iproute2.length);
                System.arraycopy(this.route2Label, 0, cmp, this.iproute2.length, this.route2Label.length);
                this.setEnabledAll(false, cmp);
            }
            this.setDataValid(false);
            super.doNext();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void addRoute(SnmpPeer peer, EtherPort prt, byte[] destAddress, int mask, int metric, byte[] gateway) throws SnmpException {
        int ipAddType = destAddress.length == 4 ? 1 : 2;
        int gatewayAddType = gateway.length == 4 ? 1 : 2;
        int indexLen = 2 + (destAddress.length == 4 ? 4 : 16) + 2 + (gateway.length == 4 ? 4 : 16);
        int[] index = new int[indexLen];
        index[0] = 0;
        index[1] = ipAddType;
        System.arraycopy(this.byte2IntArray(destAddress), 0, index, 2, destAddress.length);
        index[2 + destAddress.length] = mask;
        index[3 + destAddress.length] = gatewayAddType;
        System.arraycopy(this.byte2IntArray(gateway), 0, index, 4 + destAddress.length, destAddress.length);
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cInetCidrRouteStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
        VarBindList resp = peer.send(new SnmpPDU(-96, vbl)).getVariables();
        if (resp.getVb(0).getVar().getType() != 5) {
            throw new SnmpException("IP route already for destination " + new SnmpIpAddress(destAddress).toString() + " is already configured.");
        }
        vbl.add(MibNode.get("cInetCidrRouteMetric1").getOid(), index, (SnmpVar)new SnmpInt(metric));
        vbl.add(MibNode.get("cInetCidrRouteIfIndex").getOid(), index, (SnmpVar)new SnmpInt(prt._index));
        if (vbl.size() > 0) {
            peer.set(new SnmpPDU(-93, vbl));
        }
    }

    private int[] byte2IntArray(byte[] byteData) {
        if (byteData == null) {
            return new int[0];
        }
        int[] intData = new int[byteData.length];
        for (int k = 0; k < byteData.length; ++k) {
            intData[k] = byteData[k];
        }
        return intData;
    }

    private void setEtherProperties(SnmpPeer peer, EtherPort prt, byte[] address, int mask, Boolean setJumboMtu) throws SnmpException {
        int jumboMtuSize;
        VarBindList vbl = new VarBindList();
        boolean setMtu = false;
        Boolean applySecurity = (Boolean)this.getModelValue("APPLY_SECURITY");
        int n = jumboMtuSize = applySecurity != null && applySecurity != false ? 2500 : 2300;
        if (setJumboMtu != null && setJumboMtu.booleanValue()) {
            vbl.add(MibNode.get("cieIfMtu").getOid(), prt._index);
            setMtu = peer.send(new SnmpPDU(-96, vbl)).getVariables().intValue(0) < jumboMtuSize;
        }
        vbl.clear();
        int[] oid = new int[3 + address.length];
        oid[0] = prt._index;
        oid[1] = address.length == 16 ? 2 : 1;
        oid[2] = address.length;
        for (int i = 0; i < address.length; ++i) {
            oid[3 + i] = address[i];
        }
        if (prt._address == null || !SnmpString.equals(address, prt._address)) {
            vbl.add(MibNode.get("ciiIPIfAddressStatus").getOid(), oid, (SnmpVar)new SnmpInt(4));
        }
        if (prt._address == null || !SnmpString.equals(address, prt._address) || prt._mask != mask) {
            vbl.add(MibNode.get("ciiIPIfAddressPrefixLength").getOid(), oid, (SnmpVar)new SnmpUnsignedInt(mask));
        }
        if (setMtu) {
            vbl.add(MibNode.get("cieIfMtu").getOid(), prt._index, (SnmpVar)new SnmpInt(jumboMtuSize));
        }
        if (prt._adminStatus != 1) {
            vbl.add(MibNode.get("ifAdminStatus").getOid(), prt._index, (SnmpVar)new SnmpInt(1));
        }
        if (vbl.size() > 0) {
            peer.set(new SnmpPDU(-93, vbl));
            prt._address = address;
            prt._mask = mask;
            prt._adminStatus = 1;
        }
    }

    public void handleError(Exception[] ex) {
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
    }

    public void setStatus(String status) {
        this.getWizard().setStatus(status);
    }

    Object[] getAddressMask(String addMsk, boolean validateMask, String ref) throws SnmpException {
        Object[] ob = new Object[2];
        int ind = addMsk.indexOf(47);
        String strAdd1 = ind != -1 ? addMsk.substring(0, ind) : addMsk;
        try {
            ob[1] = ind != -1 ? Integer.parseInt(addMsk.substring(ind + 1, addMsk.length())) : new Integer(0);
            ob[0] = SnmpIpAddress.parse(strAdd1);
            if (validateMask && SnmpIntList.bytesToInt((byte[])ob[0], 0) << (Integer)ob[1] != 0) {
                throw new SnmpException((ref != null ? ref + ":" : "") + "Please provide correct IP/Mask combination.");
            }
        }
        catch (NumberFormatException ex) {
            throw new SnmpException((ref != null ? ref + ":" : "") + " Bad ip address " + addMsk);
        }
        catch (SnmpException exx) {
            throw new SnmpException((ref != null ? ref + ":" : "") + " " + " Bad ip address " + addMsk);
        }
        return ob;
    }
}

