/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.model;

import com.cisco.dcbu.lib.ui.fcoe.FCoEConfigurationTableModel;
import com.cisco.dcbu.lib.ui.fcoe.InterfaceObj;
import com.cisco.dcbu.lib.ui.fcoe.VlanVsanListObj;
import com.cisco.dcbu.lib.ui.fcoe.VlanVsanObj;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.fcoe.StatusMsg;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class VEFCoEConfigurationTableModel
extends FCoEConfigurationTableModel {
    private static final long serialVersionUID = 3378007352692063976L;
    public final int SWITCH_1_INTERFACE_COLUMN = 0;
    public final int SWITCH_1_VFC_ID_COLUMN = 1;
    public final int SWITCH_2_INTERFACE_COLUMN = 2;
    public final int SWITCH_2_VFC_ID_COLUMN = 3;
    public final int VLAN_COLUMN = 4;
    public final int STATUS_COLUMN = 5;
    private AbstractSwitch selectedSwitch1;
    private AbstractSwitch selectedSwitch2;
    private Array<Object[]> allData = new Array();

    public VEFCoEConfigurationTableModel(TreeMap<Integer, Integer> activeVlanVsans, TreeMap<Integer, Integer> selectedVlanVsan, LinkedHashMap<AbstractSwitch, ArrayList<String>> interfaceList) {
        this.setActiveVlanVsans(activeVlanVsans);
        this.setSelectedVlanVsan(selectedVlanVsan);
        this.setSelectedSwitches(interfaceList);
        String[] columns = new String[]{"<html>" + this.selectedSwitch1.getName() + "<br> Interface", "vFC ID", "<html>" + this.selectedSwitch2.getName() + "<br> Interface", "vFC ID", "VLAN(VSAN) Mapping", "Configure Action Status"};
        this.setHeaders(columns);
        this.setTableData(interfaceList);
        this.setHeaders(columns);
        this.setData(this.allData);
        this.setEditable(new boolean[]{false, true, false, true, true, false});
    }

    private void setSelectedSwitches(HashMap<AbstractSwitch, ArrayList<String>> interfaceList) {
        Set<AbstractSwitch> keys = interfaceList.keySet();
        Iterator<AbstractSwitch> switchIt = keys.iterator();
        this.selectedSwitch1 = switchIt.next();
        this.selectedSwitch2 = switchIt.next();
    }

    private void setTableData(HashMap<AbstractSwitch, ArrayList<String>> interfaceList) {
        String status = "";
        Set<AbstractSwitch> keys = interfaceList.keySet();
        Iterator<AbstractSwitch> switchIt = keys.iterator();
        ArrayList<String> sw1InterfaceList = interfaceList.get(switchIt.next());
        ArrayList<String> sw2InterfaceList = interfaceList.get(switchIt.next());
        for (int i = 0; i < sw2InterfaceList.size(); ++i) {
            String sw1Port = sw1InterfaceList.get(i);
            String sw2Port = sw2InterfaceList.get(i);
            this.addRow(sw1Port, "", sw2Port, "", "", status);
        }
    }

    @Override
    public Class getColumnClass(int r, int c) {
        if (c == 5) {
            return StatusMsg.class;
        }
        if (c == 4) {
            return VlanVsanListObj.class;
        }
        Object o = this.getValueAt(r, c);
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    @Override
    public List<String> getVlanValueAt(int row) {
        ArrayList<String> vlans = new ArrayList<String>();
        Object o = this.getValueAt(row, 4);
        if (o instanceof VlanVsanListObj) {
            Object[] vlanVsanList;
            for (Object next : vlanVsanList = ((VlanVsanListObj)o).vlanVsanObjs) {
                vlans.add(((VlanVsanObj)next).getVlan().toString());
            }
        } else {
            vlans.add((String)o);
        }
        return vlans;
    }

    @Override
    public List<String> getVsanValueAt(int row) {
        ArrayList<String> vsans = new ArrayList<String>();
        Object o = this.getValueAt(row, 4);
        if (o instanceof VlanVsanListObj) {
            Object[] vlanVsanList;
            for (Object next : vlanVsanList = ((VlanVsanListObj)o).vlanVsanObjs) {
                vsans.add(((VlanVsanObj)next).getVsan().toString());
            }
        } else {
            vsans.add((String)o);
        }
        return vsans;
    }

    @Override
    public boolean isVfcTrunkingSupported() {
        return true;
    }

    private void addRow(String sw1Port, String vfcId1, String sw2Port, String vfcId2, String vlan, String status) {
        Object[] obj = new Object[]{new InterfaceObj(this.selectedSwitch1, sw1Port), vfcId1, new InterfaceObj(this.selectedSwitch2, sw2Port), vfcId2, this.getSelectedVlanVsans(), status, null};
        this.allData.addElement(obj);
    }
}

