/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.model;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcoe.model.VLANVSANTableModel;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class VEVLANVSANTableModel
extends VLANVSANTableModel {
    private static final long serialVersionUID = -289807667550972764L;
    private static final int MAPPING_UP_ENUM = 1;
    private HashMap<String, ArrayList<String>> mappingsMap = new HashMap();
    protected boolean isTrunkingSupported = true;

    public VEVLANVSANTableModel(String[] vars) {
        super(vars);
    }

    public Array getTableVars(AbstractSwitch[] switches) throws SnmpException {
        int vlan2;
        Object[] switch2Data;
        Object[] switch1Data;
        Array<Object[]> returnData;
        block9: {
            if (DefaultLogger._DefLogger.isDebugEnabled()) {
                DefaultLogger._DefLogger.debug((Object)"VEVLANVSANTableModel : getTableVars(), Trying to get the VLAN-VSAN mappings.");
            }
            returnData = new Array<Object[]>();
            switch1Data = null;
            switch2Data = null;
            try {
                FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                switch1Data = fcoeProxy.getVLANVSANMappings(switches[0].getPK());
                switch2Data = fcoeProxy.getVLANVSANMappings(switches[1].getPK());
            }
            catch (Exception e) {
                if (!DefaultLogger._DefLogger.isDebugEnabled()) break block9;
                DefaultLogger._DefLogger.debug((Object)("VEVLANVSANTableModel : getTableVars(), Failed to get the mappings data. Reason :" + e.getMessage()));
            }
        }
        if (switch1Data == null && switch2Data == null) {
            super.setData(returnData);
            return returnData;
        }
        ArrayList<String> sw1Mappings = new ArrayList<String>();
        ArrayList<String> sw2Mappings = new ArrayList<String>();
        this.mappingsMap.put(switches[0].getSysName(), sw1Mappings);
        this.mappingsMap.put(switches[1].getSysName(), sw2Mappings);
        ArrayList<Object> sw2Vars = new ArrayList<Object>();
        for (Object var : switch2Data) {
            sw2Vars.add(var);
        }
        String mappingStatus = "";
        for (int i = 0; i < switch1Data.length; ++i) {
            SnmpVarBind sw1Var = (SnmpVarBind)switch1Data[i];
            int vlan1 = this.getVLANId(sw1Var.getOid());
            int vsan1 = this.getVSANId(sw1Var.getOid());
            sw1Mappings.add(vlan1 + "-" + vsan1);
            int sw1MappingStatus = ((SnmpInt)sw1Var.getVar()).getValue();
            mappingStatus = "";
            int matchIndex = -1;
            for (int j = 0; j < sw2Vars.size(); ++j) {
                SnmpVarBind sw2Var = (SnmpVarBind)sw2Vars.get(j);
                vlan2 = this.getVLANId(sw2Var.getOid());
                int vsan2 = this.getVSANId(sw2Var.getOid());
                int sw2MappingStatus = ((SnmpInt)sw2Var.getVar()).getValue();
                if (vsan1 != vsan2 || vlan1 != vlan2) continue;
                sw2Mappings.add(vlan2 + "-" + vsan2);
                mappingStatus = sw1MappingStatus == sw2MappingStatus ? (sw1MappingStatus == 1 ? "up" : "down") : (sw1MappingStatus != 1 ? "down on " + switches[0].getSysName() : "down on " + switches[1].getSysName());
                matchIndex = j;
                break;
            }
            if (matchIndex != -1) {
                sw2Vars.remove(matchIndex);
            }
            returnData.addElement(this.createRow(vlan1, vsan1, mappingStatus));
        }
        for (int count = 0; count < sw2Vars.size(); ++count) {
            SnmpVarBind sw2Var = (SnmpVarBind)sw2Vars.get(count);
            vlan2 = this.getVLANId(sw2Var.getOid());
            int vsan2 = this.getVSANId(sw2Var.getOid());
            sw2Mappings.add(vlan2 + "-" + vsan2);
            returnData.addElement(this.createRow(vlan2, vsan2, ""));
        }
        super.setData(returnData);
        return returnData;
    }

    public TreeSet<Integer> getVsans(AbstractSwitch[] switches) {
        String key;
        TreeSet<Integer> vsanIds;
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"VEVLANVSANTableModel : getVsans(), Trying to get the available VSANs for new bindings.");
        }
        if ((vsanIds = (TreeSet<Integer>)this.vsanList.get(key = switches[0].getSysName() + switches[1].getSysName())) == null) {
            ArrayList<Integer> sw2Vsans;
            ArrayList<Integer> sw1Vsans;
            block7: {
                sw1Vsans = null;
                sw2Vsans = null;
                try {
                    FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                    sw1Vsans = fcoeProxy.getVsans(switches[0].getPK());
                    sw2Vsans = fcoeProxy.getVsans(switches[1].getPK());
                }
                catch (Exception e) {
                    if (!DefaultLogger._DefLogger.isDebugEnabled()) break block7;
                    DefaultLogger._DefLogger.debug((Object)("VEVLANVSANTableModel : getVsans(), Failed to get the available VSANs for new bindings. Reason : " + e.getMessage()));
                }
            }
            if (sw1Vsans != null && sw2Vsans != null) {
                int i;
                vsanIds = new TreeSet<Integer>();
                for (i = 0; i < sw1Vsans.size(); ++i) {
                    vsanIds.add(sw1Vsans.get(i));
                }
                for (i = 0; i < sw2Vsans.size(); ++i) {
                    vsanIds.add(sw2Vsans.get(i));
                }
                this.vsanList.put(key, vsanIds);
            }
        }
        return vsanIds;
    }

    public void createMappings(AbstractSwitch selectedSwitch, HashMap<Integer, Integer> newMappings) throws SnmpException {
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)("VEVLANVSANTableModel : createMappings(), Trying to create the new VLAN-VSAN mappings on switch " + selectedSwitch.getSysName()));
        }
        try {
            ArrayList<String> mappings = this.mappingsMap.get(selectedSwitch.getSysName());
            if (mappings.size() > 0) {
                Iterator<Integer> keyIter = newMappings.keySet().iterator();
                while (keyIter.hasNext()) {
                    int vlan = keyIter.next();
                    int vsan = newMappings.get(vlan);
                    if (!mappings.contains(vlan + "-" + vsan)) continue;
                    keyIter.remove();
                }
            }
            if (newMappings.size() > 0) {
                FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                fcoeProxy.createVLANVSANMappings(selectedSwitch.getPK(), newMappings);
            }
        }
        catch (Exception ex) {
            if (FCoEConfigurationWizard.isAuthorizationError(ex)) {
                FCoEConfigurationWizard.clearSwitchCredentials(selectedSwitch);
            }
            throw new SnmpException(ex.getMessage());
        }
    }

    private Object[] createRow(int vlanId, int vsanId, String mappingStatus) {
        Object[] row = super.createRow();
        row[VEVLANVSANTableModel.VLAN_COL] = vlanId;
        row[VEVLANVSANTableModel.VSAN_COL] = vsanId;
        row[VEVLANVSANTableModel.OPER_COL] = mappingStatus;
        row[VEVLANVSANTableModel.DEFAULT_MAPPING_COL] = mappingStatus.equals("up") || mappingStatus.equals("");
        return row;
    }

    private Integer getVLANId(SnmpOID oid) {
        int[] index = oid.getValue();
        return index[index.length - 2];
    }

    private Integer getVSANId(SnmpOID oid) {
        int[] index = oid.getValue();
        return index[index.length - 1];
    }
}

