/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.wizard;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.LabelDescription;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class AuthenticationDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 8767396354513586128L;
    boolean _closed;
    JCheckBox _sameCred;
    UserCredentialsPanel _field1;
    UserCredentialsPanel _field2;
    ArrayList<AbstractSwitch> _switches;
    HashMap<PKIf, SnmpUserOpt> _userCredentials;

    AuthenticationDialog(Frame parent, ArrayList<AbstractSwitch> switchList) {
        super(parent, "Admin Credentials");
        String[] stringArray;
        this._switches = switchList;
        String switchName = switchList.get(0).getSysName();
        this._field1 = new UserCredentialsPanel(switchName, this);
        if (switchList.size() == 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "";
            stringArray2[1] = "";
            stringArray = stringArray2;
            stringArray2[2] = "";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "";
            stringArray3[1] = "";
            stringArray3[2] = "";
            stringArray3[3] = "";
            stringArray3[4] = "";
            stringArray = stringArray3;
            stringArray3[5] = "";
        }
        String[] labels = stringArray;
        JComponent[] values = new JComponent[labels.length];
        values[0] = new LabelDescription("<html>Please enter Admin username and password.  This will be<br>used for VE configuration.");
        values[1] = new DialogSeparator();
        values[2] = this._field1.getPanel();
        if (switchList.size() == 2) {
            String sw2Name = switchList.get(1).getSysName();
            this._field2 = new UserCredentialsPanel(sw2Name, this);
            this._sameCred = new JCheckBox("Use same credentials for both switches");
            values[2] = this._sameCred;
            values[3] = this._field1.getPanel();
            values[4] = new DialogSeparator();
            values[5] = this._field2.getPanel();
        }
        JPanel fields = DialogUtil.buildPanel(DialogUtil.buildLabels(labels), values);
        String[] btns = new String[]{"Ok", "Cancel"};
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)fields, (AbstractButton[])DialogUtil.buildButtons(btns, (ActionListener)this));
        if (this._sameCred != null) {
            this._sameCred.addItemListener(this);
            this._sameCred.setSelected(true);
        }
        this.setModal(true);
        this.setResizable(true);
    }

    private void setUserCredentials() {
        this._userCredentials = new HashMap();
        if (this._field1 != null) {
            this._userCredentials.put(this._switches.get(0).getPK(), this._field1.getUserOpt());
        }
        if (this._field2 != null) {
            if (this._sameCred != null && this._sameCred.isSelected()) {
                this._userCredentials.put(this._switches.get(1).getPK(), this._field1.getUserOpt());
            } else {
                this._userCredentials.put(this._switches.get(1).getPK(), this._field2.getUserOpt());
            }
        }
    }

    public HashMap<PKIf, SnmpUserOpt> getUserCredentials() {
        return this._userCredentials;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'O': {
                if (this._field1 != null && !this._field1.verify()) {
                    return;
                }
                if (this._field2 != null && this._sameCred != null && !this._sameCred.isSelected() && !this._field2.verify()) {
                    return;
                }
                this.setUserCredentials();
                this._closed = false;
                this.setVisible(false);
                break;
            }
            case 'C': {
                this._closed = true;
                this.setVisible(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this._sameCred.isSelected()) {
            this._field1.showDesc(false);
            this._field2.getPanel().setVisible(false);
        } else {
            this._field1.showDesc(true);
            this._field2.getPanel().setVisible(true);
        }
    }

    void showDialog() {
        this._closed = false;
        this.setVisible(true);
    }

    boolean getCancelled() {
        return this._closed;
    }

    class UserCredentialsPanel {
        private static final long serialVersionUID = -6165868946410830770L;
        LabelDescription _desc;
        KTextField _user;
        JPasswordField _pass;
        JComboBox _priv = new JComboBox<String>(SnmpUserOpt.SNMP_V3_PARAMS);
        String _switchName;
        JPanel _panel;
        Component _parent;

        UserCredentialsPanel(String switchName, Component parent) {
            this._switchName = switchName;
            this._parent = parent;
            String[] labels = new String[]{"", "", "Username:", "Password:", "Auth-Privacy:"};
            JComponent[] values = new JComponent[labels.length];
            this._user = new KTextField();
            this._pass = new JPasswordField();
            this._desc = new LabelDescription("<html> Enter admin credentials for " + this._switchName);
            values[0] = this._desc;
            values[1] = new DialogSeparator();
            values[2] = this._user;
            values[3] = this._pass;
            values[4] = this._priv;
            this._panel = DialogUtil.buildPanel(DialogUtil.buildLabels(labels), values);
        }

        JPanel getPanel() {
            return this._panel;
        }

        String getUser() {
            return this._user.getText();
        }

        String getPass() {
            return new String(this._pass.getPassword());
        }

        int getPriv() {
            return this._priv.getSelectedIndex();
        }

        void showDesc(boolean show) {
            this._desc.setVisible(show);
        }

        boolean verify() {
            if (this.getUser() == null || this.getUser().equals("")) {
                if (this._desc.isVisible()) {
                    Util.errorMessage(this._parent, "Please enter a valid user name for " + this._switchName + ".");
                } else {
                    Util.errorMessage(this._parent, "Please enter a valid user name.");
                }
                return false;
            }
            if (this.getPass() == null || this.getPass().equals("")) {
                if (this._desc.isVisible()) {
                    Util.errorMessage(this._parent, "Please enter a valid password for " + this._switchName + ".");
                } else {
                    Util.errorMessage(this._parent, "Please enter a valid password.");
                }
                return false;
            }
            return true;
        }

        SnmpUserOpt getUserOpt() {
            return new SnmpUserOpt(this.getUser(), this.getPass(), null, this.getPriv(), true);
        }
    }
}

