/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.wizard;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.fcoe.AbstractFCoEConfigCommands;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcoe.wizard.AuthenticationDialog;
import com.cisco.dcbu.sm.client.fcoe.wizard.ConfigureEthernetInterfacesPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationModeSelectionPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.SelectFCoESwitchPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.VEConfigureEthernetInterfacesPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.VESelectFCoESwitchPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.VEVLANVSANMappingPanel;
import com.cisco.dcbu.sm.client.fcoe.wizard.VLANVSANMappingPanel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.awt.Component;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class FCoEConfigurationWizard
extends JWizard {
    private static final long serialVersionUID = -2406997925953349405L;
    private static FCoEConfigurationWizard _Instance = null;
    static final String _SelectedDomain = "SELECTED_DOMAIN";
    static final String _SelectedFCoEConfig = "SELECTED_FCOE_CONFIG";
    static final String _SelectedFCoESwitch = "SELECTED_FCOE_SWITCH";
    static final String _SelectedEthNPVSwitch = "SELECTED_ETH_NPV_SWITCH";
    static final String _SelectedVLANVSAN = "Selected VLAN VSAN Mapping";
    static final String _ActiveVLANVSANs = "Active VLAN VSAN Mappings";
    static final String _SWITCHIPMAP = "SWITCH IP ADDRESS Mappings";
    static final String _FcoeCmdObj = "fcoeCmdObj";
    static final HashMap<PKIf, SnmpUserOpt> switchCredentials = new HashMap();
    public static List<Integer> fcoeCardTypes = new ArrayList<Integer>();
    static final String _SelectedVEFCoESwitches = "SELECTED_VE_FCOE_SWITCHES";
    static final String _SelectedInterfaces = "SELECTED_INTERFACES";
    static final String _SwitchVFCAdminMode = "SWITCH_VFC_ADMIN_MODE";
    private static final String SELECT_FCoE_MODE = "Select FCoE Mode";
    private static final String SELECT_SWITCH = "Select Switch";
    private static final String VLAN_VSAN_MAPPING = "Vlan Vsan Mapping";
    private static final String CONFIGURE_ETHERNET_INTERFACES = "Configure Ethernet Interfaces";
    private static final String SELECT_VE_SWITCHES = "Select VE Switches";
    private static final String VE_VLAN_VSAN_MAPPING = "VE Vlan Vsan Mapping";
    private static final String VE_CONFIGURE_ETHERNET_INTERFACES = "Configure Ethernet Interfaces";
    public static final int VF_MODE = 2;
    public static final int VE_MODE = 4;
    public static final int VNP_MODE = 16;
    public static final String VF_MODE_STR = "VF";
    public static final String VE_MODE_STR = "VE";
    public static final String VNP_MODE_STR = "VF-VNP";
    public static int FCOE_CONFIG_MODE;
    private WizardPanel selectSwitches;
    private WizardPanel vlanVsanMapping;
    private WizardPanel configEthernet;
    private WizardPanel selectVESwitches;
    private WizardPanel veVlanVsanMapping;
    private WizardPanel veConfigEthernet;
    private WizardPanel selectEthNPVSwitches;
    public static boolean isISLLaunch;
    static ImageIcon _ImageFcoe;
    static String SNMPAUTHERROR;

    public static synchronized FCoEConfigurationWizard getInstance(JFrame parent) {
        if (_Instance == null) {
            _Instance = new FCoEConfigurationWizard(parent);
        }
        _Instance.setVisible(true);
        return _Instance;
    }

    public static synchronized FCoEConfigurationWizard getInstance(JFrame parent, ArrayList<EthIsl> ethIsls) throws Exception {
        if (_Instance == null) {
            _Instance = new FCoEConfigurationWizard(parent, ethIsls);
        }
        _Instance.setVisible(true);
        return _Instance;
    }

    private FCoEConfigurationWizard(JFrame parent, ArrayList<EthIsl> ethIsls) throws Exception {
        super(parent);
        isISLLaunch = true;
        this.setTitle("FCoE Configuration Wizard" + ClientController.getInstance().getDialogMgmtDomainTitlePostfix());
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"FCoEConfigurationWizard : Initializing the FCoEConfigurationWizard.");
        }
        this.initializeWizard(ethIsls);
        VEVLANVSANMappingPanel mappingPanel = new VEVLANVSANMappingPanel(this);
        VEConfigureEthernetInterfacesPanel veConfigPanel = new VEConfigureEthernetInterfacesPanel(this);
        this.addPanel(VE_VLAN_VSAN_MAPPING, mappingPanel);
        this.addPanel("Configure Ethernet Interfaces", veConfigPanel);
        this.first();
        this.setSize(700, 525);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initializeWizard(ArrayList<EthIsl> ethIsls) throws Exception {
        FCoEConfigurationRif fcoeProxy = (FCoEConfigurationRif)ClientController.getInstance().getRemoteLANServerByFacility(ClientController.getInstance().getCurrentLanPK(), "FCoEConfigurationBean", "com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif");
        ArrayList<AbstractSwitch> selectedSwitches = new ArrayList<AbstractSwitch>();
        LinkedHashMap interfacesList = new LinkedHashMap();
        ArrayList<PKIf> switchList = new ArrayList<PKIf>();
        for (EthIsl ethIsl : ethIsls) {
            PKIf sw1PK = ethIsl.getSwitch1().getPK();
            PKIf sw2PK = ethIsl.getSwitch2().getPK();
            if (!switchList.contains(sw1PK)) {
                switchList.add(sw1PK);
            }
            if (switchList.contains(sw2PK)) continue;
            switchList.add(sw2PK);
        }
        if (switchList.size() > 2) {
            throw new Exception("Please select ethenet ISLs between a switch pair.");
        }
        Hashtable<PKIf, HashSet<Integer>> veSwitchList = fcoeProxy.getVEFCoESwitchList(ClientController.getInstance().getCurrentLanPK(), switchList);
        Vector<PKIf> npvSwitches = fcoeProxy.getNPVSwitchList(ClientController.getInstance().getCurrentLanPK(), switchList);
        int n = FCOE_CONFIG_MODE = npvSwitches.isEmpty() ? 4 : 16;
        if (veSwitchList.size() == 2 && !npvSwitches.containsAll(switchList)) {
            for (EthIsl ethIsl : ethIsls) {
                if (!ethIsl.isPresent()) continue;
                PKIf sw1PK = ethIsl.getSwitch1().getPK();
                PKIf sw2PK = ethIsl.getSwitch2().getPK();
                if (!this.verifyLinkEndPoints(ethIsl)) continue;
                int ifIndex1 = ethIsl.getIfIndex1();
                int ifIndex2 = ethIsl.getIfIndex2();
                if (!veSwitchList.containsKey(sw1PK) || !veSwitchList.containsKey(sw2PK) || veSwitchList.get(sw1PK).contains(ifIndex1) || veSwitchList.get(sw2PK).contains(ifIndex2)) continue;
                selectedSwitches.add(ethIsl.getSwitch1());
                selectedSwitches.add(ethIsl.getSwitch2());
                ArrayList<String> sw1Interfaces = (ArrayList<String>)interfacesList.get(selectedSwitches.get(0));
                ArrayList<String> sw2Interfaces = (ArrayList<String>)interfacesList.get(selectedSwitches.get(1));
                if (sw1Interfaces == null) {
                    sw1Interfaces = new ArrayList<String>();
                    interfacesList.put(selectedSwitches.get(0), sw1Interfaces);
                }
                sw1Interfaces.add(ethIsl.getIfIndex1Name());
                if (sw2Interfaces == null) {
                    sw2Interfaces = new ArrayList<String>();
                    interfacesList.put(selectedSwitches.get(1), sw2Interfaces);
                }
                sw2Interfaces.add(ethIsl.getIfIndex2Name());
            }
        }
        if (selectedSwitches.size() < 2) {
            throw new Exception("No Ethernet ISL available for VE FCoE Configuration. \nThe following criterions are used for filtering the VE capable Ethernet ISLs :\n1. Ethernet ISL should be up.\n2. Ethernet ISL should be between two FCoE capable cards on VE FCoE capable switches.\n3. Ethernet ISL end point interface should not be already bound to an vFC interface. \n \nNote: UCS switches currently block SNMP write-access and as such are excluded.");
        }
        AbstractSwitch[] switches = selectedSwitches.toArray(new AbstractSwitch[2]);
        if (!this.verifySwitchCredentials(switches)) {
            throw new Exception("Operation cancelled by user.");
        }
        this.verifyFCoEFeatureStatus(switches[0], switches[1]);
        this.setModelValue(_SelectedVEFCoESwitches, switches);
        this.setModelValue(_SelectedInterfaces, interfacesList);
        this.setModelValue(_SwitchVFCAdminMode, this.getSwitchVFCAdminModes(switches));
    }

    public boolean verifyLinkEndPoints(EthIsl isl) {
        int slot;
        AbstractSwitch sw2;
        AbstractSwitch sw1 = isl.getSwitch1();
        if (sw1 == (sw2 = isl.getSwitch2())) {
            return false;
        }
        if (!sw1.isNuovaFamily()) {
            int[] cardTypesSw1 = sw1.getCardTypeInSlots();
            if (cardTypesSw1 == null) {
                return false;
            }
            int ifIndex1 = isl.getIfIndex1();
            int portType1 = sw1.getType(ifIndex1);
            if (22 != portType1 && !fcoeCardTypes.contains(cardTypesSw1[slot = sw1.ifIndex2Card(ifIndex1)])) {
                return false;
            }
        }
        if (!sw2.isNuovaFamily()) {
            int[] cardTypesSw2 = sw2.getCardTypeInSlots();
            if (cardTypesSw2 == null) {
                return false;
            }
            int ifIndex2 = isl.getIfIndex2();
            int portType2 = sw2.getType(ifIndex2);
            if (22 != portType2 && !fcoeCardTypes.contains(cardTypesSw2[slot = sw2.ifIndex2Card(ifIndex2)])) {
                return false;
            }
        }
        return true;
    }

    public boolean verifySwitchCredentials(AbstractSwitch[] selectedSwitches) throws Exception {
        FCoEConfigurationRif fcoeProxy;
        PKIf sw1Pk = selectedSwitches[0].getPK();
        PKIf sw2Pk = selectedSwitches[1].getPK();
        try {
            HashMap<PKIf, SnmpUserOpt> userCredentials = new HashMap<PKIf, SnmpUserOpt>();
            if (switchCredentials.containsKey(sw1Pk)) {
                userCredentials.put(sw1Pk, switchCredentials.get(sw1Pk));
            }
            if (switchCredentials.containsKey(sw2Pk)) {
                userCredentials.put(sw2Pk, switchCredentials.get(sw2Pk));
            }
            if (userCredentials.size() < 2) {
                ArrayList<AbstractSwitch> v2Switches = new ArrayList<AbstractSwitch>();
                for (AbstractSwitch sw : selectedSwitches) {
                    if (userCredentials.containsKey(sw.getPK())) continue;
                    v2Switches.add(sw);
                }
                if (!v2Switches.isEmpty()) {
                    AuthenticationDialog d = new AuthenticationDialog((Frame)BrowserFrame.getInstance(), v2Switches);
                    d.showDialog();
                    if (d.getCancelled()) {
                        int len$ = 0;
                        return len$ != 0;
                    }
                    userCredentials.putAll(d.getUserCredentials());
                    switchCredentials.putAll(userCredentials);
                }
            }
            Util.setBusy(true, BrowserFrame.getDataView());
            if (!userCredentials.isEmpty()) {
                fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                fcoeProxy.setUserCredentials(userCredentials);
            }
        }
        catch (RemoteException ex) {
            try {
                fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                ArrayList<PKIf> userOptions = fcoeProxy.checkUserCredentials(sw1Pk, sw2Pk);
                for (PKIf sw : userOptions) {
                    if (!switchCredentials.containsKey(sw)) continue;
                    switchCredentials.remove(sw);
                }
                Util.setBusy(false, BrowserFrame.getDataView());
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
                boolean bl = this.verifySwitchCredentials(selectedSwitches);
                return bl;
            }
            catch (Exception e) {
                throw ex;
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to verify switch credentials. Reason : ", e);
        }
        finally {
            Util.setBusy(false, BrowserFrame.getDataView());
        }
        return true;
    }

    public HashMap<PKIf, Integer> getSwitchVFCAdminModes(AbstractSwitch[] selectedSwitches) throws Exception {
        HashMap<PKIf, Integer> switchVFCAdminMode = new HashMap<PKIf, Integer>();
        PKIf sw1Pk = selectedSwitches[0].getPK();
        PKIf sw2Pk = selectedSwitches[1].getPK();
        if (FCOE_CONFIG_MODE == 4) {
            switchVFCAdminMode.put(sw1Pk, 4);
            switchVFCAdminMode.put(sw2Pk, 4);
        } else if (this.isNPVEnabled(selectedSwitches[0])) {
            this.verifyNPIVFeatureStatus(selectedSwitches[1]);
            switchVFCAdminMode.put(sw1Pk, 16);
            switchVFCAdminMode.put(sw2Pk, 2);
        } else if (this.isNPVEnabled(selectedSwitches[1])) {
            this.verifyNPIVFeatureStatus(selectedSwitches[0]);
            switchVFCAdminMode.put(sw1Pk, 2);
            switchVFCAdminMode.put(sw2Pk, 16);
        } else {
            throw new Exception("Failed to verify NPV status on selected switches.");
        }
        return switchVFCAdminMode;
    }

    public String getVFCModeString() {
        switch (FCOE_CONFIG_MODE) {
            case 4: {
                return VE_MODE_STR;
            }
            case 16: {
                return VNP_MODE_STR;
            }
        }
        return VF_MODE_STR;
    }

    public boolean isFCoEEnabled(AbstractSwitch sw1) {
        try {
            FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
            return fcoeProxy.isFCoEEnabled(sw1.getPK());
        }
        catch (Exception e) {
            if (DefaultLogger._DefLogger.isDebugEnabled()) {
                DefaultLogger._DefLogger.debug((Object)("FCoEConfigurationWizard: isFCoEEnabled(), Exception occurred while checking FCoE feature status on switch " + sw1.getSysName() + ". Returning fcoe status as false. "), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isNPVEnabled(AbstractSwitch sw1) {
        try {
            FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
            return fcoeProxy.isNPVEnabled(sw1.getPK());
        }
        catch (Exception e) {
            if (DefaultLogger._DefLogger.isDebugEnabled()) {
                DefaultLogger._DefLogger.debug((Object)("FCoEConfigurationWizard: isNPVEnabled(), Exception occurred while checking NPV feature status on switch " + sw1.getSysName() + ". Returning NPV status as false. "), (Throwable)e);
            }
            return false;
        }
    }

    public void verifyNPIVFeatureStatus(AbstractSwitch sw1) throws Exception {
        if (!this.isNPIVEnabled(sw1)) {
            this.enableNPIV(sw1);
        }
    }

    public boolean isNPIVEnabled(AbstractSwitch sw1) {
        try {
            FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
            return fcoeProxy.isNPIVEnabled(sw1.getPK());
        }
        catch (Exception e) {
            if (DefaultLogger._DefLogger.isDebugEnabled()) {
                DefaultLogger._DefLogger.debug((Object)("FCoEConfigurationWizard: isNPIVEnabled(), Exception occurred while checking NPIV feature status on switch " + sw1.getSysName() + ". Returning NPIV status as false. "), (Throwable)e);
            }
            return false;
        }
    }

    private void enableFCoE(AbstractSwitch sw1) throws Exception {
        try {
            FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
            fcoeProxy.enableFCoE(sw1.getPK());
        }
        catch (Exception ex) {
            if (FCoEConfigurationWizard.isAuthorizationError(ex)) {
                FCoEConfigurationWizard.clearSwitchCredentials(sw1);
            }
            throw new Exception("Failed to enable FCoE on switch " + sw1.getSysName() + ". Reason  " + ex.getMessage());
        }
    }

    public static boolean isAuthorizationError(Exception ex) {
        String msg = ex.getMessage();
        return msg.indexOf(SNMPAUTHERROR) != -1 || msg.indexOf(AbstractFCoEConfigCommands.AUTHORIZATIONERROR) != -1;
    }

    public static void clearSwitchCredentials(AbstractSwitch sw) {
        switchCredentials.remove(sw.getPK());
    }

    private void enableNPIV(AbstractSwitch sw1) throws Exception {
        try {
            FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
            fcoeProxy.enableNPIV(sw1.getPK());
        }
        catch (Exception ex) {
            if (FCoEConfigurationWizard.isAuthorizationError(ex)) {
                FCoEConfigurationWizard.clearSwitchCredentials(sw1);
            }
            throw new Exception("Failed to enable NPIV on switch " + sw1.getSysName() + ". Reason  " + ex.getMessage());
        }
    }

    public void verifyFCoEFeatureStatus(AbstractSwitch sw1, AbstractSwitch sw2) throws Exception {
        if (!this.isFCoEEnabled(sw1)) {
            this.enableFCoE(sw1);
        }
        if (!this.isFCoEEnabled(sw2)) {
            this.enableFCoE(sw2);
        }
    }

    private FCoEConfigurationWizard(JFrame parent) {
        super(parent);
        isISLLaunch = false;
        this.setTitle("FCoE Configuration Wizard" + ClientController.getInstance().getDialogMgmtDomainTitlePostfix());
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"FCoEConfigurationWizard : Initializing the FCoEConfigurationWizard.");
        }
        this.addPanel(SELECT_FCoE_MODE, new FCoEConfigurationModeSelectionPanel(this));
        this.first();
        this.setSize(700, 525);
        this.setLocationRelativeTo(this.getParent());
    }

    public static SnmpKTable createNewTable(KTableModel model) {
        SnmpKTable table = new SnmpKTable(model);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.setSelectionMode(2);
        return table;
    }

    @Override
    public void updateNavBtn() {
        Object[] o = (Object[])this._cards.elementAt(this._currentCardIndex);
        if (o == null || o[0] == null) {
            return;
        }
        if (o[0].equals(SELECT_FCoE_MODE)) {
            this._nav.setButtonAttr(false, false);
        } else if (o[0].equals("Configure Ethernet Interfaces") || o[0].equals("Configure Ethernet Interfaces")) {
            this._nav.setButtonAttr(false, true);
        } else {
            super.updateNavBtn();
        }
    }

    @Override
    public void setModelValue(String name, Object value) {
        if (name.equals(_SelectedFCoEConfig)) {
            int fcoeConfig = (Integer)value;
            Integer fcoeConfigMode = (Integer)this.getModelValue(_SelectedFCoEConfig);
            if (fcoeConfigMode == null || fcoeConfigMode != fcoeConfig) {
                this.updateSteps(fcoeConfig);
            }
        }
        super.setModelValue(name, value);
    }

    private void updateSteps(int fcoeConfig) {
        this.removeAllPanelAfterCurrent();
        switch (fcoeConfig) {
            case 2: {
                FCOE_CONFIG_MODE = 2;
                if (this.selectSwitches == null) {
                    this.selectSwitches = new SelectFCoESwitchPanel(this);
                }
                if (this.vlanVsanMapping == null) {
                    this.vlanVsanMapping = new VLANVSANMappingPanel(this);
                }
                if (this.configEthernet == null) {
                    this.configEthernet = new ConfigureEthernetInterfacesPanel(this);
                }
                this.addPanel(SELECT_SWITCH, this.selectSwitches);
                this.addPanel(VLAN_VSAN_MAPPING, this.vlanVsanMapping);
                this.addPanel("Configure Ethernet Interfaces", this.configEthernet);
                break;
            }
            case 4: {
                FCOE_CONFIG_MODE = 4;
                if (this.selectVESwitches == null) {
                    this.selectVESwitches = new VESelectFCoESwitchPanel(this);
                }
                if (this.veVlanVsanMapping == null) {
                    this.veVlanVsanMapping = new VEVLANVSANMappingPanel(this);
                }
                if (this.veConfigEthernet == null) {
                    this.veConfigEthernet = new VEConfigureEthernetInterfacesPanel(this);
                }
                this.addPanel(SELECT_VE_SWITCHES, this.selectVESwitches);
                this.addPanel(VE_VLAN_VSAN_MAPPING, this.veVlanVsanMapping);
                this.addPanel("Configure Ethernet Interfaces", this.veConfigEthernet);
                break;
            }
            case 16: {
                FCOE_CONFIG_MODE = 16;
                if (this.selectEthNPVSwitches == null) {
                    this.selectEthNPVSwitches = new VESelectFCoESwitchPanel(this);
                }
                if (this.veVlanVsanMapping == null) {
                    this.veVlanVsanMapping = new VEVLANVSANMappingPanel(this);
                }
                if (this.veConfigEthernet == null) {
                    this.veConfigEthernet = new VEConfigureEthernetInterfacesPanel(this);
                }
                this.addPanel(SELECT_VE_SWITCHES, this.selectEthNPVSwitches);
                this.addPanel(VE_VLAN_VSAN_MAPPING, this.veVlanVsanMapping);
                this.addPanel("Configure Ethernet Interfaces", this.veConfigEthernet);
            }
        }
    }

    @Override
    public void dispose() {
        Integer selValue = (Integer)this.getModelValue(_SelectedFCoEConfig);
        if (selValue != null && selValue == 4) {
            try {
                FCoEConfigurationRif fcoeProxy = ClientController.getInstance().assertFCoEConfiguration();
                fcoeProxy.clearCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
        _Instance = null;
    }

    static {
        int[] fcoeAllowedCardTypes = FRUConstants.getAllFCoECapableCardTypes();
        for (int i = 0; i < fcoeAllowedCardTypes.length; ++i) {
            fcoeCardTypes.add(fcoeAllowedCardTypes[i]);
        }
        FCOE_CONFIG_MODE = 2;
        _ImageFcoe = Util.loadIcon("icons/fcoe.png");
        SNMPAUTHERROR = SnmpException.toError(16);
    }
}

