/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.wizard;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationCommandsFactory;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationHelper;
import com.cisco.dcbu.sm.client.fcoe.model.FCoESwitchTableModel;
import com.cisco.dcbu.sm.client.fcoe.view.FCoESwitchTable;
import com.cisco.dcbu.sm.client.fcoe.wizard.FCoEConfigurationWizard;
import com.cisco.dcbu.sm.client.fcoe.wizard.SwitchObject;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class SelectFCoESwitchPanel
extends WizardPanel {
    private static final long serialVersionUID = -5299241929076771175L;
    private FCoESwitchTableModel _tableModel = null;
    private FCoESwitchTable _fcoeSwitchTable;
    private Switch[] _fcoeSwitches;
    private static String _panelName = new String("Step 2 of 4: Select FCoE Switch");
    private static String _panelDesc = new String("Select the FCoE switch for which the virtual FC interfaces are to be created. \n \nNote: UCS switches currently block SNMP write-access and as such are excluded.");

    public SelectFCoESwitchPanel(JWizard wizard) {
        super(_panelName, _panelDesc, wizard, FCoEConfigurationWizard._ImageFcoe);
        this.add((Component)this.createTablePanel(this._fcoeSwitches), "Center");
    }

    protected JScrollPane createTablePanel(Switch[] fcoeSwitches) {
        this._fcoeSwitchTable = this.createFCoESwitchTable();
        this._fcoeSwitchTable.setSelectionMode(0);
        JScrollPane sc = new JScrollPane(this._fcoeSwitchTable);
        return sc;
    }

    protected FCoESwitchTable createFCoESwitchTable() {
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"SelectFCoESwitchPanel : createFCoESwitchTable(), Creating the FCoE Switch Table.");
        }
        this._tableModel = new FCoESwitchTableModel();
        FCoESwitchTable table = new FCoESwitchTable((TableModel)this._tableModel, false);
        return table;
    }

    public FCoESwitchTableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public boolean refresh() {
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"SelectFCoESwitchPanel : refresh(), Getting the FCoE Switch table data.");
        }
        this.setDataValid(!this._tableModel.getData().isEmpty());
        return this.isDataValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doNext() {
        try {
            FCoEConfigCommandsIf fcoeCmdObj;
            this.setBusy(true);
            int[] rows = this._fcoeSwitchTable.getSelectedRows();
            if (rows == null || rows.length != 1) {
                Util.errorMessage((Component)this.getWizard(), "Please select one switch.");
                return;
            }
            SwitchObject selectedSwitchObj = this._tableModel.getSwitchAtRow(rows[0]);
            Switch selectedSwitch = (Switch)selectedSwitchObj.getSwitch();
            FCoEConfigCommandsIf fcoeCmd = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands(BrowserFrame.getInstance(), selectedSwitch.getPeer(), selectedSwitch);
            if (!this._tableModel.isFCoEEnabledOnRow(rows[0])) {
                try {
                    FCoEConfigurationHelper.enableFCoE(selectedSwitch, selectedSwitch.getPeer());
                }
                catch (Exception ex) {
                    fcoeCmd.disconnect();
                    Util.errorMessage((Component)this.getWizard(), "Failed to enable FCoE feature on " + selectedSwitch.getSysName() + ". Reason : " + ex.getMessage());
                    this.setBusy(false);
                    return;
                }
            }
            if ((fcoeCmdObj = (FCoEConfigCommandsIf)this.getModelValue("fcoeCmdObj")) != null) {
                fcoeCmdObj.disconnect();
            }
            this.setModelValue("fcoeCmdObj", fcoeCmd);
            Switch selValue = (Switch)this.getModelValue("SELECTED_FCOE_SWITCH");
            if (selValue == null || !selValue.equals(selectedSwitch)) {
                this.setModelValue("SELECTED_FCOE_SWITCH", selectedSwitch);
                this.setDataValidForAllPanels(false);
                this.setDataValid(true);
            }
            super.doNext();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this.getWizard(), ex);
        }
        finally {
            this.setBusy(false);
        }
    }

    protected void setDataValidForAllPanels(boolean flag) {
        int panelIndex = this.getWizard().getCurrentCardIndex();
        WizardPanel pnl = null;
        do {
            if (null != (pnl = this.getWizard().get(panelIndex))) {
                pnl.setDataValid(flag);
            }
            ++panelIndex;
        } while (pnl != null);
    }
}

