/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIdList;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class InsertForm
implements ActionListener,
SnmpCallbackIf {
    protected InsertDialog _parent;
    protected SmTableModel _table;
    protected JButton[] _buttons;
    protected JLabel[] _labels;
    protected JComponent[] _values;
    protected SnmpVar[] _insertValues;
    protected String[] _vars;
    protected MibNode[] _mibNodes;
    protected SnmpPeer[] _peers;
    protected JPanel _container;
    protected JPanel _buttonPanel;
    protected int _pending;
    protected int _successfulSets;
    protected InsertRowCallback _insertRowCallback;
    protected InsertValidateCallback _insertValidateCallback;
    protected int[] _firstOid;
    protected int _insertValidate = -1;
    protected HashMap _peer2InsertRowIndex;
    protected Object[] _selPeerList;
    protected CheckBoxListPanel _list;
    protected Array _insertErrMsg;
    protected HashMap _insertErrPeers;
    JScrollPane _spSwitchList;
    protected JLabel _switchLabel;
    protected JComboBox _choice;
    protected boolean _multipleSwitches = true;
    protected String _swVersionSupportedGreater;
    protected String _swVersionSupportedGreaterEqual;
    protected String _swVersionSupportedLessThan;
    protected String _swVersionSupportedLessThanEqual;

    public InsertForm(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        this._peers = peers;
        this._parent = parent;
        this._table = table;
        this._vars = this._table.getInsertVars();
        this._container = new JPanel(new GridBagLayout());
        this._insertRowCallback = new InsertRowCallback();
        this._insertValidateCallback = new InsertValidateCallback();
        this._peer2InsertRowIndex = new HashMap();
        this._insertErrMsg = new Array();
        this._insertErrPeers = new HashMap();
    }

    public InsertForm(SnmpPeer[] peers, InsertDialog parent, SmTableModel table, boolean multipleSwitches) {
        this(peers, parent, table);
        this._multipleSwitches = multipleSwitches;
    }

    public void dispose() {
    }

    protected void build() throws Exception {
        int i;
        this.getValidPeers();
        if (this._peers == null || this._peers.length == 0) {
            throw new Exception("No managable switch has this feature.");
        }
        this._labels = new JLabel[this._vars.length];
        this._values = new JComponent[this._vars.length];
        this._mibNodes = new MibNode[this._vars.length];
        for (i = 0; i < this._values.length; ++i) {
            if (this._vars[i].charAt(0) == '-') {
                if (this._vars[i].length() <= 1) {
                    this._values[i] = new DialogSeparator();
                    continue;
                }
                this._values[i] = new DialogSeparator(this._vars[i].substring(1));
                continue;
            }
            this._mibNodes[i] = MibNode.get(this._vars[i]);
            this._values[i] = this.buildComponent(this._vars[i], this._mibNodes[i], i);
            if (this._values[i] instanceof JCheckBox) continue;
            this._labels[i] = this.createFormLabel(this._vars[i], i);
        }
        for (i = 0; i < this._mibNodes.length; ++i) {
            int defVal;
            if (this._mibNodes[i] == null || (defVal = this._mibNodes[i].getDefVal()) == -1) continue;
            if (this._values[i] instanceof JCheckBox) {
                ((JCheckBox)this._values[i]).setSelected(defVal == 1);
                continue;
            }
            if (this._values[i] instanceof GroupButtonPanel) {
                this.setGroupButtonPanel((GroupButtonPanel)this._values[i], this.getApplicableEnums(this._mibNodes[i]), new SnmpInt(defVal));
                continue;
            }
            this.setComponentText(i, Integer.toString(defVal));
        }
        this.layoutForm();
        this.addPeers();
        this.buildButtons();
    }

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        return mibNode.getEnums();
    }

    public SnmpPeer[] getValidPeers() {
        if (this._swVersionSupportedGreater != null || this._swVersionSupportedGreaterEqual != null || this._swVersionSupportedLessThan != null || this._swVersionSupportedLessThanEqual != null) {
            ArrayList<SnmpPeer> peersValid = new ArrayList<SnmpPeer>();
            for (int i = 0; i < this._peers.length; ++i) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
                if (!this.isVersionSupported(sw)) continue;
                peersValid.add(this._peers[i]);
            }
            this._peers = peersValid.toArray(new SnmpPeer[0]);
        }
        return this._peers;
    }

    protected void addPeers() throws Exception {
        this.addPeers(this._peers);
    }

    protected void addPeers(SnmpPeer[] peers) throws Exception {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = DialogUtil.getInsets();
        if (this._multipleSwitches) {
            Arrays.sort(peers);
            this._list = new CheckBoxListPanel(peers);
            this._spSwitchList = new JScrollPane(this._list);
            this._list.setUnitIncrement(this._spSwitchList);
            this._spSwitchList.setPreferredSize(new Dimension(160, 100));
            this._switchLabel = new JLabel("Switches:");
            DialogUtil.constrain(this._container, this._spSwitchList, gbc, 1, 0, 2, 17);
            String lookupIndex = this._table.getCfsFeatureName();
            if (this._table.getCfsVsan() != null) {
                lookupIndex = lookupIndex + Integer.toString(this._table.getCfsVsan().getVsanId());
            }
            if (!this.toShowSwitchList(lookupIndex)) {
                this._switchLabel.setVisible(false);
                this._spSwitchList.setVisible(false);
            }
        } else {
            this._choice = new JComboBox<SnmpPeer>(peers);
            this._switchLabel = new JLabel("Switch:");
            DialogUtil.constrain(this._container, this._choice, gbc, 1, 0, 2, 17);
            String lookupIndex = this._table.getCfsFeatureName();
            if (this._table.getCfsVsan() != null) {
                lookupIndex = lookupIndex + Integer.toString(this._table.getCfsVsan().getVsanId());
            }
            if (!this.toShowSwitchList(lookupIndex)) {
                this._switchLabel.setVisible(false);
                this._choice.setVisible(false);
            }
        }
        DialogUtil.constrain(this._container, this._switchLabel, gbc, 0, 0, 0, 13);
    }

    protected void showSwitchList(boolean bShow) {
        this._switchLabel.setVisible(bShow);
        this._spSwitchList.setVisible(bShow);
    }

    protected boolean toShowSwitchList(String cfsfeature) {
        return SmCfsUtil.getInstance().getMaster(cfsfeature) == null;
    }

    protected void layoutForm() {
        DialogUtil.buildPanel(this._container, this._labels, this._values);
    }

    protected String trim(String c) {
        return c;
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        Object[] enums;
        String tc = mibNode.getTCLabel();
        int width = this.getWidth(mibVar, mibNode, tc);
        if (tc != null) {
            if (tc.equals("TruthValue") || tc.equals("Action")) {
                return new JCheckBox(this._table.trim(mibVar));
            }
            if (tc.equals("Password")) {
                return new JPasswordField(20);
            }
        }
        if ((enums = this.getApplicableEnums(mibNode)) != null) {
            int grid = 3;
            if (enums.length < grid * 2) {
                grid = enums.length;
            }
            if (mibNode.getType() == 4) {
                return new CheckBoxPanel(enums, grid);
            }
            return new RadioButtonPanel(enums, grid);
        }
        if ((mibNode.getType() == 2 || mibNode.getType() == 66) && mibNode.getHi() != 0) {
            return new FieldPanel(width, mibNode.getLo(), mibNode.getHi(), (String)SnmpTableModel._Units.get(mibVar));
        }
        String units = (String)SnmpTableModel._Units.get(mibVar);
        if (units == null) {
            return new KTextField(width);
        }
        return new FieldPanel(width, (JComponent)new JLabel(" " + units));
    }

    protected int getWidth(String mibVar, MibNode mibNode, String tc) {
        int width = mibNode.getMaxWidth();
        if (mibNode.getType() == 4 || width > 31) {
            width = 32;
        }
        if (tc != null && tc.startsWith("FcNameId")) {
            width = 30;
        }
        if (tc != null && tc.equals("IscsiName")) {
            width = 40;
        }
        if (tc != null && tc.equals("DateAndTime")) {
            width = 25;
        }
        return width;
    }

    protected void setGroupButtonPanel(GroupButtonPanel rbp, MibEnum[] enums, SnmpVar val) {
        if (val.getType() == 4) {
            DefaultLogger._DefLogger.error((Object)"BITS tbd");
        } else if (val.getType() == 2) {
            int v = ((SnmpInt)val).getValue();
            for (int j = 0; j < enums.length; ++j) {
                if (v != enums[j].getValue()) continue;
                if (j < rbp.getComponentCount()) {
                    JToggleButton rb = rbp.getButton(j);
                    rb.setSelected(true);
                }
                return;
            }
        }
    }

    protected void setComponentText(int index, String text) {
        if (this._values[index] instanceof FieldPanel) {
            ((FieldPanel)this._values[index]).setText(text);
        } else if (this._values[index] instanceof JTextField) {
            ((JTextField)this._values[index]).setText(text);
        }
    }

    protected String getComponentText(int index) {
        if (this._values[index] instanceof FieldPanel) {
            return ((FieldPanel)this._values[index]).getText();
        }
        if (this._values[index] instanceof JTextField) {
            return ((JTextField)this._values[index]).getText();
        }
        return null;
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        return new JLabel(this.getFormLabel(mibVar, index) + ":", 4);
    }

    protected String getFormLabel(String mibVar, int index) {
        String v = this._table.trim(mibVar);
        v = v.replace("<html>", "");
        v = v.replace("<br>", " ");
        return v;
    }

    protected String getErrMsgFieldName(String mibVar, int index) {
        return this.getFormLabel(mibVar, index);
    }

    protected void setComponentVisibleAt(int index, boolean visible) {
        if (this._labels[index] != null) {
            this._labels[index].setVisible(visible);
        }
        this._values[index].setVisible(visible);
    }

    protected void setEnabled(int index, boolean enabled) {
        if (this._labels[index] != null) {
            this._labels[index].setEnabled(enabled);
        }
        this._values[index].setEnabled(enabled);
        if (this._values[index] instanceof JPasswordField) {
            ((JPasswordField)this._values[index]).setBackground(UIManager.getColor(enabled ? "TextField.background" : "Table.background"));
        }
    }

    protected void setStatus(String message) {
        this._parent._status.setText(message);
    }

    protected void buildButtons() {
        this._buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        String[] labels = new String[]{"Create", "Close"};
        this._buttons = DialogUtil.buildButtons(labels, (ActionListener)this);
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttonPanel.add(this._buttons[i]);
        }
    }

    protected void insert() throws Exception {
        this.insertInit();
        this._insertValues = this.getInsertValue();
        int[] index = this.getInsertIndex(this._insertValues);
        VarBindList vbl = this.buildInsertVarbind(index, this._insertValues);
        this.insertRow(vbl);
    }

    public void insertInit() throws Exception {
        this.getSelectedPeers();
        this._peer2InsertRowIndex.clear();
        this._insertErrMsg.clear();
        this._insertErrPeers.clear();
    }

    protected void getSelectedPeers() throws Exception {
        if (this._multipleSwitches) {
            if (this._list.getNumSelections() == 0) {
                throw new Exception("Please select a switch");
            }
            this._selPeerList = this._list.getSelectedValues();
        } else {
            this._selPeerList = new Object[]{this._choice.getSelectedItem()};
        }
    }

    public boolean isPeerSelected(SnmpPeer peer) {
        if (this._selPeerList != null) {
            for (int i = 0; i < this._selPeerList.length; ++i) {
                SnmpPeer selPeer = (SnmpPeer)this._selPeerList[i];
                if (!selPeer.getAddress().equals(peer.getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public SnmpPeer[] getSwVersionSupportedGreaterThan(String swVersionSupportedGreater) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < this._selPeerList.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
            if (!sw.isVersionGreaterThan(swVersionSupportedGreater)) continue;
            peers.add((SnmpPeer)this._selPeerList[i]);
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public SnmpPeer[] getSwVersionSupportedGreaterThanEqual(String swVersionSupportedGreaterEqual) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < this._selPeerList.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
            if (!sw.isVersionGreaterThanEqual(swVersionSupportedGreaterEqual)) continue;
            peers.add((SnmpPeer)this._selPeerList[i]);
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public SnmpPeer[] getSwVersionSupportedLessThan(String swVersionSupportedLessThan) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < this._selPeerList.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
            if (!sw.isVersionLessThan(swVersionSupportedLessThan)) continue;
            peers.add((SnmpPeer)this._selPeerList[i]);
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public SnmpPeer[] getSwVersionSupportedLessThanEqual(String swVersionSupportedLessThanEqual) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < this._selPeerList.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[i]).getAddress());
            if (!sw.isVersionLessThanEqual(swVersionSupportedLessThanEqual)) continue;
            peers.add((SnmpPeer)this._selPeerList[i]);
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        SnmpVar[] values = new SnmpVar[this._mibNodes.length];
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this.toGetComponentValue(i)) continue;
            try {
                values[i] = this.getComponentValue(i);
                continue;
            }
            catch (SnmpException ex) {
                String text = this.getComponentText(i);
                if (text != null && text.equals("") && !this._mibNodes[i].isIndex()) {
                    values[i] = null;
                    continue;
                }
                this._values[i].requestFocus();
                throw (SnmpException)ex.fillInStackTrace();
            }
            catch (Exception ex) {
                this.postComponentErrMsg(i, ex);
            }
        }
        return values;
    }

    protected boolean toGetComponentValue(int index) {
        return this._mibNodes[index].isIndex() || this._values[index].isEnabled();
    }

    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int varNo;
        int indexSize = 0;
        int StringVarNo = 0;
        for (varNo = 0; varNo < this._mibNodes.length && this._mibNodes[varNo] != null && this._mibNodes[varNo].isIndex(); ++varNo) {
            SnmpVar v = values[varNo];
            if (v instanceof SnmpString) {
                indexSize += ((SnmpString)v).getValue().length;
                if (!this.isAddStringLength(this._mibNodes[varNo])) continue;
                ++StringVarNo;
                continue;
            }
            if (v instanceof SnmpOID) {
                indexSize += ((SnmpOID)v).getValue().length;
                continue;
            }
            ++indexSize;
        }
        if (varNo > 1) {
            indexSize += StringVarNo;
        }
        int[] index = new int[indexSize];
        indexSize = 0;
        for (int i = 0; i < varNo; ++i) {
            SnmpVar v = values[i];
            if (v instanceof SnmpInt) {
                index[indexSize++] = ((SnmpInt)v).getValue();
                continue;
            }
            if (v instanceof SnmpUnsignedInt) {
                index[indexSize++] = (int)((SnmpUnsignedInt)v).getValue();
                continue;
            }
            if (v instanceof SnmpString) {
                byte[] b = ((SnmpString)v).getValue();
                if (this.isAddStringLength(this._mibNodes[i]) && varNo > 1) {
                    index[indexSize++] = b.length;
                }
                for (int j = 0; j < b.length; ++j) {
                    index[indexSize++] = b[j] & 0xFF;
                }
                continue;
            }
            if (!(v instanceof SnmpOID)) continue;
            int[] oidVal = ((SnmpOID)v).getValue();
            System.arraycopy(oidVal, 0, index, indexSize, oidVal.length);
            indexSize += oidVal.length;
        }
        return index;
    }

    protected boolean isAddStringLength(MibNode mibNode) {
        return mibNode.getType() == 4 && mibNode.getTCLabel() != null && !mibNode.getTCLabel().equals("FcAddressId") && !mibNode.getTCLabel().equals("FcNameId");
    }

    protected void insertRow(VarBindList vbl) throws Exception {
        this._successfulSets = 0;
        int pduSent = this.setInsertRow(vbl);
        if (pduSent != 0) {
            this.wait(this._peers);
        }
        if (this._successfulSets < this._selPeerList.length) {
            int failedSets = this._selPeerList.length - this._successfulSets;
            this._insertErrMsg.addElement("Failed on " + failedSets + " of " + this._selPeerList.length + " device(s).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object o) {
        try {
            Object object = o;
            synchronized (object) {
                o.wait(SnmpPeer._Timeout * (SnmpPeer._Retries + 1) + 5000);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int setInsertRow(VarBindList vbl) throws Exception {
        int pduSent = 0;
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPDU pdu = this.getInsertPDU((SnmpPeer)this._selPeerList[i], vbl);
            if (pdu == null) continue;
            ++this._pending;
            ++pduSent;
            ((SnmpPeer)this._selPeerList[i]).send(pdu, this);
        }
        return pduSent;
    }

    protected VarBindList buildInsertVarbind(int[] index, SnmpVar[] values) {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this._table._rowStatus, index), new SnmpInt(this._table._insertValue)));
        this._firstOid = this._table._rowStatus;
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || this._mibNodes[i].isIndex() || values[i] == null) continue;
            int[] mibOid = this._mibNodes[i].getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(mibOid, index), values[i]));
        }
        return vbl;
    }

    protected int[] getTableIndex(int[] index) {
        return index;
    }

    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        return new SnmpPDU(-93, vbl);
    }

    public void setInsertValidate(int insertValidate) {
        this._insertValidate = insertValidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer[] vb;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!timedOut && pdu.getError() == 0) {
            ++this._successfulSets;
            this.processInsertCfs();
            vb = pdu.getVariables().getVb(0);
            int[] oid = vb.getOid().getValue();
            if (oid.length >= this._firstOid.length) {
                int[] index = new int[oid.length - this._firstOid.length];
                System.arraycopy(oid, this._firstOid.length, index, 0, oid.length - this._firstOid.length);
                if (this._insertValidate != -1) {
                    SnmpVarBind rowStatus = pdu.getVariables().getVb(0);
                    rowStatus.setVar(new SnmpInt(this._insertValidate));
                    pdu.reset();
                    pdu.setCommand((byte)-93);
                    pdu.getVariables().add(rowStatus);
                    try {
                        ++this._pending;
                        node.send(pdu, this._insertValidateCallback);
                    }
                    catch (SnmpException ex) {
                        // empty catch block
                    }
                    return;
                }
                if (this._insertRowCallback != null) {
                    SnmpPDU qPdu = this._table.buildGetPdu(node, this.getTableIndex(index));
                    ++this._pending;
                    try {
                        node.send(qPdu, this._insertRowCallback);
                    }
                    catch (SnmpException ex) {}
                }
            }
        } else {
            this.processInsertError(node, pdu, timedOut);
        }
        --this._pending;
        if (this._pending <= 0) {
            try {
                vb = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[vb] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    protected void processInsertCfs() {
        try {
            SmCfsUtil.getInstance().processCfs(this._table, this._table.getCfsFeatureName(), this._table.getCfsVsan(), 2);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    protected void processInsertError(SnmpPeer peer, SnmpPDU pdu, boolean timedOut) {
        this._insertErrPeers.put(peer, peer);
        if (timedOut) {
            this._insertErrMsg.addElement(peer + ": timeout");
        } else {
            ++this._pending;
            Thread t = new Thread((Runnable)new SnmpErrorDetailRunnable(peer, pdu), "SnmpErrorDetailRunnable");
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRowCallback(SnmpPDU pdu, boolean timedOut) {
        SnmpPeer[] strErr;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!timedOut && pdu.getError() == 0) {
            SnmpVarBind vb = pdu.getVariables().getVb(0);
            int[] oid = vb.getOid().getValue();
            int[] firstOid = this.getTableFirstOid();
            SnmpOID index = new SnmpOID(oid, firstOid.length, oid.length - firstOid.length);
            SmTableModel curActiveTableModel = BrowserFrame.getDataView()._tableModel;
            boolean bAddRow2Table = true;
            if (curActiveTableModel != this._table) {
                String ownerModelInsertTitle;
                String insertTitle = this._parent.getTitle();
                if (insertTitle.equals(ownerModelInsertTitle = BrowserFrame.getDataView().getInsertDlgTitle())) {
                    this._table = curActiveTableModel;
                } else {
                    bAddRow2Table = false;
                }
            }
            if (bAddRow2Table && this._table.validateInsertRowVbl(node, pdu.getVariables(), 1)) {
                this._table.addElement(pdu.getVariables(), node, index);
                if (!this._peer2InsertRowIndex.containsKey(node)) {
                    int rowIndex = this._table.getData().size() - 1;
                    this._peer2InsertRowIndex.put(node, new Integer(rowIndex));
                }
            }
        } else if (timedOut) {
            this._insertErrMsg.addElement(node + ": timeout");
        } else {
            strErr = SnmpReportException.getError(pdu);
            this._insertErrMsg.addElement(node + ": " + (String)strErr);
        }
        --this._pending;
        if (this._pending <= 0) {
            try {
                strErr = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[strErr] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    protected int[] getTableFirstOid() {
        return this._firstOid;
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (this._values[index] instanceof JTextField) {
            return this.getVarFromString(((JTextField)this._values[index]).getText(), index);
        }
        if (this._values[index] instanceof JComboBox) {
            return this.getVarFromString(((JComboBox)this._values[index]).getSelectedItem().toString(), index);
        }
        if (this._values[index] instanceof JCheckBox) {
            Boolean val = new Boolean(((JCheckBox)this._values[index]).isSelected());
            SnmpVar value = SnmpTableModel.getMibVariableSet(this._vars[index], val, SmCommandDispatcher._MibVariableSetMethods, SmCommandDispatcher._MibVariableSetClass);
            if (value != null && value instanceof SnmpVar) {
                return value;
            }
            return new SnmpInt(((JCheckBox)this._values[index]).isSelected() ? 1 : 2);
        }
        if (this._values[index] instanceof RadioButtonPanel) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (selected == -1) {
                throw new SnmpException(this._labels[index].getText() + " please make a selection");
            }
            MibEnum[] enums = this.getApplicableEnums(this._mibNodes[index]);
            return new SnmpInt(enums[selected].getValue());
        }
        if (this._values[index] instanceof CheckBoxPanel) {
            int nOfComp = ((CheckBoxPanel)this._values[index]).getComponentCount() + 1;
            int byteSize = (nOfComp + 7) / 8;
            byte[] b = new byte[byteSize];
            Object[] selected = ((CheckBoxPanel)this._values[index]).getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                SnmpString.setBit(b, ((MibEnum)selected[i]).getValue() + 1);
            }
            return new SnmpString(b);
        }
        if (this._values[index] instanceof FieldPanel) {
            return this.getVarFromString(((FieldPanel)this._values[index]).getText(), index);
        }
        return null;
    }

    protected final JComponent getComponentAt(int index) {
        return this._values[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        try {
            Switch sw;
            String tcLabel = this._mibNodes[index].getTCLabel();
            if (this._mibNodes[index].getType() == 2) {
                if (this._mibNodes[index].getHi() != 0 && this._values[index] instanceof FieldPanel) {
                    return new SnmpInt(((FieldPanel)this._values[index]).getInt());
                }
                if (tcLabel == null || !tcLabel.equals("InterfaceIndex") && !tcLabel.equals("InterfaceIndexOrZero")) return new SnmpInt(Integer.parseInt(text));
                sw = this.getSelectedIfIndexIf();
                if (tcLabel.equals("InterfaceIndex")) {
                    return new SnmpInt(InterfaceIndex.parse(text, false, sw));
                }
                if (tcLabel.equals("InterfaceIndexOrZero")) {
                    return new SnmpInt(InterfaceIndex.parse(text, true, sw));
                }
            } else {
                if (this._mibNodes[index].getType() == 66) {
                    if (this._mibNodes[index].getHi() == 0 || !(this._values[index] instanceof FieldPanel)) return new SnmpUnsignedInt(FieldPanel.getLongNumber32(text));
                    return new SnmpUnsignedInt(((FieldPanel)this._values[index]).getLong32());
                }
                if (this._mibNodes[index].getType() == 64) {
                    return new SnmpIpAddress(text);
                }
            }
            if (tcLabel != null) {
                if (tcLabel.equals("IdList")) {
                    return new SnmpIdList(text);
                }
                if (tcLabel.equals("FcAddressId")) {
                    return new SnmpFcAddressId(text);
                }
                if (tcLabel.equals("FcNameId")) {
                    return new SnmpWWN(text, false);
                }
                if (tcLabel.equals("FcNameIdOrZero")) {
                    return new SnmpWWN(text, true);
                }
                if (tcLabel.equals("Bitmap")) {
                    return new SnmpBitmap(text);
                }
                if (tcLabel.equals("InetAddress")) {
                    return new SnmpInetAddress(text);
                }
                if (tcLabel.equals("PortMemberList")) {
                    sw = this.getSelectedIfIndexIf();
                    return new SnmpIntList(text, (IfIndexIf)sw);
                }
                if (tcLabel.equals("LongList")) {
                    return new SnmpLongList(text);
                }
                if (tcLabel.equals("DateAndTime")) {
                    return new SnmpDateAndTime(text);
                }
            }
            SnmpString s = new SnmpString(text);
            if (this._mibNodes[index].getMaxWidth() < s.getValue().length) {
                throw new NumberFormatException(" maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() <= s.getValue().length) return s;
            throw new NumberFormatException(" minimum length is " + this._mibNodes[index].getMinWidth());
        }
        catch (NumberFormatException ex) {
            return this.postComponentErrMsg(index, ex);
        }
    }

    public Switch getSelectedIfIndexIf() throws Exception {
        if (this._selPeerList == null) {
            this.getSelectedPeers();
        }
        if (this._multipleSwitches && this._selPeerList.length > 1) {
            throw new Exception("Please select only one switch at a time due to Interface related configuration.");
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)this._selPeerList[0]).getAddress());
        if (sw == null) {
            throw new Exception("Unable to find Switch from the model for " + (SnmpPeer)this._selPeerList[0]);
        }
        return sw;
    }

    protected SnmpVar postComponentErrMsg(int index, Exception ex) throws Exception {
        String var = this.getErrMsgFieldName(this._vars[index], index) + ": ";
        if (ex.getMessage().startsWith(var)) {
            var = "";
        } else if (ex.getMessage().startsWith("ownMsg:")) {
            var = "";
            String err = ex.getMessage();
            ex = new Exception(err.substring(7));
        }
        if (ex.getMessage() != null && ex.getMessage().length() > 0) {
            if (ex.getMessage().startsWith("For input string: \"\"")) {
                throw new Exception("cannot be blank");
            }
            throw new Exception(var + ex.getMessage());
        }
        throw new Exception(var + "expected integer");
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._mibNodes.length + 1));
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || this._mibNodes[i].isIndex() || values[i] == null || !this._values[i].isEnabled()) continue;
            pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), index), values[i]);
        }
        return pdu;
    }

    protected void insertAction() throws Exception {
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this.insert();
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.updateTableDisplay();
        if (this._insertErrMsg.size() == 0) {
            this.setStatus("Success.");
        } else {
            this.showInsertError();
        }
    }

    protected void showInsertError() throws Exception {
        if (this._insertErrMsg.size() != 0) {
            this.setStatus("Failed.");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._insertErrMsg.size(); ++i) {
                sb.append(this._insertErrMsg.elementAt(i));
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            throw new Exception(sb.toString());
        }
    }

    protected void updateTableDisplay() {
        BrowserFrame.getDataView().displayTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block8: {
            try {
                switch (((AbstractButton)e.getSource()).getText().charAt(1)) {
                    case 'r': {
                        this.insertAction();
                        return;
                    }
                    case 'l': {
                        this._parent.dispose();
                    }
                }
            }
            catch (Exception ex) {
                this._parent.setCursor(Cursor.getDefaultCursor());
                Util.errorMessage((Component)this._parent, ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Error ex) {
                this._parent.setCursor(Cursor.getDefaultCursor());
                Util.errorMessage((Component)this._parent, ex.getMessage());
                if (!SnmpSession.isTrace()) break block8;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected int getVarIndex(String var) {
        for (int i = 0; i < this._vars.length; ++i) {
            if (!this._vars[i].equals(var)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isVersionSupported(Switch sw) {
        boolean isVersionSupported = true;
        if (this._swVersionSupportedGreater != null || this._swVersionSupportedGreaterEqual != null) {
            isVersionSupported = this._swVersionSupportedGreater != null ? sw.isVersionGreaterThan(this._swVersionSupportedGreater) : sw.isVersionGreaterThanEqual(this._swVersionSupportedGreaterEqual);
        } else if (this._swVersionSupportedLessThan != null || this._swVersionSupportedLessThanEqual != null) {
            isVersionSupported = this._swVersionSupportedLessThan != null ? sw.isVersionLessThan(this._swVersionSupportedLessThan) : sw.isVersionLessThanEqual(this._swVersionSupportedLessThanEqual);
        }
        return isVersionSupported;
    }

    public void setSwVersionSupportedGreaterThan(String swVersionSupportedGreater) {
        this._swVersionSupportedGreater = swVersionSupportedGreater;
    }

    public void setSwVersionSupportedGreaterThanEqual(String swVersionSupportedGreaterEqual) {
        this._swVersionSupportedGreaterEqual = swVersionSupportedGreaterEqual;
    }

    public void setSwVersionSupportedLessThan(String swVersionSupportedLessThan) {
        this._swVersionSupportedLessThan = swVersionSupportedLessThan;
    }

    public void setSwVersionSupportedLessThanEqual(String swVersionSupportedLessThanEqual) {
        this._swVersionSupportedLessThanEqual = swVersionSupportedLessThanEqual;
    }

    class InsertValidateCallback
    implements SnmpCallbackIf {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
            if (!timedOut && pdu.getError() == 0) {
                Object[] index;
                SnmpVarBind vb = pdu.getVariables().getVb(0);
                int[] oid = vb.getOid().getValue();
                if (oid.length >= InsertForm.this._firstOid.length) {
                    index = new int[oid.length - InsertForm.this._firstOid.length];
                    System.arraycopy(oid, InsertForm.this._firstOid.length, index, 0, oid.length - InsertForm.this._firstOid.length);
                    if (InsertForm.this._insertRowCallback != null) {
                        SnmpPDU qPdu = InsertForm.this._table.buildGetPdu(node, InsertForm.this.getTableIndex((int[])index));
                        ++InsertForm.this._pending;
                        try {
                            node.send(qPdu, InsertForm.this._insertRowCallback);
                        }
                        catch (SnmpException ex) {
                            // empty catch block
                        }
                    }
                }
                --InsertForm.this._pending;
                if (InsertForm.this._pending <= 0) {
                    try {
                        index = InsertForm.this._peers;
                        synchronized (InsertForm.this._peers) {
                            InsertForm.this._peers.notifyAll();
                            // ** MonitorExit[index /* !! */ ] (shouldn't be in output)
                        }
                    }
                    catch (IllegalMonitorStateException ex) {
                        DefaultLogger._DefLogger.error((Object)ex);
                    }
                }
            } else {
                InsertForm.this.processInsertError(node, pdu, timedOut);
            }
            {
                return;
            }
        }
    }

    class InsertRowCallback
    implements SnmpCallbackIf {
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            InsertForm.this.insertRowCallback(pdu, timedOut);
        }
    }

    class SnmpErrorDetailRunnable
    implements Runnable {
        SnmpPDU _errorPdu;
        SnmpPeer _peer;

        SnmpErrorDetailRunnable(SnmpPeer peer, SnmpPDU pdu) {
            this._peer = peer;
            this._errorPdu = pdu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String strErr = SnmpReportException.getError(this._errorPdu);
            String strErrorDetail = this._peer.getSnmpErrorDetail(strErr, this._errorPdu);
            InsertForm.this._insertErrMsg.addElement(this._peer + ": " + strErrorDetail);
            --InsertForm.this._pending;
            if (InsertForm.this._pending <= 0) {
                try {
                    SnmpPeer[] snmpPeerArray = InsertForm.this._peers;
                    synchronized (InsertForm.this._peers) {
                        InsertForm.this._peers.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    DefaultLogger._DefLogger.error((Object)ex);
                }
            }
            {
                return;
            }
        }
    }
}

