/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.AddFabricDialog;
import com.cisco.dcbu.sm.client.gui.OpenThreadIf;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.util.StopWatch;
import java.net.InetAddress;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

class OpenLanThread
extends Thread
implements OpenThreadIf {
    AddFabricDialog _dialog = null;
    InetAddress _seedIp = null;
    SnmpUserOpt _snmpUserOpt = null;
    boolean _keepWaiting = true;
    LanPK _lanPK = null;
    String _error = null;
    private Logger _logger = Logger.getLogger(this.getClass());
    static Thread _instance = null;

    public OpenLanThread(InetAddress seedIp, SnmpUserOpt snmpUserOpt, boolean loadFromDb, AddFabricDialog dialog) {
        this._dialog = dialog;
        this._seedIp = seedIp;
        this._snmpUserOpt = snmpUserOpt;
        _instance = this;
    }

    @Override
    public InetAddress getSeedIP() {
        return this._seedIp;
    }

    @Override
    public boolean isTerminate() {
        return !this._keepWaiting;
    }

    @Override
    public void terminate() {
        this._dialog = null;
        this._keepWaiting = false;
    }

    private void open() {
        try {
            this._logger.debug((Object)"AddFabricDialog OpenEthernetThread open");
            SessionRif session = ClientController.getInstance().getServerSession();
            if (session != null) {
                FMServerRif fmserver = null;
                String targetServerIp = (String)((JComboBox)this._dialog._inputs[8]).getSelectedItem();
                fmserver = targetServerIp != null && ((JComboBox)this._dialog._inputs[8]).getItemCount() > 1 ? ClientController.getInstance().getRemoteFMServer(targetServerIp) : ClientController.getInstance().assertFMSConnection();
                StopWatch timer = null;
                if (this._logger.isDebugEnabled()) {
                    timer = new StopWatch();
                    timer.start();
                    this._logger.debug((Object)("DCNM-SAN start to discover LAN with seed:" + this._seedIp));
                }
                this._lanPK = fmserver.discoverLan(this._seedIp, this._snmpUserOpt, this._dialog.getMaxHops(), this._dialog.getIpRange(), this._dialog.getSubnet(), this._dialog.getMask(), session.getSSOToken());
                if (this._logger.isDebugEnabled()) {
                    if (timer != null) {
                        timer.stop();
                        this._logger.debug((Object)("DCNM-SAN return from discovering LAN with seed:" + this._seedIp + ", with LanPK=" + this._lanPK + ", used time(s):" + timer.getElapsedTimeInSeconds()));
                    } else {
                        this._logger.debug((Object)("DCNM-SAN return from discovering LAN with seed:" + this._seedIp + ", with LanPK=" + this._lanPK));
                    }
                }
            } else {
                this._error = "No server connection";
                this._keepWaiting = false;
            }
        }
        catch (Exception ex) {
            ClientController._Logger.error((Object)("Cannot open LAN for :" + this._seedIp), (Throwable)ex);
            this._keepWaiting = false;
            this._dialog._statusLabel.setText("");
            this._error = Util.getErrorMessage(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            this._error = null;
            try {
                this._lanPK = ClientController.getInstance().lookupLanPKBySeedIp(this._seedIp);
                this._logger.info((Object)("OpenLanThread find LanPK for cdp seed: " + this._seedIp + " and return with " + this._lanPK));
                if (this._lanPK != null) break block19;
                Thread t = new Thread("OpenLanThread"){

                    @Override
                    public void run() {
                        OpenLanThread.this.open();
                    }
                };
                t.start();
                long time = System.currentTimeMillis();
                String lanName = null;
                boolean isOpen = false;
                boolean isDiscovering = true;
                while (this._keepWaiting) {
                    try {
                        OpenLanThread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    try {
                        if (this._lanPK != null) {
                            ClientController _controller = ClientController.getInstance();
                            try {
                                lanName = _controller.getLanName(this._lanPK);
                                if (lanName != null) {
                                    lanName = lanName.trim();
                                }
                                isOpen = _controller.isLanManaged(this._lanPK);
                                isDiscovering = _controller.isLanDiscovering(this._lanPK);
                                if (this._logger.isDebugEnabled()) {
                                    this._logger.debug((Object)("DCNM-SAN check LAN status: lanName=" + lanName + ",isOpen=" + isOpen + ", isDiscovering=" + isDiscovering));
                                }
                            }
                            catch (Exception e) {
                                this._keepWaiting = true;
                            }
                            if (isOpen && lanName != null && lanName.length() > 0 && !isDiscovering) {
                                this._keepWaiting = false;
                            } else {
                                this._keepWaiting = true;
                                this._logger.info((Object)("OpenLanThread lanOpened=" + isOpen + " lanName=" + lanName));
                            }
                        }
                        if (this._lanPK != null && lanName != null && lanName.length() != 0 && isOpen && !isDiscovering || System.currentTimeMillis() - time <= 60000L) continue;
                        int retVal = JOptionPane.showConfirmDialog(this._dialog, "LAN is not discovered yet. Keep waiting?", "Keep waiting?", 0);
                        if (retVal == 0) {
                            time = System.currentTimeMillis();
                            continue;
                        }
                        this._keepWaiting = false;
                        this._dialog._statusLabel.setText("");
                    }
                    catch (Exception ex) {
                        this._logger.warn((Object)"OpenLanThread caught exception", (Throwable)ex);
                        this._keepWaiting = false;
                        this._dialog._statusLabel.setText("");
                        this._error = Util.getErrorMessage(ex);
                    }
                }
            }
            catch (Exception ex) {
                this._error = Util.getErrorMessage(ex);
            }
            finally {
                if (this._dialog != null) {
                    this._dialog.fabricOpened(this._seedIp, this._lanPK, this._snmpUserOpt, this._error);
                }
            }
        }
    }
}

