/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.tree.Tree;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.TreeCommand;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class PhysicalTree
extends Tree
implements TreeSelectionListener {
    TreePath _path;
    boolean bKeySelChanged;
    private Logger _logger = Logger.getLogger(this.getClass());

    public PhysicalTree(TreeNode tn) {
        super(tn);
        this.getSelectionModel().addTreeSelectionListener(this);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 501) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (this._path != null && path != null && path.equals(this._path) && !this.bKeySelChanged) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object o = treeNode.getUserObject();
                if (o instanceof TreeCommand) {
                    TreeCommand tc = (TreeCommand)o;
                    if (tc._method.charAt(0) == '-') {
                        this.clearSelection();
                        return;
                    }
                }
                this.selectTreePath(path);
            }
            this.bKeySelChanged = false;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] tpSel = this.getSelectionPaths();
        if (null != tpSel && tpSel.length > 1) {
            return;
        }
        if (tpSel != null) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)tpSel[0].getLastPathComponent();
            Object o = treeNode.getUserObject();
            if (o instanceof TreeCommand) {
                TreeCommand tc = (TreeCommand)o;
                if (tc._method.charAt(0) == '-') {
                    this.clearSelection();
                    return;
                }
            }
            this.bKeySelChanged = true;
            this.selectTreePath(tpSel[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTreePath(TreePath path) {
        this._path = path;
        if (path == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DataView dataView = BrowserFrame.getDataView();
            dataView.cleanup();
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = treeNode.getUserObject();
            if (o instanceof TreeCommand) {
                TreeCommand tc = (TreeCommand)o;
                if (tc._method.charAt(0) == '-') {
                    dataView.showTitle(BrowserFrame.getPathName(path), tc._method);
                } else {
                    dataView.resetPhysicalTreeChange();
                    SmCommandDispatcher.invoke(tc._method, dataView, null, BrowserFrame.getPathName(path), true);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public TreePath getTreePath() {
        return this._path;
    }

    public void setContext(ClientContext context) {
        if (context == null) {
            return;
        }
        String nodeName = context.getPhysicalAttributeSelection();
        this._logger.debug((Object)("PhysicalTree.setContext context.getPhysicalAttributeSelection()=" + context.getPhysicalAttributeSelection()));
        if (nodeName == null) {
            return;
        }
        TreeSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        TreePath treePath = this.getNextEqualsMatch(nodeName, null);
        if (treePath == null) {
            return;
        }
        this.scrollPathToVisible(treePath);
        this.getSelectionModel().setSelectionPath(treePath);
    }
}

