/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.renderers;

import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class InterfaceFiconRenderer
extends BorderCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int ficonAddr;
        FcPortBase port;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return null;
        }
        if (!(value instanceof InterfaceIndex)) {
            return label;
        }
        int index = ((InterfaceIndex)value).getValue();
        SnmpPeer node = (SnmpPeer)table.getValueAt(row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        StringBuffer sb = new StringBuffer();
        sb.append(sw.ifIndexToName(index));
        if (sw.hasFiconVsan() && (port = sw.findFCPort(index)) != null && (ficonAddr = port.getFiconAddress()) != -1) {
            sb.append(" (");
            sb.append(SnmpFiconPort.toString(ficonAddr));
            sb.append(')');
        }
        label.setText(sb.toString());
        return label;
    }
}

