/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.renderers;

import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;

public class SwitchWWNRenderer
extends IndexCellRenderer {
    private boolean _appendWwn;

    public SwitchWWNRenderer(boolean appendWwn) {
        this._appendWwn = appendWwn;
    }

    @Override
    public String getLabel(int[] index) {
        if (index == null || index.length < 8 || index.length > 9) {
            return "n/a";
        }
        byte[] newIndex = new byte[8];
        for (int i = 0; i < 8; ++i) {
            newIndex[i] = (byte)(index[i] & 0xFF);
        }
        Fabric[] f = San.getInstance().getFabrics();
        StringBuffer data = new StringBuffer();
        if (index.length == 9) {
            data.append(Integer.toString(index[8]));
            data.append(", ");
        }
        data.append(SnmpString.toHexString(newIndex));
        for (int i = 0; i < f.length; ++i) {
            Switch sw = f[i].findSwitchByWwn(new Wwn(newIndex));
            if (sw == null) continue;
            if (this._appendWwn) {
                data.append(", ").append(sw);
                continue;
            }
            return sw.toString();
        }
        return data.toString();
    }
}

