/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.mds.CliCommandHandler;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LunDiscovery
extends JDialog
implements ActionListener {
    JComboBox _vsanList;
    JList _server;
    JScrollPane _serverSp;
    JList _storage;
    JScrollPane _storageSp;
    JCheckBox _chkDetail;
    Card _selectedCard;
    JLabel _cardLabel;
    JResultTextArea _result;
    JButton[] _buttons;
    JLabel _status;
    CliCommandHandler _smlCmd;
    StringBuffer _commonCli;
    StringBuffer _showLunMap;
    int _pollCount;
    protected Timer _pollTimer;
    static final String PORT_LIST_NAME = "Ports: (Name, Switch Interface)";
    static final String[] _BtnLabels = new String[]{"Discover", "Show", "Cancel", "Close"};
    static final int DISCOVER_BTN = 0;
    static final int SHOW_BTN = 1;
    static final int CANCEL_BTN = 2;
    static final int CLOSE_BTN = 3;
    static final int POLL_INTERVAL = 1500;
    static final int MAX_NUM_OF_POLL = 14;

    public LunDiscovery(JFrame parent) throws Exception {
        super((Frame)parent, "LUN Discovery Tool " + ClientController.getInstance().getDialogFabricTitlePostfix());
        JLabel vsanLabel = new JLabel("VSAN:");
        ArrayList<Vsan> vsanList = ClientController.getInstance().getLunDiscoverCapableVsanList();
        this._vsanList = new JComboBox<Vsan>(vsanList.toArray(new Vsan[vsanList.size()]));
        this._vsanList.addActionListener(this);
        this._vsanList.setActionCommand("VSAN");
        JPanel vsanPanel = new JPanel(new FlowLayout(0, 2, 0));
        vsanPanel.add(vsanLabel);
        vsanPanel.add(this._vsanList);
        Object[] hosts = ((Vsan)this._vsanList.getSelectedItem()).getEndPorts(false);
        JComponent[] serverGrp = new JComponent[2];
        serverGrp[0] = new JLabel("Host Ports: (Name, Switch Interface)");
        Arrays.sort(hosts);
        this._server = new JList<Object>(hosts);
        this._server.setSelectedIndex(0);
        this._server.setSelectionMode(0);
        this._server.setCellRenderer(new EndPortCellRenderer());
        this._serverSp = new JScrollPane(this._server);
        this._serverSp.setPreferredSize(new Dimension(400, 100));
        serverGrp[1] = this._serverSp;
        JPanel hostPanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), serverGrp);
        Object[] storages = ((Vsan)this._vsanList.getSelectedItem()).getEndPorts(true);
        JComponent[] stgGrp = new JComponent[2];
        stgGrp[0] = new JLabel("Storage Ports: (Name, Switch Interface)");
        Arrays.sort(storages);
        this._storage = new JList<Object>(storages);
        this._storage.setSelectedIndex(0);
        this._storage.setSelectionMode(0);
        this._storage.setCellRenderer(new EndPortCellRenderer());
        this._storageSp = new JScrollPane(this._storage);
        this._storageSp.setPreferredSize(new Dimension(400, 100));
        stgGrp[1] = this._storageSp;
        JPanel storagePanel = DialogUtil.buildTablePanel(DialogUtil.buildLabels(new String[]{null, null}), stgGrp);
        JPanel endPortGrpPanel = new JPanel();
        endPortGrpPanel.setLayout(new GridLayout());
        endPortGrpPanel.add(hostPanel);
        endPortGrpPanel.add(storagePanel);
        JPanel cardPanel = new JPanel(new FlowLayout(0));
        this._cardLabel = new JLabel("");
        cardPanel.add(this._cardLabel);
        Box topPanel = new Box(1);
        topPanel.add(vsanPanel);
        topPanel.add(endPortGrpPanel);
        topPanel.add(cardPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(new DialogSeparator("LUN Map"));
        JPanel chkPanel = new JPanel(new FlowLayout(0));
        this._chkDetail = new JCheckBox("Detail");
        this._chkDetail.setAlignmentX(0.0f);
        chkPanel.add(this._chkDetail);
        bottomPanel.add((Component)chkPanel, "North");
        this._result = new JResultTextArea();
        this._result.setEditable(false);
        JScrollPane sp = new JScrollPane(this._result);
        sp.setPreferredSize(new Dimension(400, 200));
        bottomPanel.add((Component)sp, "Center");
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", topPanel);
        p.add("Center", bottomPanel);
        this._status = new JLabel(" ");
        this._buttons = DialogUtil.buildButtons(_BtnLabels, (ActionListener)this);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, DialogUtil.buildStatusPanel(this._buttons, this._status));
        this.setResizable(true);
        this._pollTimer = new Timer(1500, this);
        this.defaultButtonState();
        this._buttons[1].setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._pollTimer) {
                String lunMap = this.queryLunMap();
                if (lunMap.length() != 0) {
                    this._pollTimer.stop();
                    this._buttons[0].setEnabled(true);
                    this._buttons[2].setEnabled(false);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                ++this._pollCount;
                if (this._pollCount >= 14) {
                    throw new Exception("Error querying LUN Map, timeout!");
                }
                return;
            }
            String cmd = e.getActionCommand();
            if (e.getActionCommand().equals("VSAN")) {
                this.updateEndPortListOnVsanChange();
                return;
            }
            String btnLabel = ((JButton)e.getSource()).getText();
            switch (((JButton)e.getSource()).getActionCommand().charAt(0)) {
                case 'D': {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this._buttons[0].setEnabled(false);
                    this._buttons[2].setEnabled(true);
                    this.discoverLun();
                    return;
                }
                case 'S': {
                    this.queryLunMap();
                    break;
                }
                case 'C': {
                    if (btnLabel.equals("Cancel")) {
                        this.cancelOp();
                        return;
                    }
                    this.dispose();
                }
            }
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this._pollTimer != null) {
                this._pollTimer.stop();
            }
            this.defaultButtonState();
            this.setStatus("");
            Util.errorMessage((Component)this, ex);
        }
    }

    void updateEndPortListOnVsanChange() {
        Vsan selectedVsan = (Vsan)this._vsanList.getSelectedItem();
        Object[] hosts = selectedVsan.getEndPorts(false);
        Arrays.sort(hosts);
        this._server.setListData(hosts);
        this._server.setSelectedIndex(0);
        Object[] storages = selectedVsan.getEndPorts(true);
        Arrays.sort(storages);
        this._storage.setListData(storages);
        this._storage.setSelectedIndex(0);
    }

    void defaultButtonState() {
        this._buttons[0].setEnabled(true);
        this._buttons[2].setEnabled(false);
    }

    void discoverLun() throws Exception {
        Vsan selectedVsan = (Vsan)this._vsanList.getSelectedItem();
        Switch ssmSw = ClientController.getInstance().getLunDiscoveryMasterSwitchFromVsan(selectedVsan);
        if (ssmSw == null) {
            throw new Exception("Cannot find any switch in the selected VSAN which contains a valid SSM card!");
        }
        this._selectedCard = ClientController.getInstance().getDMMenabledCardSlotId(ssmSw);
        if (this._selectedCard == null) {
            throw new Exception("Cannot find any DMM enabled card in the Switch " + ssmSw);
        }
        int slotId = this._selectedCard.getSlotId();
        this._cardLabel.setText("Selected Switch : " + ssmSw + " Module : " + this._selectedCard.getSlotId() + " (" + this._selectedCard.getName() + ")");
        if (this._smlCmd == null) {
            this._smlCmd = new CliCommandHandler(BrowserFrame.getInstance(), ssmSw.getPeer(), true);
        } else {
            this._smlCmd.reconnect(true);
        }
        this._commonCli = new StringBuffer();
        this._commonCli.append("sld module " + slotId + " ");
        this._commonCli.append("vsan " + selectedVsan.getId() + " ");
        EndPort serverEndPort = (EndPort)this._server.getSelectedValue();
        String hexServerString = SnmpString.toHexString(serverEndPort.getPortWwn().getValue());
        this._commonCli.append("server-pwwn " + hexServerString + " ");
        EndPort storageEndPort = (EndPort)this._storage.getSelectedValue();
        String hexStorageString = SnmpString.toHexString(storageEndPort.getPortWwn().getValue());
        this._commonCli.append("target-pwwn " + hexStorageString + " ");
        StringBuffer discoverCli = new StringBuffer();
        discoverCli.append(this._commonCli.toString());
        discoverCli.append("discover");
        String status = this._smlCmd.executeCLICommandPromptError(discoverCli.toString(), (String)null, false);
        if (status.indexOf("Failed") != -1) {
            throw new Exception(status);
        }
        this.setStatus(status);
        this.setStatus("querying LUN Map...");
        this._pollCount = 0;
        this._pollTimer.start();
    }

    String queryLunMap() throws Exception {
        this._showLunMap = new StringBuffer();
        this._showLunMap.append("show ");
        this._showLunMap.append(this._commonCli.toString());
        this._showLunMap.append(this._chkDetail.isSelected() ? "detail fm" : "fm");
        String lunMap = this._smlCmd.executeCLICommandPromptError(this._showLunMap.toString(), (String)null, false);
        if (lunMap.length() != 0) {
            this.setStatus("");
            this._result.setText(lunMap);
        }
        return lunMap;
    }

    void cancelOp() {
        this.defaultButtonState();
        if (this._pollTimer != null) {
            this._pollTimer.stop();
        }
    }

    @Override
    public void dispose() {
        this.cancelOp();
        if (this._smlCmd != null) {
            this._smlCmd.closeVsh();
            this._smlCmd.cleanup();
        }
        super.dispose();
    }

    void setStatus(String text) {
        this._status.setText(text);
    }

    class EndPortCellRenderer
    extends DefaultListCellRenderer {
        EndPortCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            StringBuffer buf = new StringBuffer();
            EndPort ep = (EndPort)value;
            buf.append(ep);
            buf.append(", ");
            Switch sw = ep.getSwitch();
            buf.append(sw);
            buf.append(" ");
            buf.append(sw.ifIndexToName(ep.getIfIndex()));
            this.setText(buf.toString());
            return retValue;
        }
    }

    class JResultTextArea
    extends JTextArea
    implements ActionListener {
        protected JPopupMenu _menu;

        public JResultTextArea() {
            this.addMouseListener(new MouseAdapter(){

                void checkPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (JResultTextArea.this._menu == null) {
                            JResultTextArea.this._menu = JResultTextArea.this.buildMenu();
                        }
                        JResultTextArea.this._menu.show(JResultTextArea.this, e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.checkPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.checkPopup(e);
                }
            });
        }

        protected JPopupMenu buildMenu() {
            JPopupMenu menu = new JPopupMenu();
            String[] labels = new String[]{"Clear"};
            for (int i = 0; i < labels.length; ++i) {
                JMenuItem mi = new JMenuItem(labels[i]);
                menu.add(mi);
                mi.addActionListener(this);
            }
            return menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((AbstractButton)e.getSource()).getText();
            switch (cmd.charAt(0)) {
                case 'C': {
                    if (cmd.charAt(1) != 'l') break;
                    this.setText(" ");
                    this.setText(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            System.gc();
                        }
                    });
                }
            }
        }
    }
}

