/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.VisioExportAdapter;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ShowTechSupport
extends JDialog
implements ActionListener,
ItemListener {
    static final String DESCR = "The 'show tech-support (tac-pac)' command is run on the selected switches and the output up to the CLI command prompt is saved to the specified folder as <SWITCH NAME>.zip. The map is saved as the <FABRIC NAME>.jpg/.vdx. This may take some time. Wait till the status for all switches shows 'Success' or 'Error'. For a fully loaded switch it can take upto 30 mins to complete operation.";
    static final String DEFAULT_ZIP_FILE_NAME = "ShowTechSupport.zip";
    public static final String COMMAND_OUTPUT_FETCHED = "Finished fetching data...";
    static final int POLL_INTERVAL = 2;
    ShowTechTable _table;
    SnmpTableModel _model;
    JScrollPane _sp;
    JComponent[] _values;
    JButton[] _buttons;
    JCheckBox _zipCb;
    JCheckBox _jpegSaveMap;
    JCheckBox _visioSaveMap;
    FieldPanel _zipFp;
    FieldPanel _fileFp;
    CliThread[] _threads;
    JLabel _status;
    int _count;
    int _totalTime;
    Array _data;
    String _dirPrefix;
    String _zipFile;
    String[] _mapFile;
    RadioButtonPanel _protocol;
    KTextField _serverIP;
    KTextField _userName;
    JPasswordField _password;
    KTextField _rootDir;
    JLabel[] _cLabels;
    boolean _zipped = false;
    public static final int VRRF_COLUMN = 2;
    public static final int SERVER_LABEL_ID = 6;
    static final String SERVER_LABEL_LOCAL = "Local Server Address:";
    static final String SERVER_LABEL_SFTP = "SFTP Server Address:";
    static final String[] labels = new String[]{"TCP Timeout:", "Folder:", "Save Map In File:", "", "Command:", "Use:", "Local Server Address:", "SFTP UserName:", "SFTP UserPassword: ", "Root Directory:"};
    protected Timer _timer;

    public ShowTechSupport(JFrame parent) {
        this(parent, "Show Tech Support");
    }

    public ShowTechSupport(JFrame parent, String title) {
        super((Frame)parent, title + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.buildUI(parent);
    }

    protected String getDescription() {
        return DESCR;
    }

    protected void buildUI(JFrame parent) {
        Box box = new Box(1);
        JTextArea ta = new JTextArea(this.getDescription());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setOpaque(false);
        ta.setFont((Font)UIManager.getDefaults().get("Table.font"));
        box.add(ta);
        String[] cols = new String[]{"Select", "Switch", "Management Interface", "Model", "Status"};
        boolean[] attrs = new boolean[]{true, false, true, false, false};
        this._data = new Array();
        this._model = new SnmpTableModel();
        this._model.setData(this._data);
        this._model.setHeaders(cols);
        this._model.setEditable(attrs);
        this._table = new ShowTechTable(this._model);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._table.setRowSelectionAllowed(true);
        TableColumn vrrfColumn = this._table.getColumnModel().getColumn(2);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("default");
        comboBox.addItem("vrf management");
        comboBox.addItem("vrf default");
        vrrfColumn.setCellEditor(new DefaultCellEditor(comboBox));
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        cm.getColumn(0).setMaxWidth(60);
        cm.getColumn(1).setMaxWidth(400);
        cm.getColumn(2).setMaxWidth(150);
        cm.getColumn(4).setCellRenderer(new ProgressRenderer());
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(new Dimension(550, 150));
        JPanel panel = new JPanel(new BorderLayout(0, 8));
        panel.add("North", box);
        panel.add("Center", this._sp);
        JPanel argPanel = this.buildCommandsPanel();
        panel.add("South", argPanel);
        JPanel southPanel = new JPanel(new BorderLayout());
        String[] btns = new String[]{"Run", "Close"};
        this._buttons = DialogUtil.buildButtons(btns, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        southPanel.add("North", buttonPanel);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        southPanel.add("South", this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)panel, southPanel);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
    }

    protected void setSftpControls() {
        boolean isSftpSel = this._protocol.getSelected() == 1;
        this._userName.setVisible(isSftpSel);
        this._rootDir.setVisible(isSftpSel);
        this._password.setVisible(isSftpSel);
        this._cLabels[9].setVisible(isSftpSel);
        this._cLabels[6].setText(isSftpSel ? SERVER_LABEL_SFTP : SERVER_LABEL_LOCAL);
        this._cLabels[7].setVisible(isSftpSel);
        this._cLabels[8].setVisible(isSftpSel);
        this.pack();
    }

    protected JPanel buildCommandsPanel() {
        this._values = new JComponent[labels.length];
        this._cLabels = DialogUtil.buildLabels(labels);
        this._protocol = new RadioButtonPanel(new String[]{"Local DCNM-SAN TFTP", "SFTP"}, 3);
        this._protocol.getButton(0).addActionListener(this);
        this._protocol.getButton(1).addActionListener(this);
        this._serverIP = new KTextField(30);
        this._serverIP.setText(NetUtil.getLocalIPAddresses()[0]);
        this._userName = new KTextField(30);
        this._rootDir = new KTextField(30);
        this._rootDir.setText("/");
        this._password = new JPasswordField(30);
        this.setSftpControls();
        String userHome = System.getProperty("user.home", "");
        KTextField tf = new KTextField(userHome, 50);
        JButton btn = new JButton("...");
        btn.addActionListener(this);
        btn.setMargin(DialogUtil.getInsets());
        this._values[0] = new FieldPanel(3, 30, 1, 60, "min");
        this._fileFp = new FieldPanel(tf, (JComponent)btn);
        this._values[1] = this._fileFp;
        JPanel saveMap = new JPanel(new FlowLayout(0, 0, 0));
        this._visioSaveMap = new JCheckBox("Visio", true);
        saveMap.add(this._visioSaveMap);
        this._jpegSaveMap = new JCheckBox("JPEG", true);
        saveMap.add(this._jpegSaveMap);
        this._values[2] = saveMap;
        Box box = new Box(0);
        this._zipCb = new JCheckBox("Compress all files as", true);
        this._zipCb.addItemListener(this);
        box.add(this._zipCb);
        btn = new JButton("...");
        btn.addActionListener(this);
        btn.setMargin(DialogUtil.getInsets());
        tf = new KTextField(userHome + File.separator + this.getDefaultZipFileName(), 25);
        this._zipFp = new FieldPanel(tf, (JComponent)btn);
        box.add(this._zipFp);
        this._values[3] = box;
        this._values[4] = new JTextField("show tech-support details");
        this._values[4].setVisible(false);
        this._cLabels[4].setVisible(false);
        this._values[5] = this._protocol;
        this._values[6] = this._serverIP;
        this._values[7] = this._userName;
        this._values[8] = this._password;
        this._values[9] = this._rootDir;
        return DialogUtil.buildPanel(this._cLabels, this._values);
    }

    protected String getDefaultZipFileName() {
        return DEFAULT_ZIP_FILE_NAME;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            try {
                this.resetData();
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                return;
            }
        }
        super.setVisible(b);
    }

    void resetData() throws Exception {
        SnmpPeer[] peers;
        this._data.clear();
        this._model.fireTableDataChanged();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        SnmpPeer[] snmpPeerArray = peers = mgmtDomain == null ? San.getInstance().getSnmpPeers(true) : mgmtDomain.getSnmpPeers(true);
        if (peers == null || peers.length < 1) {
            throw new Exception("No SAN switchs are available");
        }
        for (int i = 0; i < peers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
            if (!this.includeSwitch(sw)) continue;
            Object[] row = new Object[]{Boolean.TRUE, sw, "default", sw.getModel(), "", null};
            this._data.addElement(row);
        }
        this._sp.setPreferredSize(this._table.calcPreferredSize());
    }

    protected boolean includeSwitch(Switch sw) {
        return !sw.isUCS() && sw.isManageable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            this.timerEvent();
            return;
        }
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'R': {
                if (this.getCommandText().trim().length() == 0) {
                    Util.errorMessage((Component)this, "Please type valid CLI command(s)");
                    return;
                }
                try {
                    int timeout = this.getTimeOut();
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, "Invalid TCP timeout value. " + ex.getMessage());
                    return;
                }
                this.start();
                break;
            }
            case 'C': {
                this.stop();
                this._buttons[0].setText("Ok");
                this.setVisible(false);
                break;
            }
            case 'L': 
            case 'S': {
                this.setSftpControls();
                break;
            }
            case '.': {
                if (((JComponent)e.getSource()).getParent() == this._fileFp) {
                    String dir = this.getDirectory();
                    if (dir == null) break;
                    this._fileFp.setText(dir);
                    break;
                }
                String file = this.getFile();
                if (file == null) break;
                this.setFileName(file);
            }
        }
    }

    protected void setFileName(String fileName) {
        this._zipFp.setText(fileName);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this._zipFp.setEnabled(this._zipCb.isSelected());
    }

    void timerEvent() {
        this._totalTime += 2;
        for (int i = 0; i < this._threads.length; ++i) {
            String status;
            Object[] row;
            if (this._threads[i] != null && (row = this.findRow(this._threads[i]._peer)) != null && (status = (String)row[this.getColumnOffset() + 3]).indexOf("Error") == -1 && status.indexOf("Success") == -1) {
                row[this.getColumnOffset() + 3] = this._threads[i].getStatus();
            }
            this._model.fireTableDataChanged();
            if (!this.isVisible()) continue;
            this._sp.setPreferredSize(this._table.calcPreferredSize());
        }
        this._status.setText(this._totalTime + " seconds");
    }

    protected int getColumnOffset() {
        return 1;
    }

    void start() {
        int i;
        this._zipped = false;
        for (int i2 = 0; i2 < this._data.size(); ++i2) {
            Object[] row = (Object[])this._data.elementAt(i2);
            row[this.getColumnOffset() + 3] = "";
        }
        this._model.fireTableDataChanged();
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        int num = 0;
        Switch[] tmp = new Switch[this._data.size()];
        String[] appendStr = new String[this._data.size()];
        for (int i3 = 0; i3 < this._table.getRowCount(); ++i3) {
            if (!((Boolean)this._table.getValueAt(i3, 0)).booleanValue()) continue;
            tmp[num] = (Switch)this._table.getValueAt(i3, 1);
            appendStr[num] = (String)this._table.getValueAt(i3, 2);
            ++num;
        }
        if (num < 1) {
            Util.errorMessage((Component)this, "Please select at least one switch.");
            return;
        }
        Switch[] sws = new Switch[num];
        System.arraycopy(tmp, 0, sws, 0, num);
        this._threads = new CliThread[sws.length];
        if (this._fileFp != null) {
            this._dirPrefix = this._fileFp.getText() + File.separator;
        }
        this._status.setText("Firing " + sws.length + " requests.");
        this._count = sws.length;
        int saveMap = (this._jpegSaveMap != null && this._jpegSaveMap.isSelected() ? 1 : 0) + (this._visioSaveMap != null && this._visioSaveMap.isSelected() ? 1 : 0);
        if (saveMap > 0) {
            MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
            Fabric[] fs = null;
            if (mgmtDomain.isSan()) {
                fs = ((San)mgmtDomain).getFabrics();
            } else if (mgmtDomain.getFabric() != null) {
                fs = new Fabric[]{mgmtDomain.getFabric()};
            }
            if (fs == null) {
                fs = new Fabric[]{ClientController.getInstance().getFabric()};
            }
            if (fs == null) {
                fs = San.getInstance().getFabrics();
            }
            this._mapFile = new String[fs.length * saveMap];
            saveMap = 0;
            for (i = 0; i < fs.length; ++i) {
                File f;
                MiscMapActions ma;
                String name = null;
                name = fs[i].getName();
                if (name == null || name.length() == 0) {
                    name = fs[i].getName();
                }
                if (this._jpegSaveMap.isSelected()) {
                    this._mapFile[saveMap] = this._dirPrefix + name + ".jpg";
                    ma = MiscMapActions.getInstance();
                    try {
                        f = new File(this._mapFile[saveMap++]);
                        ma.save(fs[i], f);
                    }
                    catch (Exception ex) {
                        Util.errorMessage((Component)this, "Failed to save map(jpg)");
                        DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                if (!this._visioSaveMap.isSelected()) continue;
                this._mapFile[saveMap] = this._dirPrefix + name + ".vdx";
                ma = MiscMapActions.getInstance();
                try {
                    f = new File(this._mapFile[saveMap++]);
                    SmMap map = MapFactory.getInstance().getMap(fs[i]);
                    new VisioExportAdapter(f, (TopologyGraph)map, true).exportToVisio();
                    continue;
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, "Failed to save map(visio)");
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            this._mapFile = null;
        }
        if (this._zipCb != null) {
            this._zipFile = this._zipCb.isSelected() ? this._zipFp.getText() : null;
        }
        try {
            int timeout = this.getTimeOut();
            BrowserFrame parent = BrowserFrame.getInstance();
            for (i = 0; i < sws.length; ++i) {
                Switch sw = sws[i];
                SnmpPeer peer = sw.getPeer();
                String fname = peer.toString();
                String abfname = (this._dirPrefix != null ? this._dirPrefix : "") + fname;
                this._threads[i] = this.buildCliThreads(peer, fname, parent, timeout, abfname);
                this._threads[i]._appendString = appendStr[i];
                this._threads[i].start();
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex.getMessage());
            DefaultLogger._DefLogger.error((Object)ex.getMessage());
            return;
        }
        this._timer = new Timer(2000, this);
        this._timer.start();
        this._totalTime = 0;
        this._buttons[0].setEnabled(false);
    }

    protected int getTimeOut() {
        return ((FieldPanel)this._values[0]).getInt() * 60 * 1000;
    }

    protected CliThread buildCliThreads(SnmpPeer peer, String fname, JFrame parent, int timeout, String abfname) {
        String fileExt = ".gz";
        return new CliThread(peer, fname + fileExt, parent, timeout, abfname + fileExt, true);
    }

    void stop() {
        try {
            this._count = 0;
            this._buttons[0].setEnabled(true);
            if (this._timer != null) {
                this._timer.stop();
            }
            if (this._threads != null) {
                for (int i = 0; i < this._threads.length; ++i) {
                    if (this._threads[i] == null || this._threads[i]._vsh == null) continue;
                    this._threads[i]._vsh.disconnect();
                }
                this._threads = null;
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)("Show Tech Stop() error " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(SnmpPeer peer, boolean success) {
        ShowTechSupport showTechSupport = this;
        synchronized (showTechSupport) {
            --this._count;
        }
        Object[] row = this.findRow(peer);
        if (row != null && success) {
            row[this.getColumnOffset() + 3] = COMMAND_OUTPUT_FETCHED;
            this._model.fireTableDataChanged();
            this._sp.setPreferredSize(this._table.calcPreferredSize());
        }
        if (this._count == 0 && !this._zipped) {
            if (this._zipFile != null) {
                try {
                    DefaultLogger._DefLogger.info((Object)"Zip called ************************");
                    this.zip();
                    this._status.setText("Done " + this._totalTime + " seconds");
                    this._zipped = true;
                }
                catch (Exception ex) {
                    DefaultLogger._DefLogger.error((Object)ex.getMessage());
                    this._status.setText("Error: " + ex.getMessage());
                }
            }
            for (int i = 0; i < this._data.size(); ++i) {
                if (!((Boolean)this._table.getValueAt(i, 0)).booleanValue() || (row = (Object[])this._data.elementAt(i)) == null || row[this.getColumnOffset() + 3] == null || row[this.getColumnOffset() + 3].toString().indexOf("Error") != -1) continue;
                row[this.getColumnOffset() + 3] = this._zipFile == null ? "Success" : (this._zipped ? "Success " : "Error:Failed to zip file");
                this._model.fireTableDataChanged();
            }
            this.stop();
        }
    }

    void zip() throws Exception {
        ZipOutputStream zOut = null;
        try {
            int i;
            zOut = new ZipOutputStream(new FileOutputStream(this._zipFile));
            zOut.setMethod(8);
            if (this._mapFile != null) {
                for (i = 0; i < this._mapFile.length; ++i) {
                    this.zip(zOut, this._mapFile[i]);
                }
            }
            for (i = 0; i < this._threads.length; ++i) {
                this.zip(zOut, this._threads[i]._absoluteFlName);
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)("Zip error " + ex.getMessage()));
            throw ex;
        }
        finally {
            if (zOut != null) {
                try {
                    zOut.close();
                }
                catch (IOException ex2) {}
            }
        }
        if (this._mapFile != null) {
            for (int i = 0; i < this._mapFile.length; ++i) {
                new File(this._mapFile[i]).delete();
            }
        }
        for (int i = 0; i < this._threads.length; ++i) {
            File fd = new File(this._threads[i]._absoluteFlName);
            if (!fd.delete()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                fd.delete();
            }
            Object var3_8 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zip(ZipOutputStream zOut, String fname) throws IOException {
        File f = new File(fname);
        if (!f.canRead()) {
            DefaultLogger._DefLogger.error((Object)("File " + fname + " not readable or file location is incorrect."));
            return;
        }
        FileInputStream fin = new FileInputStream(f);
        try {
            int count;
            long lastModified = f.lastModified() + 1999L;
            ZipEntry ze = new ZipEntry(f.getName());
            ze.setTime(lastModified);
            zOut.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            while ((count = fin.read(buffer, 0, buffer.length)) != -1) {
                zOut.write(buffer, 0, count);
            }
        }
        finally {
            fin.close();
            f = null;
        }
    }

    Object[] findRow(SnmpPeer peer) {
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            Switch sw = (Switch)row[1];
            if (sw.getPeer() != peer) continue;
            return row;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    void error(SnmpPeer peer, Exception ex) {
        Object[] row = this.findRow(peer);
        if (row != null) {
            row[this.getColumnOffset() + 3] = "Error: " + (ex.getMessage() != null && ex.getMessage().trim().length() > 0 ? ex.getMessage() : "Timeout or Prompt Change in command");
        }
        this._model.fireTableDataChanged();
        if (this.isVisible()) {
            this._sp.setPreferredSize(this._table.calcPreferredSize());
        }
        DefaultLogger._DefLogger.error((Object)(peer + ":" + ex.getMessage()), (Throwable)ex);
        this.done(peer, false);
    }

    String getCommandText() {
        return ((JTextField)this._values[4]).getText();
    }

    String getDirectory() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    String getFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        if (fc.showOpenDialog(this) == 0) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    class ProgressRenderer
    extends BorderCellRenderer {
        ProgressRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String status = value.toString();
                if (status.indexOf("Received") != -1) {
                    this.setBackground(Color.yellow);
                } else if (status.indexOf("Success") != -1) {
                    this.setBackground(new Color(128, 255, 128));
                } else if (status.indexOf("Error") != -1) {
                    this.setBackground(Color.pink);
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ShowTechTable
    extends SnmpKTable {
        public ShowTechTable(KTableModel model) {
            super(model);
        }

        @Override
        protected void buildPopupMenu() {
            super.buildPopupMenu();
            this._popup.add(Util.createMenuItem("Select All", "All", this));
            this._popup.add(Util.createMenuItem("Select None", "None", this));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand().charAt(0)) {
                case 'A': {
                    if (ShowTechSupport.this._model == null) break;
                    for (int i = 0; i < ShowTechSupport.this._model.getRowCount(); ++i) {
                        ShowTechSupport.this._model.setValueAt(Boolean.TRUE, i, 0);
                    }
                    break;
                }
                case 'N': {
                    if (ShowTechSupport.this._model == null) break;
                    for (int i = 0; i < ShowTechSupport.this._model.getRowCount(); ++i) {
                        ShowTechSupport.this._model.setValueAt(Boolean.FALSE, i, 0);
                    }
                    break;
                }
                default: {
                    super.actionPerformed(e);
                }
            }
        }
    }

    class CliThread
    extends Thread {
        VshBase _vsh;
        JFrame _parent;
        String _fname;
        SnmpPeer _peer;
        OutputStream _out;
        int _timeout;
        int _oldTimeout;
        String _absoluteFlName;
        boolean _isZipped;
        String _state = "Initializing...";
        String _appendString = "";

        CliThread(SnmpPeer peer, String fname, JFrame parent, int timeout) {
            this._peer = peer;
            this._fname = fname;
            this._parent = parent;
            this._timeout = timeout;
        }

        CliThread(SnmpPeer peer, String fname, JFrame parent, int timeout, String abFlName, boolean isZipped) {
            this._peer = peer;
            this._fname = fname;
            this._parent = parent;
            this._timeout = timeout;
            this._absoluteFlName = abFlName;
            this._isZipped = isZipped;
        }

        String getStatus() {
            if (this._vsh != null) {
                return "Received " + this._vsh.getRx() + " bytes" + (this._isZipped ? " (waiting for tac-pac to finish)" : "");
            }
            return this._state;
        }

        @Override
        public void run() {
            if (this._isZipped) {
                this.runAsTacPac();
            } else {
                this.runAsStreamRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runAsStreamRead() {
            RandomAccessFile raf = null;
            try {
                boolean useSsh = ExternalTools.isUseSSH();
                this._out = new FileOutputStream(this._absoluteFlName);
                this._vsh = Vsh.getNew(this._parent, this._peer.getAddress().getHostAddress(), this._peer.getUserName(), this._peer.getAuthPassword(), ExternalTools._UseSSH, null);
                if (this._vsh != null) {
                    this._oldTimeout = this._vsh.getTcpTimeout();
                    this._vsh.setTcpTimeout(this._timeout);
                    this._vsh.resetRx();
                    this._vsh.send(ShowTechSupport.this.getCommandText() + "\n");
                    this._vsh.read(this._out);
                    this._out.close();
                    this._out = null;
                    String prompt = this._vsh.getPrompt();
                    raf = new RandomAccessFile(this._absoluteFlName, "rw");
                    int len = (int)raf.length();
                    int offset = len - 1 - prompt.length() - 10;
                    if (offset <= 0) {
                        if (SnmpSession.isTrace()) {
                            DefaultLogger._DefLogger.error((Object)("The File Size is " + len));
                            DefaultLogger._DefLogger.error((Object)("Seek offset = " + offset));
                        }
                        throw new IOException(this._absoluteFlName + " is corrupted");
                    }
                    raf.seek(offset);
                    byte[] b = new byte[prompt.length() + 10];
                    raf.readFully(b);
                    String lastLines = new String(b).trim();
                    raf.close();
                    raf = null;
                    System.gc();
                    if (lastLines.indexOf(prompt) == -1) {
                        ShowTechSupport.this.error(this._peer, new IOException("Timeout or Prompt Change in command"));
                        DefaultLogger._DefLogger.error((Object)(this._peer + "ShowTech Err"));
                        DefaultLogger._DefLogger.error((Object)lastLines);
                    } else {
                        ShowTechSupport.this.done(this._peer, true);
                        this._state = ShowTechSupport.COMMAND_OUTPUT_FETCHED;
                    }
                } else {
                    ShowTechSupport.this.error(this._peer, new Exception("Not connected"));
                }
            }
            catch (Exception ex) {
                ShowTechSupport.this.error(this._peer, ex);
            }
            finally {
                if (this._vsh != null) {
                    this._vsh.disconnect();
                    this._vsh = null;
                }
                try {
                    if (raf != null) {
                        raf.close();
                        raf = null;
                    }
                }
                catch (IOException ex2) {}
                try {
                    if (this._out != null) {
                        this._out.flush();
                        this._out.close();
                        this._out = null;
                    }
                }
                catch (IOException iOException) {}
                System.gc();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runAsTacPac() {
            try {
                boolean useSsh = ExternalTools.isUseSSH();
                Vsh.setTimeout(45);
                this._vsh = Vsh.getNew(this._parent, this._peer.getAddress().getHostAddress(), this._peer.getUserName(), this._peer.getAuthPassword(), ExternalTools._UseSSH, null);
                this._oldTimeout = 0;
                if (this._vsh != null) {
                    this._oldTimeout = this._vsh.getTcpTimeout();
                    this._vsh.setTcpTimeout(this._timeout);
                    String showtechFile = null;
                    StringBuffer errorInfo = new StringBuffer();
                    ShowTechSupport.this._status.setText("Start...");
                    if (this._fname.trim().length() == 0) {
                        throw new Exception("Please specify fileName");
                    }
                    if (this._fname.startsWith("/")) {
                        this._fname = this._fname.substring(1);
                    }
                    if (ShowTechSupport.this._protocol.getSelected() == 1) {
                        this._absoluteFlName = ShowTechSupport.this._rootDir.getText().trim() + File.separator + this._fname;
                        if (ShowTechSupport.this._userName.getText().trim().length() == 0) {
                            throw new Exception("Please specify User Name");
                        }
                        if (ShowTechSupport.this._password.getPassword().length == 0) {
                            throw new Exception("Please specify Password");
                        }
                        if (ShowTechSupport.this._rootDir.getText().trim().length() == 0) {
                            throw new Exception("Please specify SFTP root directory");
                        }
                        showtechFile = this._vsh.tacpacSwitch(this._peer.getAddress().getHostAddress(), this._fname, ShowTechSupport.this._serverIP.getText(), ShowTechSupport.this._userName.getText(), String.valueOf(ShowTechSupport.this._password.getPassword()), this._appendString == null || this._appendString.equalsIgnoreCase("default") ? "" : this._appendString, 3, null, errorInfo);
                    } else {
                        showtechFile = this._vsh.tacpacSwitch(this._peer.getAddress().getHostAddress(), this._fname, ShowTechSupport.this._serverIP.getText(), null, null, this._appendString == null || this._appendString.equalsIgnoreCase("default") ? "" : this._appendString, 1, null, errorInfo);
                        this._absoluteFlName = TFTP.getInstance().getRoot() + File.separator + this._fname;
                    }
                    if (errorInfo.toString().trim().length() > 0) {
                        throw new Exception(errorInfo.toString());
                    }
                    if (showtechFile == null) {
                        ShowTechSupport.this.error(this._peer, new IOException("Timeout or Prompt Change in command"));
                        DefaultLogger._DefLogger.error((Object)(this._peer + "ShowTech Err"));
                    } else {
                        ShowTechSupport.this.done(this._peer, true);
                        this._state = ShowTechSupport.COMMAND_OUTPUT_FETCHED;
                    }
                } else {
                    ShowTechSupport.this.error(this._peer, new Exception("Not connected"));
                }
            }
            catch (Exception ex) {
                ShowTechSupport.this.error(this._peer, ex);
            }
            finally {
                if (this._vsh != null) {
                    this._vsh.disconnect();
                    this._vsh = null;
                }
            }
        }
    }
}

