/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.hostcom;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.tools.FlowConfigWizard;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.hostcom.VshActionHandlerPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class HSZoneSetPanel
extends VshActionHandlerPanel
implements ActionListener,
StatusIf {
    protected static final String[] _names = new String[]{"Zone: ", "Zoneset: ", null};
    protected JComponent[] _labels;
    protected MenuButton _zoneSetBtn;
    protected MenuButton _zoneBtn;
    protected JButton _showMemberBtn;
    protected FieldPanel _zoneField;
    protected FieldPanel _zoneSetField;
    protected Vsan _vsan;
    protected SmZoneAction _zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
    protected JTextArea _zoneMemDetails;
    protected JCheckBox _createFlow;
    protected Array flows;

    public HSZoneSetPanel(JWizard wiz, String title, ImageIcon image) {
        super(title, "Please specify a new zone name or select an existing zone.  The selected Host & Storage ports will be added to zone and activated.\nNote: Ensure that the Active & Local zone membership is identical.", wiz, image);
        this._zoneAction.setStatusIf(this);
        JLabel[] labels = DialogUtil.buildLabels(_names);
        this._labels = new JComponent[labels.length];
        System.arraycopy(labels, 0, this._labels, 0, labels.length);
        JComponent[] values = new JComponent[this._labels.length];
        this._zoneBtn = new MenuButton(null);
        this._showMemberBtn = DialogUtil.buildButtons(new String[]{"Show Members"}, (ActionListener)this)[0];
        JPanel btnPnl = new JPanel(new FlowLayout(0));
        this._zoneField = new FieldPanel(22, (JComponent)this._zoneBtn);
        btnPnl.add(this._zoneField);
        btnPnl.add(this._showMemberBtn);
        values[0] = btnPnl;
        this._zoneSetBtn = new MenuButton(null);
        this._zoneSetField = new FieldPanel(22, (JComponent)this._zoneSetBtn);
        values[1] = this._zoneSetField;
        this._createFlow = new JCheckBox("Create Flow(s) after Activation", true);
        values[2] = this._createFlow;
        this._vsan = (Vsan)this.getModelValue("VSAN");
        this._zoneMemDetails = new JTextArea();
        this._zoneMemDetails.setOpaque(true);
        this._zoneMemDetails.setEditable(false);
        JScrollPane sp = new JScrollPane(this._zoneMemDetails);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)DialogUtil.buildPanel(this._labels, values), "North");
        pnl.add((Component)sp, "Center");
        JButton[] btn = DialogUtil.buildButtons(new String[]{"Show More Details", "Clear"}, (ActionListener)this);
        JPanel dtlBtnPnl = new JPanel(new FlowLayout(2));
        dtlBtnPnl.add(btn[0]);
        dtlBtnPnl.add(btn[1]);
        pnl.add((Component)dtlBtnPnl, "South");
        this.add((Component)pnl, "Center");
    }

    protected void populateZoneControls() throws SnmpException {
        this._zoneSetField.getField().setEditable(false);
        Switch sw = (Switch)this.getModelValue("ZONE_PEER");
        Vsan selVsan = (Vsan)this.getModelValue("VSAN");
        if (this._zoneAction.getVsan() == null || this._zoneAction.getSwitch() == null || !this._zoneAction.getVsan().equals(selVsan) || !this._zoneAction.getSwitch().equals(sw)) {
            this._zoneAction.setVsanSwitch(sw, selVsan);
            if (!this.getWizard().isVisible()) {
                return;
            }
            this._zoneAction.refresh();
            if (!this.getWizard().isVisible()) {
                return;
            }
            this._zoneField.setText(this._zoneAction.getNewZoneName());
            this._zoneSetField.setFont(ChangedCellRenderer.getNormalFont());
            ZoneSet enforcedZoneset = this._zoneAction.getActiveZoneSet();
            ArrayList zones = this._zoneAction.getAvailableZones();
            Object[] zn = zones.toArray();
            Arrays.sort(zn);
            this._zoneBtn.buildMenu(zn);
            if (enforcedZoneset != null && ((Object)enforcedZoneset).toString().length() > 0) {
                this._zoneSetField.setText(((Object)enforcedZoneset).toString());
                this._zoneSetField.setFont(this._zoneAction.isActiveLocalZonesetModified() ? DialogSeparator.getItalicBoldFont() : ChangedCellRenderer.getItalicFont());
            } else {
                ArrayList zonesets = this._zoneAction.getAvailableZoneSets();
                Object[] zs = zonesets.toArray();
                Arrays.sort(zs);
                this._zoneSetBtn.buildMenu(zs);
                if (zonesets.size() == 0) {
                    this._zoneSetField.setText("Zoneset1");
                    this._zoneSetField.getField().setEditable(true);
                } else {
                    this._zoneSetField.setText(zs[0].toString());
                }
            }
            this._zoneField.getField().setSelectionStart(0);
            this._zoneField.getField().setSelectionEnd(this._zoneField.getText().length());
            this._zoneSetBtn.setVisible(enforcedZoneset == null);
        }
    }

    @Override
    public boolean refresh() {
        this.setModelValue("ZONESET", null);
        Thread th = new Thread(new RefreshAction());
        th.start();
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        return true;
    }

    protected boolean validateZoneFields() {
        String zoneName = this._zoneField.getText().trim();
        if (zoneName.length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify a valid zone name.");
            return false;
        }
        if (this._zoneSetField.getText().trim().length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify a valid zoneset name.");
            return false;
        }
        return true;
    }

    @Override
    public void doFinish() {
        if (!this.validateZoneFields()) {
            return;
        }
        if (!this.continueIfZoneSetModefied()) {
            return;
        }
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        String zonesetName = this._zoneSetField.getText().trim();
        if (zonesetName.length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify Zoneset name.");
            return;
        }
        String zoneName = this._zoneField.getText().trim();
        if (zoneName.length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify Zone name.");
            return;
        }
        Zone znn = zoneAction.findZone(zoneName);
        ArrayList znMems = null;
        if (znn != null) {
            znMems = zoneAction.getZoneMembers(znn);
        }
        Array memsToAdd = this.getMemberPorts(znMems);
        this.setModelValue("ZONE_MEMBERS_TOADD", memsToAdd);
        this.setModelValue("SEL_EXISTING_ZONE", znn);
        boolean flowExists = HostCommisioningWizard.doesFlowExist(this.getWizard(), this.flows);
        HostCommisioningWizard cfr_ignored_0 = (HostCommisioningWizard)this.getWizard();
        if (!HostCommisioningWizard.isDPVMConfigNeeded(this.getWizard())) {
            HostCommisioningWizard cfr_ignored_1 = (HostCommisioningWizard)this.getWizard();
            if (!HostCommisioningWizard.isDAConfigNeeded(this.getWizard()) && znn != null && memsToAdd != null && memsToAdd.size() == 0 && flowExists) {
                JOptionPane.showMessageDialog(this.getWizard(), "No change to Device Alias, DPVM, \nzoning and flow configuration is required.", this.getWizard().getTitle(), 1);
                return;
            }
        }
        if (znn != null && !zoneAction.isZoneMemberOfZnst(zoneName, zonesetName) && JOptionPane.showConfirmDialog(this.getWizard(), "The selected existing zone " + zoneName + " is not a member of zoneset " + zonesetName + ".\n" + "Wizard will add " + zoneName + " to " + zonesetName + " before activation. Continue?", this.getWizard().getTitle(), 0, 2) != 0) {
            return;
        }
        VshActionHandlerPanel.VshAction act = new VshActionHandlerPanel.VshAction((VshActionHandlerPanel)this, (VshActionHandlerPanel)this, new Object[]{false, null});
        Thread th = new Thread(act);
        this.getWizard().setStatus("Verifying current configuration...");
        this.setProcessing(true);
        th.start();
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
    }

    boolean isZoningChangeNeeded(String zoneName) {
        if (zoneName == null || zoneName.length() == 0) {
            return false;
        }
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        Zone znn = zoneAction.findZone(zoneName);
        ArrayList znMems = null;
        if (znn != null) {
            znMems = zoneAction.getZoneMembers(znn);
        }
        Array memsToAdd = this.getMemberPorts(znMems);
        return znn == null || memsToAdd == null || memsToAdd.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAction(boolean showOnly) throws SnmpException, IOException {
        VshBase vsh = null;
        try {
            Switch cacheSw = (Switch)this.getWizard().getModelValue("ZONE_PEER");
            SnmpPeer prr = cacheSw.getSnmpPeer();
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (!this.getWizard().isVisible()) {
                return;
            }
            if (vsh == null) {
                throw new IOException("unable to open session to switch " + cacheSw);
            }
            ((HostCommisioningWizard)this.getWizard()).verifyChangedVsanExists(false, this._zoneMemDetails);
            ((HostCommisioningWizard)this.getWizard()).changeHostVsan(false, this._zoneMemDetails);
            ((HostCommisioningWizard)this.getWizard()).runCLIActions(this._zoneMemDetails, vsh);
            Boolean skipZoning = (Boolean)this.getModelValue("SKIP_ZONING");
            if (!skipZoning.booleanValue() && this.isZoningChangeNeeded(this._zoneField.getText().trim())) {
                this.createAndActivateZoneSet((Boolean)this.inputData[0], (String)this.inputData[1]);
            } else {
                if (this._zoneMemDetails != null) {
                    this._zoneMemDetails.append("No zoning DB change is required\n");
                }
                this.actionFinished(false);
            }
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            this.setProcessing(false);
        }
    }

    protected boolean continueIfZoneSetModefied() {
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        if (this._zoneAction.isActiveLocalZonesetModified()) {
            JOptionPane.showMessageDialog(this.getWizard(), "The Active zoneset and local zoneset to be activated on switch " + this._zoneAction.getSwitch() + " differ. \nPlease ensure these are identical and rerun the wizard?", this.getWizard().getTitle(), 2);
            return false;
        }
        return true;
    }

    protected void createAndActivateZoneSet(boolean saveConfig, String configFile) throws SnmpException {
        String zonesetName = this._zoneSetField.getText();
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        ZoneSet zs = this._zoneAction.getActiveZoneSet();
        Array memberPorts = (Array)this.getModelValue("ZONE_MEMBERS_TOADD");
        Zone znn = (Zone)this.getModelValue("SEL_EXISTING_ZONE");
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        Boolean commissionHost = (Boolean)this.getModelValue("COMMISSION_HOST");
        if (commissionHost.booleanValue()) {
            if (znn != null && memberPorts != null && memberPorts.size() > 0) {
                this._zoneAction.insertMembers(znn, memberPorts.toArray(new Object[memberPorts.size()]), true);
            }
            this.getWizard().setStatus("Creating/Modifying zone & adding to zoneset...");
            zs = this._zoneAction.createZoneSet(zonesetName, this._zoneField.getText(), false, znn != null ? null : memberPorts, false, -1, false, null, this._zoneAction.getSwitch().getSwitchUpTime());
            this._zoneMemDetails.append("Created/Modified Zoneset\n");
        }
        if (this._zoneSetField.getText().trim().length() > 0) {
            this.getWizard().setStatus("Activating zoneset " + zs + "...");
            this._zoneAction.activateAction(zs, true, saveConfig, configFile, true);
            this._zoneMemDetails.append("Activating Zoneset " + zs + "\n");
        }
    }

    protected Array getMemberPorts(ArrayList currentZnMembes) {
        Array<Object> memberPrts = new Array<Object>();
        String hsPort = (String)this.getModelValue("HOST_PORT");
        boolean hasColon = hsPort.indexOf(":") != -1;
        byte[] bt = new Wwn(hsPort, hasColon).getValue();
        Array portsToZone = (Array)this.getModelValue("SELECTED_HS_END_PORTS");
        boolean doNotAddHost = false;
        if (currentZnMembes != null) {
            for (int i = 0; i < currentZnMembes.size(); ++i) {
                ZoneMember zmm = (ZoneMember)currentZnMembes.get(i);
                if (bt == null || doNotAddHost || zmm.getMemFormat() != 1 || !SnmpString.equals(zmm.getMemId(), bt)) continue;
                doNotAddHost = true;
                break;
            }
        }
        for (int k = 0; k < portsToZone.size(); ++k) {
            EndPort ep = (EndPort)portsToZone.elementAt(k);
            boolean doNotAdd = false;
            if (currentZnMembes != null) {
                for (int i = 0; i < currentZnMembes.size(); ++i) {
                    ZoneMember zmm = (ZoneMember)currentZnMembes.get(i);
                    if (zmm.getMemFormat() != 1 || !SnmpString.equals(ep.getPortWwn().getValue(), zmm.getMemId())) continue;
                    doNotAdd = true;
                    break;
                }
            }
            if (doNotAdd) continue;
            memberPrts.addElement(ep);
        }
        if (!doNotAddHost) {
            memberPrts.addElement(bt);
        }
        return memberPrts;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this._showMemberBtn) {
            Zone znSel = this._zoneAction.findZone(this._zoneField.getText().trim());
            if (znSel != null) {
                ArrayList mems = this._zoneAction.getZoneMembers(znSel);
                if (mems == null || mems.size() == 0) {
                    this._zoneMemDetails.append("No members present in zone " + znSel);
                } else {
                    for (int i = 0; i < mems.size(); ++i) {
                        this._zoneMemDetails.append(i > 0 ? "\n" : "");
                        this._zoneMemDetails.append(mems.get(i).toString());
                    }
                }
            } else {
                this._zoneMemDetails.append("Zone not present in local zone DB.");
            }
        } else {
            char ch = evt.getActionCommand().charAt(0);
            switch (ch) {
                case 'S': {
                    StringBuffer actions = new StringBuffer();
                    ArrayList cliActions = new ArrayList();
                    try {
                        ((HostCommisioningWizard)this.getWizard()).verifyChangedVsanExists(true, this._zoneMemDetails);
                        ((HostCommisioningWizard)this.getWizard()).changeHostVsan(true, this._zoneMemDetails);
                    }
                    catch (SnmpException ex) {
                        // empty catch block
                    }
                    HostCommisioningWizard cfr_ignored_0 = (HostCommisioningWizard)this.getWizard();
                    HostCommisioningWizard.buildDACommandStructure(this.getWizard(), actions, cliActions);
                    Boolean skipDpvm = (Boolean)this.getModelValue("SKIP_DPVM");
                    if (!skipDpvm.booleanValue()) {
                        HostCommisioningWizard cfr_ignored_1 = (HostCommisioningWizard)this.getWizard();
                        HostCommisioningWizard.buildDPVMCommandStructure(this.getWizard(), actions, cliActions);
                    }
                    if (cliActions != null) {
                        if (cliActions.size() > 0) {
                            actions.append("\nCLI Commands:\n");
                        }
                        for (int i = 0; i < cliActions.size(); ++i) {
                            actions.append(((Object[])cliActions.get(i))[0]);
                        }
                    }
                    this._zoneMemDetails.append(actions.toString());
                    Boolean skipZoning = (Boolean)this.getModelValue("SKIP_ZONING");
                    if (skipZoning.booleanValue()) break;
                    String zoneName = this._zoneField.getText().trim();
                    if (zoneName.length() == 0) {
                        this._zoneMemDetails.append("Please specify Zone name.\n");
                        return;
                    }
                    SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
                    Zone znn = zoneAction.findZone(zoneName);
                    ArrayList znMems = null;
                    if (znn != null) {
                        znMems = zoneAction.getZoneMembers(znn);
                    }
                    Array memsToAdd = this.getMemberPorts(znMems);
                    if (znn != null && memsToAdd.size() == 0) {
                        this._zoneMemDetails.append("No change to existing zone configuration.  Selected members already present in zone " + znn + "\n");
                    } else {
                        this._zoneMemDetails.append((znn != null ? "Add to existing Zone " : "Create new Zone ") + zoneName + "\n");
                        if (memsToAdd.size() > 0) {
                            this._zoneMemDetails.append("Add Members\n");
                        }
                        StringBuffer portsInfo = new StringBuffer();
                        for (int i = 0; i < memsToAdd.size(); ++i) {
                            Object ob;
                            if (portsInfo.length() > 0) {
                                portsInfo.append(", ");
                            }
                            if ((ob = memsToAdd.elementAt(i)) instanceof byte[]) {
                                ClientController.getInstance();
                                EndPort epp = ClientController.findFabricEndPortByWwn(new Wwn((byte[])ob));
                                portsInfo.append(epp != null ? epp.toString() : SnmpString.toHexString((byte[])ob));
                                continue;
                            }
                            portsInfo.append(ob.toString());
                        }
                        this._zoneMemDetails.append(portsInfo.toString() + "\n");
                    }
                    this.createFlow(true);
                    break;
                }
                case 'C': {
                    this._zoneMemDetails.setText("");
                }
            }
        }
    }

    @Override
    public void setStatus(String status) {
        this.getWizard().setStatus(status);
    }

    @Override
    public void handleError(Exception[] ex) {
        ((HostCommisioningWizard)this.getWizard()).handleError(ex);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void actionFinished() {
        this.actionFinished(true);
    }

    @Override
    public void actionFinished(boolean zoneActivated) {
        if (zoneActivated) {
            this._zoneMemDetails.append("Zone Activation Finished\n");
        }
        this.createFlow(false);
        ((HostCommisioningWizard)this.getWizard()).actionFinished();
    }

    private void createFlow(boolean showOnly) {
        if (!this._createFlow.isEnabled() || !this._createFlow.isSelected()) {
            return;
        }
        String hsPort = (String)this.getModelValue("HOST_PORT");
        Vsan vv = (Vsan)this.getModelValue("VSAN");
        boolean hasColon = hsPort.indexOf(":") != -1;
        Wwn hsWwn = new Wwn(hsPort, hasColon);
        ClientController.getInstance();
        EndPort hsEp = ClientController.findFabricEndPortByWwn(hsWwn, vv.getVsanId());
        if (hsEp != null) {
            Array portsToZone = (Array)this.getModelValue("SELECTED_HS_END_PORTS");
            try {
                for (int p = 0; p < portsToZone.size(); ++p) {
                    EndPort dstEp = (EndPort)portsToZone.elementAt(p);
                    int srcId = hsEp.getFcIdNum(vv.getVsanId());
                    int dstId = dstEp.getFcIdNum(vv.getVsanId());
                    Switch realSw = FlowConfigWizard.getRealSwitch(hsEp, vv);
                    int[] modules = FlowConfigWizard.getSrcModules(realSw, hsEp);
                    boolean flowExists = false;
                    if (modules != null && modules.length > 0) {
                        flowExists = true;
                        for (int m = 0; m < modules.length; ++m) {
                            if (FlowConfigWizard.doesFlowExist(this.flows, modules[m] - 21, srcId, dstId)) continue;
                            flowExists = false;
                            break;
                        }
                    }
                    String moduleList = "";
                    if (modules != null && modules.length > 0) {
                        for (int m = 0; m < modules.length; ++m) {
                            moduleList = moduleList + " " + (modules[m] - 21);
                        }
                    }
                    if (!flowExists) {
                        this._zoneMemDetails.append("Creating flow between " + hsEp + " and " + dstEp + " on switch " + realSw + (moduleList.length() == 0 ? "" : " for module(s) " + moduleList) + "\n");
                    } else {
                        this._zoneMemDetails.append("Flow already exists between " + hsEp + " and " + dstEp + " on switch " + realSw + "\n");
                    }
                    if (srcId == 0 || dstId == 0 || flowExists || showOnly) continue;
                    Array flowsToCreate = new Array();
                    FlowConfigWizard.createFlow(realSw, vv.getVsanId(), this.flows, hsEp, dstEp, flowsToCreate);
                    for (int i = 0; i < flowsToCreate.size(); ++i) {
                        this.flows.addElement(flowsToCreate.elementAt(i));
                    }
                }
            }
            catch (SnmpException exx) {
                this.handleError(new Exception[]{exx});
            }
        } else {
            this._zoneMemDetails.append("Cannot create Flows since the selected Host WWN is not present in selected VSAN.\n");
        }
    }

    class RefreshAction
    implements Runnable {
        Exception actionException = null;
        EndPort hsEp = null;

        RefreshAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                block5: {
                    HSZoneSetPanel.this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
                    HSZoneSetPanel.this.populateZoneControls();
                    if (HSZoneSetPanel.this.getWizard().isVisible()) break block5;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (HSZoneSetPanel.this.getWizard().isVisible()) {
                                HSZoneSetPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                                HSZoneSetPanel.this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                            }
                            HSZoneSetPanel.this.getWizard().setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    return;
                }
                try {
                    String hsPort = (String)HSZoneSetPanel.this.getModelValue("HOST_PORT");
                    Vsan vv = (Vsan)HSZoneSetPanel.this.getModelValue("VSAN");
                    boolean hasColon = hsPort.indexOf(":") != -1;
                    Wwn hsWwn = new Wwn(hsPort, hasColon);
                    ClientController.getInstance();
                    this.hsEp = ClientController.findFabricEndPortByWwn(hsWwn, vv.getVsanId());
                    if (this.hsEp == null) break block6;
                    HSZoneSetPanel.this.flows = FlowConfigWizard.getExistingFlowsOnSwitch(FlowConfigWizard.getRealSwitch(this.hsEp, vv), vv.getVsanId());
                }
                catch (SnmpException ex) {
                    try {
                        this.actionException = ex;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HSZoneSetPanel.this.getWizard().isVisible()) {
                                    Util.errorMessage((Component)HSZoneSetPanel.this.getWizard(), RefreshAction.this.actionException);
                                    HSZoneSetPanel.this.setDataValid(false);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

