/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ioa.ErrorTableModel;
import com.cisco.dcbu.sm.client.ioa.IOATable;
import com.cisco.dcbu.sm.client.ioa.OperationStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ErrorListDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 1L;
    private JButton[] _buttons;
    private JFrame _parent;

    public ErrorListDialog(JFrame parent) {
        super(parent);
        this.buildDialog(parent, new ArrayList<OperationStatus>());
    }

    public ErrorListDialog(JFrame parent, ArrayList<OperationStatus> opList) {
        super(parent);
        this.buildDialog(parent, opList);
    }

    private void buildDialog(JFrame parent, ArrayList<OperationStatus> opList) {
        this._parent = parent;
        this.setDefaultCloseOperation(2);
        this.setTitle("Errors");
        String[] btnLbl = new String[]{"OK"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        this._buttons[0].setActionCommand("Ok");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        JPanel mainPnl = new JPanel(new BorderLayout());
        IOATable table = new IOATable();
        table.setRowSelectionAllowed(false);
        ErrorTableModel tableModel = new ErrorTableModel();
        table.updateTable(tableModel, opList);
        table.setAutoResizeMode(2);
        TableColumn iconColumn = table.getColumnModel().getColumn(0);
        iconColumn.setCellRenderer(new IOAErrorImgRenderer());
        iconColumn.setPreferredWidth(30);
        iconColumn.setWidth(30);
        iconColumn.setMinWidth(30);
        iconColumn.setMaxWidth(30);
        TableColumn errColumn = table.getColumnModel().getColumn(1);
        errColumn.setCellRenderer(new IOAWrapRenderer());
        JScrollPane scroller = new JScrollPane((Component)((Object)table));
        mainPnl.add((Component)scroller, "Center");
        DialogUtil.buildDialog((JDialog)this, (Container)this._parent, (Container)mainPnl, buttonPanel);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        }
    }

    public class IOAWrapRenderer
    extends JTextArea
    implements TableCellRenderer {
        static final long serialVersionUID = 1L;

        public IOAWrapRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setBorder(new EmptyBorder(1, 2, 3, 2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            }
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            return this;
        }
    }

    public class IOAErrorImgRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ImageIcon sitesIcon = Util.loadIcon("icons/IOA/warning.png");
            this.setIcon(sitesIcon);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

