/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ioa.AddCustomFlowDialog;
import com.cisco.dcbu.sm.client.ioa.AddFlowConfigDialog;
import com.cisco.dcbu.sm.client.ioa.ErrorListDialog;
import com.cisco.dcbu.sm.client.ioa.FlowDirectionConfigDialog;
import com.cisco.dcbu.sm.client.ioa.FlowTableModel;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOAChartDialog;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.ioa.IOATable;
import com.cisco.dcbu.sm.client.ioa.IOATableModel;
import com.cisco.dcbu.sm.client.ioa.IOATree;
import com.cisco.dcbu.sm.client.ioa.IOATreeNode;
import com.cisco.dcbu.sm.client.ioa.IOAWorkerApply;
import com.cisco.dcbu.sm.client.ioa.IOAWorkerCacheUpdate;
import com.cisco.dcbu.sm.client.ioa.IOAWorkerCluster;
import com.cisco.dcbu.sm.client.ioa.IOAWorkerSite;
import com.cisco.dcbu.sm.client.ioa.IOAWorkerSwitch;
import com.cisco.dcbu.sm.client.ioa.InterfaceTableModel;
import com.cisco.dcbu.sm.client.ioa.OperationStatusEnum;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.EndDevice;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.common.model.ioa.IOAInterface;
import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.utils.SwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

class IOADialogAction
implements PropertyChangeListener {
    private IOATree _ioaTree;
    private IOATable _upperTable;
    private IOATable _lowerTable;
    private IOADialog _ioaDialog;
    private IOACache _ioaCache;
    private static final int WORKER_ACTION_NONE = 0;
    private static final int WORKER_ACTION_CREATE_CLUSTER = 1;
    private static final int WORKER_ACTION_DELETE_CLUSTER = 2;
    private static final int WORKER_ACTION_CREATE_SITE = 3;
    private static final int WORKER_ACTION_DELETE_SITE = 4;
    private static final int WORKER_ACTION_DELETE_CLUSTER_MEMBER = 5;
    private int workerAction = 0;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    IOADialogAction(IOADialog ioaDialog) {
        this._ioaDialog = ioaDialog;
    }

    void setCache(IOACache cache) {
        this._ioaCache = cache;
    }

    void setComponents(IOATree tree, IOATable table) {
        this.setComponents(tree, table, null);
    }

    void setComponents(IOATree tree, IOATable table, IOATable table2) {
        this._ioaTree = tree;
        this._upperTable = table;
        this._lowerTable = table2;
    }

    protected TreePath[] getSelectedTreePath() {
        TreePath[] tpt = this._ioaTree.getSelectionPaths();
        return tpt;
    }

    private void viewUpdate(Object userObject) {
        this._ioaTree.update(this._ioaCache, userObject);
        this.showTreeNodeData(userObject, this._ioaTree.getSelectionPath());
    }

    void showTreeNodeData(Object userObject, TreePath path, boolean clearStatus) {
        this._ioaDialog.setStatus("");
        this.showTreeNodeData(userObject, path);
    }

    void showTreeNodeData(Object userObject, TreePath path) {
        DefaultMutableTreeNode theObject;
        if (this._ioaCache.getLastSelectedNode() != null && this._ioaCache.getNeedsApply()) {
            int answer = this.showQueryCancelDialog("You have unapplied changes. Do you wish to apply these changes?");
            if (answer == 0) {
                this.showWaitAndApplyChanges();
                return;
            }
            if (answer == 1) {
                this.clearApply();
            } else {
                DefaultMutableTreeNode theObject2 = this._ioaTree.getTreeNodeForUserObject(this._ioaCache.getLastSelectedNode());
                if (theObject2 != null) {
                    this._ioaTree.setSelectionPath(new TreePath(theObject2.getPath()));
                }
                return;
            }
        }
        if ((theObject = this._ioaTree.getTreeNodeForUserObject(userObject)) == null) {
            if (userObject instanceof Cluster) {
                this._ioaTree.setSelectionPath(new TreePath(this._ioaTree.getTreeNodeForUserObject("Clusters").getPath()));
                path = this._ioaTree.getSelectionPath();
                userObject = "Clusters";
            } else {
                this._ioaTree.setSelectionPath(new TreePath(this._ioaTree.getTreeNodeForUserObject("Sites").getPath()));
                path = this._ioaTree.getSelectionPath();
                userObject = "Sites";
            }
        }
        this._ioaDialog.buildTableHeading(path);
        this._ioaCache.setLastSelectedNode(userObject);
        this._ioaDialog.getControls().disableInsertButton();
        this._ioaDialog.getControls().disableRemoveButton();
        this._ioaDialog.getControls().disableChartButton();
        if (userObject instanceof Site) {
            this._ioaDialog.showDoubleTable();
            this._ioaDialog.setUpperTableText("Assigned Switches");
            this._ioaDialog.setLowerTableText("Unassigned Switches");
            Site site = (Site)userObject;
            this._ioaCache.setActiveSite((Site)userObject);
            this._ioaCache.setAssignedSwitchList(site.getMemberList());
            this._upperTable.updateTable(this._ioaDialog.getTableModel(3), this._ioaCache.getAssignedSwitchList());
            this._lowerTable.updateTable(this._ioaDialog.getTableModel(4), this._ioaCache.getUnassignedSwitchList());
            this._ioaDialog.getControls().enableRemoveButton();
        } else if (userObject instanceof Cluster) {
            this._ioaDialog.showWait();
            if (this._ioaCache.getActiveCluster() == null || !this._ioaCache.getActiveCluster().equals(userObject)) {
                this._ioaCache.setActiveCluster((Cluster)userObject);
                this._ioaDialog.progressDialog.clearCurrent();
                IOAWorkerCacheUpdate worker = new IOAWorkerCacheUpdate(this._ioaDialog, this._ioaCache);
                worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
                worker.addPropertyChangeListener(this);
                this._ioaDialog.progressDialog.addListener(worker);
                worker.execute();
                return;
            }
            if (this._ioaCache.getActiveCluster().equals(userObject)) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (tn.getUserObject().equals(userObject)) {
                    tn.setUserObject(this._ioaCache.getActiveCluster());
                }
                userObject = this._ioaCache.getActiveCluster();
            }
            Cluster cluster = (Cluster)userObject;
            this._ioaDialog.showDoubleTable();
            this._ioaDialog.setUpperTableText("Cluster Members");
            this._ioaDialog.setLowerTableText("Interface Statistics");
            this._upperTable.updateTable(this._ioaDialog.getTableModel(9), cluster.getMembers());
            this._lowerTable.updateTable(this._ioaDialog.getTableModel(10), cluster.getInterfaceStatsList());
            this._ioaDialog.getControls().enableRemoveButton();
            this._ioaDialog.showReady();
        } else if (userObject instanceof IOATreeNode) {
            this._ioaDialog.showWait();
            IOATreeNode node = (IOATreeNode)userObject;
            if (this._ioaCache.getActiveCluster() == null || !this._ioaCache.getActiveCluster().equals(node.getCluster())) {
                this._ioaCache.setActiveCluster(node.getCluster());
                this._ioaDialog.progressDialog.clearCurrent();
                IOAWorkerCacheUpdate worker = new IOAWorkerCacheUpdate(this._ioaDialog, this._ioaCache);
                worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
                worker.addPropertyChangeListener(this);
                this._ioaDialog.progressDialog.addListener(worker);
                worker.execute();
                return;
            }
            if (this._ioaCache.getActiveCluster().equals(node.getCluster())) {
                node.setCluster(this._ioaCache.getActiveCluster());
            }
            if (node.getName().equals("Interfaces")) {
                String intfName;
                this._ioaDialog.showDoubleTable();
                this._ioaDialog.setUpperTableText("Assigned Interfaces");
                this._ioaDialog.setLowerTableText("Unassigned Interfaces");
                this._upperTable.updateTable(this._ioaDialog.getTableModel(5), this._ioaCache.getCluster(node.getCluster().getName()).getInterfaceList());
                this._lowerTable.updateTable(this._ioaDialog.getTableModel(6), this._ioaCache.getCandidateInterfaceList());
                for (IOAInterface theIntf : this._ioaCache.getCluster(node.getCluster().getName()).getInterfaceList()) {
                    intfName = "ioa " + theIntf.getSlot() + " / " + theIntf.getPort();
                    _Logger.debug((Object)(theIntf.getSwitchInfo().getName() + "," + intfName + " retrieved from assigned interface list cache."));
                }
                for (IOAInterface theIntf : this._ioaCache.getCandidateInterfaceList()) {
                    intfName = "ioa " + theIntf.getSlot() + " / " + theIntf.getPort();
                    _Logger.debug((Object)(theIntf.getSwitchInfo().getName() + "," + intfName + " retrieved from candidate interface list cache."));
                }
                TableColumn adminColumn = this._upperTable.getColumnModel().getColumn(6);
                String[] adminOptions = new String[]{"up", "down"};
                JComboBox<String> editorComboBox = new JComboBox<String>(adminOptions);
                editorComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IOADialogAction.this.needsApply();
                    }
                });
                DefaultCellEditor adminEditor = new DefaultCellEditor(new JComboBox<String>(adminOptions));
                adminEditor.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingCanceled(ChangeEvent e) {
                    }

                    @Override
                    public void editingStopped(ChangeEvent e) {
                        IOADialogAction.this.needsApply();
                    }
                });
                adminColumn.setCellEditor(adminEditor);
            } else if (node.getName().equals("Flows")) {
                this._ioaDialog.showDoubleTable();
                this._upperTable.updateTable(this._ioaDialog.getTableModel(7), this._ioaCache.getFlowList());
                this._lowerTable.updateTable(this._ioaDialog.getTableModel(8), this._ioaCache.getCandidateFlowList());
                this._ioaDialog.setUpperTableText("Assigned Flows (" + this._upperTable.getRowCount() + ")");
                this._ioaDialog.setLowerTableText("Unassigned Flows (" + this._lowerTable.getRowCount() + ")");
            }
            this._ioaDialog.showReady();
        } else if (userObject == "Sites") {
            this._ioaDialog.showSingleTable();
            this._ioaDialog.setUpperTableText("Sites");
            this._upperTable.updateTable(this._ioaDialog.getTableModel(1), this._ioaCache.getSitesList());
            this._ioaDialog.getControls().enableInsertButton();
        } else if (userObject == "Clusters") {
            this._ioaDialog.showSingleTable();
            this._ioaDialog.setUpperTableText("Clusters");
            this._upperTable.updateTable(this._ioaDialog.getTableModel(2), this._ioaCache.getClusterList());
            this._ioaDialog.getControls().enableInsertButton();
        }
    }

    public void success(PollerManager manager, StringBuffer status) {
        this._ioaTree.repaint();
    }

    public void close() {
        this._ioaDialog.dispose();
    }

    public void insertCalled() {
        DefaultMutableTreeNode dmtn;
        Object userObj;
        Object ob;
        TreePath[] path = this.getSelectedTreePath();
        if (path != null && path.length != 0 && (ob = path[0].getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObj = (dmtn = (DefaultMutableTreeNode)ob).getUserObject()) != null) {
            String label;
            if (userObj instanceof String) {
                String label2 = (String)userObj;
                if (label2.equals("Sites")) {
                    this.createSite();
                } else if (label2.equals("Clusters")) {
                    this.createCluster();
                }
            } else if (userObj instanceof IOATreeNode && (label = userObj.toString()).equals("Flows")) {
                this.createFlow();
            }
        }
    }

    private void createSite() {
        ArrayList<Site> sites = this._ioaCache.getSitesList();
        String siteName = null;
        boolean valid = false;
        block0: while (!valid) {
            Pattern SITE_PATTERN;
            valid = true;
            siteName = this.showInputDialog("Site Name", "");
            if (siteName == null) {
                return;
            }
            if (siteName.length() == 0 || siteName.length() > 31) {
                this.showErrorDialog("Site name must be between 1 and 31 characters long.");
                valid = false;
            }
            if (!(SITE_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$")).matcher(siteName).matches()) {
                this.showErrorDialog("Site name must not contain any spaces or special characters.");
                valid = false;
            }
            for (Site s : sites) {
                if (!s.getName().equals(siteName)) continue;
                if (!this.showQueryDialog("A site with this name already exists, do you wish to enter another name?")) {
                    this.showErrorDialog("The selected switch will be added to existing site (" + s.getName() + ").");
                    continue block0;
                }
                valid = false;
                continue block0;
            }
        }
        Switch swi = null;
        ArrayList<Switch> uaswitches = this.removeUnsupportedSwitches(this._ioaCache.getUnassignedSwitchList());
        ArrayList<String> swCandidates = new ArrayList<String>();
        if (uaswitches != null) {
            for (Switch sw : uaswitches) {
                swCandidates.add(sw.getName());
            }
        }
        if (swCandidates.size() == 0) {
            this.showErrorDialog("There are no unassigned supported switches available");
            return;
        }
        String res = this.showListSingleSelectDialog("Select first switch for site", swCandidates.toArray(new String[swCandidates.size()]));
        if (res == null) {
            return;
        }
        for (Switch sw : uaswitches) {
            if (!sw.getName().equals(res)) continue;
            swi = sw;
        }
        if (swi == null) {
            this.showErrorDialog("Unexpected error selecting switch");
            return;
        }
        this.needsApply();
        this._ioaCache.setSwingWorkerSiteName(siteName);
        this._ioaCache.setSwingWorkerSwitch(swi);
        this._ioaDialog.showWait();
        this.workerAction = 3;
        this._ioaDialog.progressDialog.clearCurrent();
        IOAWorkerSite worker = new IOAWorkerSite(this._ioaDialog, this._ioaCache);
        worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
        worker.addPropertyChangeListener(this);
        this._ioaDialog.progressDialog.addListener(worker);
        _Logger.debug((Object)("IOADialogAction:createSite " + siteName + " - start worker"));
        worker.execute();
    }

    public void createCluster() {
        Switch masterSwitch = null;
        String clusterName = null;
        boolean valid = false;
        while (!valid) {
            Pattern CLUSTER_PATTERN;
            valid = true;
            clusterName = this.showInputDialog("Cluster Name", "");
            if (clusterName == null) {
                return;
            }
            if (clusterName != null && (clusterName.length() == 0 || clusterName.length() > 31)) {
                this.showErrorDialog("Cluster name must be between 1 and 31 characters long.");
                valid = false;
            }
            if (!(CLUSTER_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$")).matcher(clusterName).matches()) {
                this.showErrorDialog("Cluster name must not contain any spaces or special characters.");
                valid = false;
            }
            ArrayList<Cluster> clusterList = this._ioaCache.getClusterList();
            ArrayList<String> clusterNameList = new ArrayList<String>();
            if (clusterList != null) {
                for (Cluster theCluster : clusterList) {
                    clusterNameList.add(theCluster.getName());
                }
            }
            if (!clusterNameList.contains(clusterName)) continue;
            this.showErrorDialog("Cluster name must be unique across fabric.");
            valid = false;
        }
        this._ioaCache.setSwingWorkerClusterName(clusterName);
        ArrayList<Site> sites = this._ioaCache.getSitesList();
        ArrayList<Switch> uaswitches = this._ioaCache.getUnassignedSwitchList();
        ArrayList<Switch> allSwitches = new ArrayList<Switch>();
        allSwitches.addAll(uaswitches);
        for (Site s : sites) {
            allSwitches.addAll(s.getMemberList());
        }
        ArrayList<String> masterSwCandidates = new ArrayList<String>();
        for (Switch sw : allSwitches) {
            if (sw.getSiteName().length() > 0) {
                masterSwCandidates.add(sw.getName() + " (" + sw.getSiteName() + ")");
                continue;
            }
            masterSwCandidates.add(sw.getName() + " <unassigned>");
        }
        String res = this.showListSingleSelectDialog("Select a switch where cluster will be stored", masterSwCandidates.toArray(new String[masterSwCandidates.size()]));
        if (res == null) {
            this.showErrorDialog("A master switch must be selected, operation cancelled.");
            return;
        }
        if (res.charAt(res.length() - 1) == ')') {
            String ms = res.split(" ")[0];
            for (Switch sw : allSwitches) {
                if (!sw.getName().equals(ms)) continue;
                masterSwitch = sw;
            }
            if (masterSwitch == null) {
                this.showErrorDialog("Unexpected error getting master switch, operation cancelled.");
                return;
            }
            this._ioaCache.setSwingWorkerSwitch(masterSwitch);
            this._ioaCache.setSwingWorkerSiteName(masterSwitch.getSiteName());
        } else {
            ArrayList<String> sitesList = new ArrayList<String>();
            for (Site s : sites) {
                sitesList.add(s.getName());
            }
            sitesList.add("<new site>");
            String msSite = this.showListSingleSelectDialog("Switch must belong to a site", sitesList.toArray(new String[sitesList.size()]));
            if (msSite != null && msSite.equals("<new site>")) {
                boolean found = false;
                block6: while (!found) {
                    Pattern MSITE_PATTERN;
                    msSite = this.showInputDialog("Site Name", "");
                    if (msSite == null) {
                        this.showErrorDialog("Selected master switch must belong to a site.");
                        continue;
                    }
                    found = true;
                    if (msSite.length() == 0 || msSite.length() > 31) {
                        this.showErrorDialog("Site name must be between 1 and 31 characters long.");
                        found = false;
                    }
                    if (!(MSITE_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$")).matcher(msSite).matches()) {
                        this.showErrorDialog("Site name must not contain any spaces or special characters.");
                        found = false;
                    }
                    for (Site s : sites) {
                        if (!s.getName().equals(msSite)) continue;
                        if (!this.showQueryDialog("A site with this name already exists, do you wish to enter another name?")) {
                            this.showErrorDialog("The selected switch will be added to existing site (" + s.getName() + ").");
                            continue block6;
                        }
                        found = false;
                        continue block6;
                    }
                }
            }
            if (msSite == null) {
                this.showErrorDialog("Error getting master switch, operation cancelled.");
                return;
            }
            this._ioaCache.setSwingWorkerSiteName(msSite);
            String ms = res.split(" ")[0];
            for (Switch sw : allSwitches) {
                if (!sw.getName().equals(ms)) continue;
                masterSwitch = sw;
            }
            if (masterSwitch != null) {
                this._ioaCache.setSwingWorkerSwitch(masterSwitch);
            }
        }
        if (masterSwitch == null) {
            this.showErrorDialog("Error getting master switch, operation cancelled.");
            return;
        }
        this._ioaDialog.showWait();
        this.workerAction = 1;
        this._ioaDialog.progressDialog.clearCurrent();
        IOAWorkerCluster worker = new IOAWorkerCluster(this._ioaDialog, this._ioaCache);
        worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
        worker.addPropertyChangeListener(this);
        this._ioaDialog.progressDialog.addListener(worker);
        _Logger.debug((Object)("IOADialogAction:createCluster " + clusterName + " - start worker"));
        worker.execute();
    }

    public void removeCalled() {
        Object ob;
        TreePath[] path = this.getSelectedTreePath();
        if (path != null && path.length != 0 && (ob = path[0].getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)ob;
            Object userObj = dmtn.getUserObject();
            if (userObj instanceof Site) {
                this.deleteSite((Site)userObj);
            } else if (userObj instanceof Cluster) {
                if (this._upperTable.getSelectedRowCount() > 0) {
                    this.removeClusterMember((Switch)this._upperTable.getSelectedObject());
                } else {
                    this.removeCluster((Cluster)userObj);
                }
            } else if (userObj instanceof String) {
                String label = (String)userObj;
                if (label.equals("Sites")) {
                    this.deleteSite((Site)this._upperTable.getSelectedObject());
                } else if (label.equals("Clusters")) {
                    this.removeCluster((Cluster)this._upperTable.getSelectedObject());
                }
            }
        }
    }

    private void deleteSite(Site site) {
        if (this.showQueryDialog("Are you sure you want to remove site label " + site.getName() + " from all switches?")) {
            this._ioaDialog.showWait();
            this.workerAction = 4;
            this._ioaDialog.progressDialog.clearCurrent();
            IOAWorkerSite worker = new IOAWorkerSite(this._ioaDialog, this._ioaCache, site);
            worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
            worker.addPropertyChangeListener(this);
            this._ioaDialog.progressDialog.addListener(worker);
            _Logger.debug((Object)("IOADialogAction:deleteSite " + site.getName() + " - start worker"));
            worker.execute();
        }
    }

    private void removeCluster(Cluster cluster) {
        if (this.showQueryDialog("Are you sure you want to remove cluster " + cluster.getName() + "?")) {
            this._ioaDialog.showWait();
            this.workerAction = 2;
            this._ioaDialog.progressDialog.clearCurrent();
            IOAWorkerCluster worker = new IOAWorkerCluster(this._ioaDialog, this._ioaCache, cluster);
            worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
            worker.addPropertyChangeListener(this);
            this._ioaDialog.progressDialog.addListener(worker);
            _Logger.debug((Object)("IOADialogAction:removeCluster " + cluster.getName() + " - start worker"));
            worker.execute();
        }
    }

    private void removeClusterMember(Switch member) {
        if (this.showQueryDialog("Are you sure you want to remove cluster member " + member.getName() + "?")) {
            this._ioaDialog.showWait();
            this.workerAction = 5;
            this._ioaDialog.progressDialog.clearCurrent();
            IOAWorkerSwitch worker = new IOAWorkerSwitch(this._ioaDialog, this._ioaCache, member);
            worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
            worker.addPropertyChangeListener(this);
            this._ioaDialog.progressDialog.addListener(worker);
            _Logger.debug((Object)("IOADialogAction:removeClusterMember " + member.getName() + " - start worker"));
            worker.execute();
        }
    }

    private void createFlow() {
        if (this._ioaCache.getActiveCluster().getFirstSiteName() != null && this._ioaCache.getActiveCluster().getSecondSiteName() != null) {
            JFrame parentFrame = (JFrame)SwingUtilities.windowForComponent(this._ioaDialog);
            AddCustomFlowDialog dlg = null;
            dlg = new AddCustomFlowDialog(parentFrame, this._ioaCache);
            dlg.setVisible(true);
        } else {
            this.showErrorDialog("To add a custom flow to this cluster, there must be 2 sites associated with the cluster.");
        }
    }

    public void showAllFlows() {
        if (this._ioaCache.getNeedsApply()) {
            int answer = this.showQueryCancelDialog("You have unapplied changes. Do you wish to apply these changes?");
            if (answer == 0) {
                this._ioaCache.setShowAllFlows(this._ioaDialog.getControls().showAllFlows());
                this.showWaitAndApplyChanges();
                return;
            }
            if (answer == 1) {
                this.clearApply();
            } else {
                this._ioaDialog.getControls().setShowFlowsCheckbox(this._ioaCache.isShowAllFlows());
                return;
            }
        }
        this._ioaCache.setShowAllFlows(this._ioaDialog.getControls().showAllFlows());
        this.repopulateCandidateFlowList();
        DefaultMutableTreeNode theObject = this._ioaTree.getTreeNodeForUserObject(this._ioaCache.getLastSelectedNode());
        if (theObject != null) {
            this._ioaTree.setSelectionPath(new TreePath(theObject.getPath()));
            this.showTreeNodeData(this._ioaCache.getLastSelectedNode(), new TreePath(theObject.getPath()));
        } else {
            this._ioaTree.setSelectionPath(new TreePath(this._ioaTree.getTreeNodeForUserObject("Clusters").getPath()));
            this.showTreeNodeData("Clusters", this._ioaTree.getSelectionPath());
        }
    }

    private void repopulateCandidateFlowList() {
        Cluster activeCluster = this._ioaCache.getActiveCluster();
        String a = activeCluster.getFirstSiteName();
        String b = activeCluster.getSecondSiteName();
        IOARif ioa = this._ioaCache.getIoa();
        if (a != null && b != null) {
            try {
                if (this._ioaCache.isShowAllFlows()) {
                    this._ioaCache.setCandidateFlowList(ioa.getCandidateFlows(this._ioaCache.getContext(), a, b, true));
                } else {
                    this._ioaCache.setCandidateFlowList(ioa.getCandidateFlows(this._ioaCache.getContext(), a, b, false));
                }
            }
            catch (RemoteException rex) {
                _Logger.debug((Object)("Error setting/getting candidate flow list. " + rex.getMessage()));
            }
        }
    }

    String showInputDialog(String label, String defVal) {
        JOptionPane pane = new JOptionPane(label, 3, 2, null, null, null);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(defVal);
        JDialog dialog = pane.createDialog(this._ioaDialog, Util.getModParentTitle(Util.getFrameAncestor(this._ioaDialog)) + " " + label);
        pane.selectInitialValue();
        dialog.setVisible(true);
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value.toString();
    }

    private String showListSingleSelectDialog(String label, String[] list) {
        Object selectedValue = JOptionPane.showInputDialog(this._ioaDialog, label, "Select One", 1, null, list, list[0]);
        return (String)selectedValue;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this._ioaDialog, message);
    }

    private boolean showQueryDialog(String label) {
        int ret = JOptionPane.showConfirmDialog(this._ioaDialog, label, "", 0);
        return ret == 0;
    }

    private int showQueryCancelDialog(String label) {
        int ret = JOptionPane.showConfirmDialog(this._ioaDialog, label, "", 1);
        return ret;
    }

    public void addSwitch() {
        this.needsApply();
        this._upperTable.addRows(this._lowerTable.removeSelectedRows(), true);
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
    }

    public void removeSwitch() {
        this.needsApply();
        ArrayList<Object[]> removes = this._upperTable.removeSelectedRows();
        for (Object[] rem : removes) {
            Switch s = (Switch)rem[5];
            if (this.switchInUse(s)) {
                JOptionPane.showMessageDialog(this._ioaDialog, "Warning, " + s.getName() + " has at least one interface in use by an IOA Cluster.  Altering site membership may affect active flows.");
            }
            this._lowerTable.addRow(rem, true);
        }
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
    }

    public void addInterface() {
        this.needsApply();
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
        ArrayList<Object[]> adds = this._lowerTable.removeSelectedRows();
        for (Object[] candidateRow : adds) {
            IOAInterface candidate = (IOAInterface)candidateRow[7];
            Switch sw = candidate.getSwitchInfo();
            ArrayList<String> sitesList = new ArrayList<String>();
            IOATableModel tableModel = (IOATableModel)((TableModelWrapper)this._upperTable.getModel()).getActualModel();
            InterfaceTableModel itm = (InterfaceTableModel)tableModel;
            ArrayList<Object> data = itm.getObjectData();
            for (Object o : data) {
                String siteName = ((IOAInterface)o).getSwitchInfo().getSiteName();
                if (siteName == null || siteName.length() <= 0 || sitesList.contains(siteName)) continue;
                sitesList.add(siteName);
            }
            ArrayList<String> originalSitesList = new ArrayList<String>();
            originalSitesList.addAll(sitesList);
            if (sw.getSiteName() == null || sw.getSiteName().length() == 0) {
                ArrayList<Site> addTheseToo = this._ioaCache.getSitesList();
                if (addTheseToo != null) {
                    for (Site site : addTheseToo) {
                        if (site.getName() == null || site.getName().length() <= 0 || sitesList.contains(site.getName())) continue;
                        sitesList.add(site.getName());
                    }
                }
                sitesList.add("<new site>");
                String swSite = null;
                swSite = this.showListSingleSelectDialog("Switch (" + candidateRow[1] + " : " + candidateRow[3] + ") must belong to a site", sitesList.toArray(new String[sitesList.size()]));
                if (swSite != null) {
                    if (swSite.equals("<new site>")) {
                        boolean valid = false;
                        block3: while (!valid) {
                            Pattern SITE_PATTERN;
                            valid = true;
                            swSite = this.showInputDialog("Site Name", "");
                            if (swSite == null) break;
                            if (swSite.length() == 0 || swSite.length() > 31) {
                                this.showErrorDialog("Site name must be between 1 and 31 characters long.");
                                valid = false;
                            }
                            if (!(SITE_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$")).matcher(swSite).matches()) {
                                this.showErrorDialog("Site name must not contain any spaces or special characters.");
                                valid = false;
                            }
                            for (Site s : addTheseToo) {
                                if (!s.getName().equals(swSite)) continue;
                                if (!this.showQueryDialog("A site with this name already exists, do you wish to enter another name?")) {
                                    this.showErrorDialog("The selected switch will be added to existing site (" + s.getName() + ").");
                                    continue block3;
                                }
                                valid = false;
                                continue block3;
                            }
                        }
                        if (swSite == null) {
                            this._lowerTable.addRow(candidateRow, false);
                            continue;
                        }
                        if (originalSitesList.size() < 2 || originalSitesList.contains(swSite)) {
                            sw.setSiteName(swSite);
                            candidateRow[0] = swSite;
                            this._upperTable.addRow(candidateRow, true);
                            continue;
                        }
                        this.showErrorDialog("Error adding " + candidateRow[3] + " from site " + candidateRow[0] + ". Only 2 sites can be allowed in each IOA cluster.");
                        this._lowerTable.addRow(candidateRow, false);
                        continue;
                    }
                    if (originalSitesList.size() < 2 || originalSitesList.contains(swSite)) {
                        sw.setSiteName(swSite);
                        candidateRow[0] = swSite;
                        this._upperTable.addRow(candidateRow, true);
                        continue;
                    }
                    this.showErrorDialog("Error adding " + candidateRow[3] + " from site " + candidateRow[0] + ". Only 2 sites can be allowed in each IOA cluster.");
                    this._lowerTable.addRow(candidateRow, false);
                    continue;
                }
                this._lowerTable.addRow(candidateRow, false);
                continue;
            }
            if (originalSitesList.size() < 2 || originalSitesList.contains(sw.getSiteName())) {
                this._upperTable.addRow(candidateRow, true);
                continue;
            }
            this.showErrorDialog("Error adding " + candidateRow[3] + " from site " + candidateRow[0] + ". Only 2 sites can be allowed in each IOA cluster.");
            this._lowerTable.addRow(candidateRow, false);
        }
    }

    public void removeInterface() {
        this.needsApply();
        this._lowerTable.addRows(this._upperTable.removeSelectedRows(), true);
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
    }

    public void addFlow() {
        String flowGroupName;
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
        JFrame parentFrame = (JFrame)SwingUtilities.windowForComponent(this._ioaDialog);
        ArrayList<String> fgList = new ArrayList<String>();
        IOATableModel tableModel = (IOATableModel)((TableModelWrapper)this._upperTable.getModel()).getActualModel();
        FlowTableModel ftm = (FlowTableModel)tableModel;
        ArrayList<Object> data = ftm.getObjectData();
        for (Object o : data) {
            String flowName = ((Flow)o).getFlowGroupName();
            if (flowName == null || flowName.length() <= 0 || fgList.contains(flowName)) continue;
            fgList.add(flowName);
        }
        AddFlowConfigDialog dlg = new AddFlowConfigDialog(parentFrame, fgList);
        dlg.setVisible(true);
        if (!dlg.isCancelled() && (flowGroupName = dlg.getFlowGroupName()).equals("<new flow group>")) {
            boolean valid = false;
            block1: while (!valid) {
                Pattern SITE_PATTERN;
                valid = true;
                flowGroupName = this.showInputDialog("Flow Group Name", "");
                if (flowGroupName == null) break;
                if (flowGroupName.length() == 0 || flowGroupName.length() > 31) {
                    this.showErrorDialog("Flow Group name must be between 1 and 31 characters long.");
                    valid = false;
                }
                if (valid && !(SITE_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]+$")).matcher(flowGroupName).matches()) {
                    this.showErrorDialog("Flow Group name must not contain any spaces or special characters.");
                    valid = false;
                }
                if (!valid) continue;
                for (String s : fgList) {
                    if (!s.equals(flowGroupName)) continue;
                    if (!this.showQueryDialog("A flow group with this name already exists. Do you wish to enter another name?")) {
                        this.showErrorDialog("The selected flow(s) will be added to existing flow group (" + s + ").");
                        continue block1;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (flowGroupName == null) {
                dlg.manuallyCancel();
            } else {
                dlg.setFlowGroupName(flowGroupName);
            }
        }
        if (!dlg.isCancelled()) {
            this.needsApply();
            boolean compressionOn = dlg.getCompression();
            boolean waOn = true;
            boolean taOn = dlg.getTa();
            String flowGroupName2 = dlg.getFlowGroupName();
            ArrayList<Object[]> flowRows = this._lowerTable.removeSelectedRows();
            boolean _saveDirection = true;
            boolean _firstTimeDirection = true;
            EndDevice savedInitiator = null;
            EndDevice savedTarget = null;
            for (Object[] row : flowRows) {
                Flow f = (Flow)row[8];
                f.setFlowGroupName(flowGroupName2);
                f.setUseCompression(compressionOn);
                f.setUseWA(waOn);
                f.setUseTA(taOn);
                if (f.isAmbiguous()) {
                    if (_saveDirection && !_firstTimeDirection) {
                        if (!savedInitiator.getSiteName().equals(f.getInitiator().getSiteName())) {
                            EndDevice tmp = f.getInitiator();
                            f.setInitiator(f.getTarget());
                            f.setTarget(tmp);
                            row[1] = f.getInitiator().getDisplayString();
                            row[2] = f.getTarget().getDisplayString();
                        }
                    } else {
                        _firstTimeDirection = false;
                        FlowDirectionConfigDialog fdcd = new FlowDirectionConfigDialog(parentFrame, f.getInitiator(), f.getTarget(), _saveDirection);
                        fdcd.setVisible(true);
                        if (fdcd.is_saveFlag()) {
                            savedInitiator = fdcd.getInitiator();
                            savedTarget = fdcd.getTarget();
                        }
                        _saveDirection = fdcd.is_saveFlag();
                        f.setInitiator(fdcd.getInitiator());
                        f.setTarget(fdcd.getTarget());
                        row[1] = fdcd.getInitiator().getDisplayString();
                        row[2] = fdcd.getTarget().getDisplayString();
                    }
                }
                row[3] = flowGroupName2;
                row[4] = compressionOn;
                row[5] = waOn;
                row[6] = taOn;
                this._upperTable.addRow(row, true);
            }
        } else {
            this._lowerTable.clearSelection();
        }
    }

    public void removeFlow() {
        this.needsApply();
        ArrayList<Object[]> flowRows = this._upperTable.removeSelectedRows();
        for (Object[] row : flowRows) {
            Flow f = (Flow)row[8];
            if (!f.getInitiator().isBoth() || !f.getTarget().isBoth()) continue;
            row[1] = "* " + f.getInitiator().getDisplayString();
        }
        this._lowerTable.addRows(flowRows, true);
        this._ioaDialog.getControls().showDisabledAddRemoveButton();
    }

    public void refreshTreeAndTable() {
        this._ioaDialog.refresh();
    }

    public void refreshTreeAndTableWithStatus() {
        if (this._ioaCache.getNeedsApply()) {
            int answer = this.showQueryCancelDialog("You have unapplied changes. Do you wish to apply these changes?");
            if (answer == 0) {
                this.showWaitAndApplyChanges();
            } else if (answer == 1) {
                this.clearApply();
            } else {
                return;
            }
        }
        this._ioaDialog.setStatus("Refreshing...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IOADialogAction.this.refreshTreeAndTable();
            }
        });
    }

    public void showWaitAndSwitchFabric() {
        String selectedFabric = this._ioaDialog.getSelectedFabric();
        FabricPK currentFabric = this._ioaDialog.get_fabricPK();
        if (!currentFabric.getName().equalsIgnoreCase(selectedFabric)) {
            if (this.showQueryDialog("Are you sure you wish to start configuring another fabric?")) {
                this._ioaDialog.setStatus("Switching Fabrics...");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IOADialogAction.this._ioaDialog.showWait();
                        IOADialogAction.this.switchFabric();
                    }
                });
            } else {
                this._ioaDialog.resetFabricSelector();
            }
        }
    }

    public void switchFabric() {
        String selectedFabric = this._ioaDialog.getSelectedFabric();
        FabricPK currentFabric = this._ioaDialog.get_fabricPK();
        if (!currentFabric.getName().equalsIgnoreCase(selectedFabric)) {
            ArrayList<FabricPK> fabricList = this._ioaCache.getFabricList();
            boolean found = false;
            for (FabricPK indFabric : fabricList) {
                if (!indFabric.getName().equalsIgnoreCase(selectedFabric)) continue;
                this._ioaCache.setLastSelectedNode("Sites");
                this._ioaDialog.set_fabricPK(indFabric);
                this.refreshTreeAndTable();
                found = true;
                break;
            }
            if (found) {
                this._ioaDialog.setStatus("");
                this._ioaDialog.setStatus("Successfully changed fabrics.");
            } else {
                this._ioaDialog.setStatus("");
                this.showErrorDialog("Error! Could not switch fabric to " + selectedFabric + ". Will try switching back...");
                this._ioaDialog.set_fabricPK(currentFabric);
                this.refreshTreeAndTable();
            }
        }
    }

    public void needsApply() {
        this._ioaCache.setNeedsApply(true);
        this._ioaDialog.getControls().enableApplyButton();
    }

    public void clearApply() {
        this._ioaCache.setNeedsApply(false);
        this._ioaDialog.getControls().disableApplyButton();
    }

    public void askApply() {
        this._ioaDialog.setStatus("");
        if (this.showQueryDialog("Do you wish to apply these changes?")) {
            this.showWaitAndApplyChanges();
        }
    }

    public void showWaitAndApplyChanges() {
        this._ioaDialog.setStatus("Applying Changes...");
        this._ioaDialog.showWait();
        IOATableModel tableModel = (IOATableModel)((TableModelWrapper)this._upperTable.getModel()).getActualModel();
        this._ioaDialog.progressDialog.clearCurrent();
        IOAWorkerApply worker = new IOAWorkerApply(this._ioaDialog, this._ioaCache, tableModel);
        worker.addPropertyChangeListener(this._ioaDialog.listenerProgressUpdate);
        worker.addPropertyChangeListener(this);
        this._ioaDialog.progressDialog.addListener(worker);
        worker.execute();
    }

    public void viewChart() {
        block2: {
            int type = 0;
            IOAChartDialog theChartDialog = null;
            JFrame _parent = (JFrame)SwingUtilities.windowForComponent(this._ioaDialog);
            try {
                InterfaceStats stats = (InterfaceStats)this._lowerTable.getSelectedObject();
                theChartDialog = this.getChartDialog(_parent, type, stats);
                theChartDialog.setVisible(true);
            }
            catch (Exception ex) {
                if (theChartDialog == null) break block2;
                theChartDialog.dispose();
            }
        }
    }

    protected IOAChartDialog getChartDialog(JFrame parent, int type, InterfaceStats stats) throws Exception {
        return new IOAChartDialog(parent, type, stats, this._ioaCache);
    }

    public IOADialog getDialog() {
        return this._ioaDialog;
    }

    private ArrayList<Switch> removeUnsupportedSwitches(ArrayList<Switch> switchList) {
        ArrayList<Switch> swCandidates = new ArrayList<Switch>();
        SwitchVersion requiredVersion = new SwitchVersion("3.3(1.3)");
        for (Switch sw : switchList) {
            SwitchVersion swVersion;
            if (sw.getVersion() == null || !requiredVersion.lessThanEqual(swVersion = new SwitchVersion(sw.getVersion()))) continue;
            swCandidates.add(sw);
        }
        return swCandidates;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String strPropertyName = evt.getPropertyName();
        _Logger.debug((Object)("IOADialogAction:propertyChange event: " + strPropertyName + " action: " + this.workerAction));
        if ("state".equals(strPropertyName) && SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (IOADialogAction.this._ioaCache.getNeedsApply()) {
                        if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                            IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                            IOADialogAction.this._ioaCache.setCustomDescription(false);
                        } else if (IOADialogAction.this._ioaCache.getSwingWorkerOps() != null) {
                            JFrame parentFrame = (JFrame)SwingUtilities.windowForComponent(IOADialogAction.this._ioaDialog);
                            ErrorListDialog dlg = new ErrorListDialog(parentFrame, IOADialogAction.this._ioaCache.getSwingWorkerOps());
                            if (dlg != null) {
                                dlg.setVisible(true);
                            }
                            IOADialogAction.this._ioaCache.setSwingWorkerOps(null);
                        }
                        IOADialogAction.this._ioaDialog.refresh();
                        IOADialogAction.this.clearApply();
                    } else {
                        if (IOADialogAction.this.workerAction == 1) {
                            IOADialogAction.this.workerAction = 0;
                            if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                                IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                IOADialogAction.this._ioaCache.setCustomDescription(false);
                            }
                            IOADialogAction.this.viewUpdate("Clusters");
                            IOADialogAction.this._ioaDialog.refresh();
                        } else if (IOADialogAction.this.workerAction == 2) {
                            IOADialogAction.this.workerAction = 0;
                            if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                                IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                IOADialogAction.this._ioaCache.setCustomDescription(false);
                            }
                            IOADialogAction.this.viewUpdate("Clusters");
                        } else if (IOADialogAction.this.workerAction == 3) {
                            IOADialogAction.this.workerAction = 0;
                            if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                                IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                IOADialogAction.this._ioaCache.setCustomDescription(false);
                                IOADialogAction.this.viewUpdate("Sites");
                            } else if (IOADialogAction.this._ioaCache.getSwingWorkerStatus() != null) {
                                if (IOADialogAction.this._ioaCache.getSwingWorkerStatus().getStatus().equals(OperationStatusEnum.Failure)) {
                                    IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                    IOADialogAction.this.viewUpdate("Sites");
                                } else if (IOADialogAction.this._ioaCache.getSwingWorkerStatus().getStatus().equals(OperationStatusEnum.Success)) {
                                    IOADialogAction.this.showErrorDialog("Successfully created Site");
                                    IOADialogAction.this._ioaCache.setActiveSite(IOADialogAction.this._ioaCache.getSite(IOADialogAction.this._ioaCache.getSwingWorkerSiteName()));
                                    IOADialogAction.this.viewUpdate(IOADialogAction.this._ioaCache.getActiveSite());
                                }
                            } else {
                                IOADialogAction.this.showErrorDialog("An error occurred while creating a site. Please see log for more details.");
                                IOADialogAction.this.viewUpdate("Sites");
                            }
                        } else if (IOADialogAction.this.workerAction == 4) {
                            IOADialogAction.this.workerAction = 0;
                            if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                                IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                IOADialogAction.this._ioaCache.setCustomDescription(false);
                            } else if (IOADialogAction.this._ioaCache.getSwingWorkerStatus() == null || IOADialogAction.this._ioaCache.getSwingWorkerStatus().getStatus().equals(OperationStatusEnum.Failure)) {
                                IOADialogAction.this.showErrorDialog("An error occurred removing one or more site associations. Please see log for more details.");
                            } else {
                                IOADialogAction.this.showErrorDialog("Successfully removed site and associations");
                            }
                            IOADialogAction.this.viewUpdate("Sites");
                        } else if (IOADialogAction.this.workerAction == 5) {
                            IOADialogAction.this.workerAction = 0;
                            if (IOADialogAction.this._ioaCache.isCustomDescription()) {
                                IOADialogAction.this.showErrorDialog(IOADialogAction.this._ioaCache.getSwingWorkerStatus().getDescription());
                                IOADialogAction.this._ioaCache.setCustomDescription(false);
                            } else if (IOADialogAction.this._ioaCache.getSwingWorkerStatus() == null || IOADialogAction.this._ioaCache.getSwingWorkerStatus().getStatus().equals(OperationStatusEnum.Failure)) {
                                IOADialogAction.this.showErrorDialog("An error occurred removing the cluster member. Please see log for more details.");
                            } else {
                                IOADialogAction.this.showErrorDialog("Successfully removed cluster member");
                            }
                            IOADialogAction.this.viewUpdate(IOADialogAction.this._ioaCache.getActiveCluster());
                        } else {
                            IOADialogAction.this.workerAction = 0;
                            DefaultMutableTreeNode theObject = IOADialogAction.this._ioaTree.getTreeNodeForUserObject(IOADialogAction.this._ioaCache.getLastSelectedNode());
                            if (theObject != null) {
                                IOADialogAction.this._ioaTree.setSelectionPath(new TreePath(theObject.getPath()));
                                IOADialogAction.this.showTreeNodeData(IOADialogAction.this._ioaCache.getLastSelectedNode(), new TreePath(theObject.getPath()));
                            } else if (IOADialogAction.this._ioaCache.getLastSelectedNode() instanceof Cluster) {
                                IOADialogAction.this._ioaTree.setSelectionPath(new TreePath(IOADialogAction.this._ioaTree.getTreeNodeForUserObject("Clusters").getPath()));
                                IOADialogAction.this.showTreeNodeData("Clusters", IOADialogAction.this._ioaTree.getSelectionPath());
                            } else {
                                IOADialogAction.this._ioaTree.setSelectionPath(new TreePath(IOADialogAction.this._ioaTree.getTreeNodeForUserObject("Sites").getPath()));
                                IOADialogAction.this.showTreeNodeData("Sites", IOADialogAction.this._ioaTree.getSelectionPath());
                            }
                        }
                        IOADialogAction.this._ioaDialog.showReady();
                        IOADialogAction.this.workerAction = 0;
                    }
                }
            });
        }
    }

    private boolean switchInUse(Switch s) {
        if (s.isMaster()) {
            return true;
        }
        for (Cluster c : this._ioaCache.getClusterList()) {
            for (IOAInterface i : c.getInterfaceList()) {
                if (!i.getSwitchInfo().equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public class IOAInterfaceRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon statusIcon = Util.loadIcon("icons/IOA/interfaces.png");
            this.setIcon(statusIcon);
            if (value != null) {
                label.setText(value.toString());
            }
            return this;
        }
    }

    public class IOAStatusRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon statusIcon = new ImageIcon();
            statusIcon = value.equals("Online") ? Util.loadIcon("icons/IOA/green.png") : Util.loadIcon("icons/IOA/red.png");
            this.setIcon(statusIcon);
            if (value != null) {
                label.setText(value.toString());
            }
            return this;
        }
    }

    public class IOAClusterRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value.toString() != null && value.toString().length() > 0) {
                ImageIcon sitesIcon = Util.loadIcon("icons/IOA/cluster.png");
                this.setIcon(sitesIcon);
            }
            if (value != null) {
                label.setText(value.toString());
            }
            return this;
        }
    }

    public class IOASitesRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value.toString() != null && value.toString().length() > 0) {
                ImageIcon sitesIcon = Util.loadIcon("icons/IOA/sites.png");
                this.setIcon(sitesIcon);
            }
            if (value != null) {
                label.setText(value.toString());
            }
            return this;
        }
    }

    public class IOASiteRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value.toString() != null && value.toString().length() > 0) {
                ImageIcon sitesIcon = Util.loadIcon("icons/IOA/site.png");
                this.setIcon(sitesIcon);
            }
            if (value != null) {
                label.setText(value.toString());
            }
            return this;
        }
    }
}

