/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.iscsi.IscsiController;
import com.cisco.dcbu.sm.client.iscsi.IscsiDevice;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IscsiProxy;
import com.cisco.dcbu.sm.client.zm.common.ZoneSetPanel;
import java.util.ArrayList;

class IscsiZoneSetPanel
extends ZoneSetPanel {
    public IscsiZoneSetPanel(JWizard wiz) {
        super(wiz, "3 of 3: Select Zone", IscsiController.ISCSI_ZONE);
    }

    @Override
    protected void populateZoneControls() throws SnmpException {
        super.populateZoneControls();
        if (this._zoneField.getText().indexOf("ISCSI-") == -1) {
            this._zoneField.setText("ISCSI-" + this._zoneField.getText());
        }
    }

    @Override
    protected void setDescription() {
        StringBuffer description = new StringBuffer();
        Object dev = this.getModelValue("INITIATOR");
        boolean proxy = dev instanceof IscsiProxy;
        Boolean newInit = (Boolean)this.getModelValue("NEW_INITIATOR");
        SnmpPeer initPeer = (SnmpPeer)this.getModelValue("INITIATOR_SWITCH");
        Vsan vsan = (Vsan)this.getModelValue("VSAN");
        if (proxy) {
            description.append("Press 'Finish' to add proxy iSCSI initiator " + dev + " and selected storage ports to a new zone and activate on switch " + initPeer + " for VSAN " + vsan + ".");
        } else {
            if (newInit.booleanValue()) {
                description.append("Press 'Finish' to create a new iSCSI initiator " + ((IscsiDevice)dev)._name + " on switch " + initPeer + " for VSAN " + vsan);
            } else {
                description.append("Press 'Finish' to add the iSCSI initiator " + ((IscsiDevice)dev)._name + " to VSAN " + vsan);
            }
            description.append(" and make its WWN persistent. The selected storage ports and initiator WWN will be added to a new zone on switch " + initPeer + " and activated.");
        }
        this.setDescription(description.toString());
    }

    @Override
    protected void createAndActivateZoneSet(boolean saveConfig, String configFile) throws SnmpException {
        Object initDev = this.getModelValue("INITIATOR");
        byte[] pWWN = initDev instanceof IscsiProxy ? ((IscsiProxy)initDev)._pWWN : this.createInitiator()._pWWN;
        Array memberPorts = (Array)this.getModelValue("NXPORTS");
        memberPorts.addElement(pWWN);
        super.createAndActivateZoneSet(saveConfig, configFile);
    }

    private IscsiDevice createInitiator() throws SnmpException {
        IscsiDevice dev = (IscsiDevice)this.getModelValue("INITIATOR");
        Vsan v = (Vsan)this.getModelValue("VSAN");
        if (dev._vsanList == null || dev._vsanList.length == 0) {
            dev._vsanList = new byte[512];
        }
        SnmpString.setBitBase0(dev._vsanList, v.getId());
        SnmpPeer initPeer = (SnmpPeer)this.getModelValue("INITIATOR_SWITCH");
        ArrayList initList = (ArrayList)this.getModelValue("INITIATOR_LIST");
        IscsiController iscsiCntrl = (IscsiController)this.getModelValue("ISCSI_CONTROLLER");
        iscsiCntrl.createInitiator(initPeer, (Boolean)this.getModelValue("NEW_INITIATOR") == false && dev._switchAdd != null && dev._switchAdd.equals(initPeer.getAddress()), dev, initList);
        dev._pWWN = iscsiCntrl.getInitiatorPwwn(initPeer, new int[]{dev._instanceIndex, dev._index});
        return dev;
    }
}

