/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.UIContextHelper;
import com.cisco.dcbu.sm.client.lic.rep.Context;
import com.cisco.dcbu.sm.client.lic.rep.NexusContext;
import com.cisco.dcbu.sm.client.map.EthN5KSwitchNode;
import com.cisco.dcbu.sm.client.map.EthSwitchNode;
import com.cisco.dcbu.sm.client.map.N7KSwitchNode;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CrossLaunchContextHelper
implements UIContextHelper {
    @Override
    public Context getSelectedContext() {
        NexusContext context = null;
        try {
            List nodes = (List)SelectionAction.getSelectedNodes();
            Iterator itr = nodes.iterator();
            if (itr.hasNext()) {
                TopologyNode node = (TopologyNode)itr.next();
                if (!(node instanceof EthSwitchNode)) {
                    return context;
                }
                String username = "";
                String password = "";
                String ipAddress = "";
                SnmpUserOpt userOpt = null;
                if (node instanceof EthN5KSwitchNode) {
                    EthN5KSwitchNode n5k = (EthN5KSwitchNode)node;
                    userOpt = ((EthSwitch)node.getModel()).getSnmpUserOpt();
                    ipAddress = n5k.getIpAddress();
                } else if (node instanceof N7KSwitchNode) {
                    N7KSwitchNode n7k = (N7KSwitchNode)node;
                    userOpt = ((EthSwitch)node.getModel()).getSnmpUserOpt();
                    ipAddress = n7k.getIpAddress();
                }
                if (userOpt == null) {
                    Logger.error("SnmpUserOpt is null");
                } else {
                    username = userOpt.getUsername();
                    password = userOpt.getPassword();
                }
                context = new NexusContext(ipAddress, username == null ? "" : username, password == null ? "" : password, "n5k");
            }
        }
        catch (IOException e) {
            Logger.error("Unable to get selected context: " + e.getMessage());
            e.printStackTrace();
        }
        return context;
    }
}

