/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.sm.client.Launcher;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.RestRequestHelper;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.StringTokenizer;
import org.restlet.Client;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class McastReceiver {
    private String instanceId = null;
    private static McastReceiver instance = null;
    private String port = null;
    private InetAddress group = null;
    private MulticastSocket receiver = null;

    public static synchronized McastReceiver getInstance() {
        if (instance == null) {
            instance = new McastReceiver();
        }
        return instance;
    }

    public McastReceiver() {
        try {
            this.group = InetAddress.getByName("225.10.10.15");
        }
        catch (Exception e) {
            Logger.error("Unable to get address by name: " + e.getMessage());
        }
        try {
            this.receiver = new MulticastSocket(11010);
            this.receiver.joinGroup(this.group);
            Thread t = new Thread(McastReceiver.class.getName() + "-" + System.currentTimeMillis()){

                @Override
                public void run() {
                    McastReceiver.this.receive();
                }
            };
            t.start();
        }
        catch (IOException ioex) {
            Logger.error("Unable to create McastReceiver: " + ioex.getMessage());
        }
    }

    public void receive() {
        if (this.receiver == null) {
            throw new RuntimeException("Receiver not initialized");
        }
        while (true) {
            try {
                while (true) {
                    byte[] buffer = new byte[65509];
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    this.receiver.receive(dp);
                    String str = new String(dp.getData(), 0, dp.getLength());
                    if (str == null) continue;
                    this.parseAndlaunch(str);
                }
            }
            catch (Exception ex) {
                Logger.error(ex.getMessage());
                continue;
            }
            break;
        }
    }

    public void parseAndlaunch(String received) {
        try {
            String uri;
            Request req;
            Client client;
            RestRequestHelper helper;
            Response res;
            StringTokenizer stb = new StringTokenizer(received, "#");
            stb.countTokens();
            String server = null;
            String replyPort = null;
            String tempToken = null;
            String instanceClassId = null;
            if (stb.countTokens() == 4) {
                instanceClassId = stb.nextToken();
                server = stb.nextToken();
                replyPort = stb.nextToken();
                tempToken = stb.nextToken();
            }
            if (replyPort == null || tempToken == null) {
                return;
            }
            if (this.instanceId == null || this.instanceId.equals(instanceClassId)) {
                this.port = replyPort;
                Launcher.handshakeRespond(Integer.parseInt(replyPort), tempToken, Launcher.getPort());
            }
            if (instanceClassId != null && !instanceClassId.toString().equals(this.instanceId) && (res = (helper = new RestRequestHelper(client = new Client(Protocol.HTTP))).handle(req = new Request(Method.GET, uri = "http://localhost:" + this.port + "/login"))).getStatus().isConnectorError()) {
                this.port = replyPort;
                if (!client.isStopped()) {
                    client.stop();
                }
                Launcher.handshakeRespond(Integer.parseInt(replyPort), tempToken, Launcher.getPort());
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public static void main(String ... strings) throws Exception {
        McastReceiver.getInstance().receive();
    }
}

