/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.license;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.license.LicenseFinalPanel;
import com.cisco.dcbu.sm.client.license.LicenseWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Security;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LicenseAutomatic
extends LicenseFinalPanel
implements ActionListener,
SnmpCallbackIf {
    static final String DEFAULT_SERVER = "tools.cisco.com";
    static final int SELECT = 0;
    static final int SWITCH = 1;
    static final int MODEL = 2;
    static final int HOSTID = 3;
    static final int PAK = 4;
    HeaderListener _headerListener = new HeaderListener();
    static final String XMLFRAG = "<RequestingUserInformation><UserInformation><FirstName>" + System.getProperty("user.name") + "</FirstName>" + "</UserInformation>" + "</RequestingUserInformation>" + "<RequestParameters>" + "<EmailRequired>False</EmailRequired>" + "<RequestingSystem>Cisco_Fabric_Manager  " + "</RequestingSystem>" + "</RequestParameters>";
    static final String[] COLS = new String[]{"Select", "Switch", "Model", "HostId", "Product Authorization Key (PAK)", "Install or Update?", "Status"};
    static final boolean[] ATTRS = new boolean[]{true, false, false, false, true, true, false};
    static final String[] PROTO = new String[]{"scp", "sftp"};
    static final int[] ciscoFlashCopyRemotePasswordOid_pre_6_2_1 = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 10, 1, 2, 1, 1, 12};
    static int[] _hostIdOid = LicenseAutomatic.getOids("clmHostId");
    static int[] _spinLockOid = LicenseAutomatic.getOids("clmLicenseConfigSpinLock");
    static int[] _licUriOid = LicenseAutomatic.getOids("clmLicenseFileURI");
    static int[] _licNameOid = LicenseAutomatic.getOids("clmLicenseFileTargetName");
    static int[] _licCmdOid = LicenseAutomatic.getOids("clmLicenseConfigCommand");
    static int[] _licStatusOid = LicenseAutomatic.getOids("clmLicenseConfigCommandStatus");
    static int[] _flashRowStatusOid = LicenseAutomatic.getOids("ciscoFlashCopyEntryStatus");
    static int[] _flashStatusOid = LicenseAutomatic.getOids("ciscoFlashCopyStatus");
    static LicenseFinalPanel.TableMouseListener _lsnr;
    static final int INIT = 0;
    static final int HTTP = 1;
    static final int START_FLASH_COPY = 2;
    static final int POLL_FLASH_COPY = 3;
    static final int SET_REQ = 4;
    static final int POLL_REQ = 5;
    static final int DONE = 6;
    static final int INSTALL_UPDATE = 5;
    static final String INSTALL = "Install";
    static final String UPDATE = "Update";
    static final int UPDATE_LIC_CMD = 4;
    static final int INSTALL_LIC_CMD = 1;
    String[] _availableServers = new String[]{"tools.cisco.com"};
    static final int STATUS = 6;
    JFrame _parent;
    SnmpPeer[] _peers;
    int _processingRow = -1;
    TFTP _tftp;
    JWizard _wizard;

    LicenseAutomatic(JWizard wizard, SnmpPeer[] peers) throws Exception {
        super("2 of 2: Fetch and Install License", "Enter the PAK for each selected switch.  The licenses will be fetched and stored locally. After that we will transfer the file to the bootflash and do an install.\nNOTE: If we cannot open TFTP port 69, you will need a local SSH server to allow scp/sftp. It is advisable to use the same username as the local user.", wizard);
        this._wizard = wizard;
        this._peers = peers;
        this._wizard.removeAllPanelAfterCurrent();
        this.build();
        this._wizard.getNavigator().getNextBtn().setText("Finish");
        this._wizard.getNavigator().getNextBtn().setActionCommand("Finish");
        this._wizard.getNavigator().getNextBtn().setMnemonic('F');
        this._wizard.getNavigator().getNextBtn().setIcon(null);
    }

    public void setNextToFinish() {
        this._wizard.getNavigator().getNextBtn().setText("Finish");
        this._wizard.getNavigator().getNextBtn().setActionCommand("Finish");
        this._wizard.getNavigator().getNextBtn().setMnemonic('F');
        this._wizard.getNavigator().getNextBtn().setIcon(null);
    }

    @Override
    public void dispose() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        if (this._tftp != null) {
            this._tftp.stopServer();
            this._tftp = null;
        }
        this._wizard = null;
        this._parent = null;
        _lsnr = null;
        super.dispose();
    }

    public MouseListener getMouseListener() {
        if (_lsnr == null) {
            _lsnr = new LicenseFinalPanel.TableMouseListener(this);
        }
        return _lsnr;
    }

    private void setStatus(String msg) {
        this.getWizard().setStatus(msg);
    }

    @Override
    protected void build() throws Exception {
        JPanel center;
        JPanel panel = new JPanel(new BorderLayout());
        this._data = new Array();
        for (int i = 0; i < this._peers.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
            if (!sw.isVersionGreaterThanEqual("1.3(0)") || sw.isUCS() || ((SwitchBase)sw.getBaseModelObject()).isVdc()) continue;
            this._data.addElement(new Object[]{Boolean.FALSE, sw, sw.getModel(), null, "", INSTALL, new LicenseFinalPanel.Status(this, ""), null});
        }
        this._model = new SmLmTableModel();
        this._model.setData(this._data);
        this._model.setHeaders(COLS);
        this._model.setEditable(ATTRS);
        this._table = new SnmpKTable(this._model);
        this._table.setAutoResizeMode(3);
        this._table.getTableHeader().addMouseListener(this._headerListener);
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._table.addMouseListener(this.getMouseListener());
        TableColumnModel cm = this._table.getColumnModel();
        cm.getColumn(6).setCellRenderer(new LicenseFinalPanel.MyStatusRenderer(this));
        this._table.setRowSelectionAllowed(true);
        cm.setColumnSelectionAllowed(true);
        this._sp = new JScrollPane(this._table);
        cm.getColumn(3).setPreferredWidth(140);
        cm.getColumn(4).setPreferredWidth(200);
        cm.getColumn(6).setPreferredWidth(150);
        JComboBox<String> installCombo = new JComboBox<String>();
        installCombo.addItem(INSTALL);
        installCombo.addItem(UPDATE);
        installCombo.setSelectedItem(INSTALL);
        DefaultCellEditor comboEditor = new DefaultCellEditor(installCombo);
        cm.getColumn(5).setCellEditor(comboEditor);
        int height = this._table.calcPreferredSize().height;
        if (height < 150) {
            height = 150;
        }
        this._sp.setPreferredSize(new Dimension(800, height));
        panel.add("Center", this._sp);
        Box box = new Box(1);
        this._licSourceName = new JLabel(LicenseAutomatic.getPath(null, null), 2);
        this._licDestinationName = new JLabel("<pak>.lic", 2);
        try {
            this._localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            throw new Exception("Failed to launch License Manager wizard: " + ex);
        }
        if (!TFTP.canStartServer()) {
            this._rbp = new RadioButtonPanel(PROTO, PROTO.length);
            this._rbp.setSelected(1);
            this._user = new KTextField(System.getProperty("user.name"), 20);
            this._pass = new JPasswordField(20);
            this._labels = DialogUtil.buildLabels(new String[]{"Source:", "Destination:", "Protocol:", "UserName:", "Password:"});
            center = DialogUtil.buildPanel(this._labels, new JComponent[]{this._licSourceName, this._licDestinationName, this._rbp, this._user, this._pass});
            box.add(center);
            this._proto = 6;
        } else {
            this._labels = DialogUtil.buildLabels(new String[]{"Source:", "Destination:"});
            center = DialogUtil.buildPanel(this._labels, new JComponent[]{this._licSourceName, this._licDestinationName});
            this._proto = 0;
        }
        this.getHostId();
        box.add(center);
        panel.add("South", box);
        this.add("Center", panel);
    }

    @Override
    int getStatusCol() {
        return 6;
    }

    int getInstallCmd(int row) {
        String cmd = (String)this._table.getValueAt(row, 5);
        if (UPDATE.equals(cmd)) {
            return 4;
        }
        return 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            this._timeElapsed += 2;
            if (this._pending == 0) {
                switch (this._state) {
                    case 0: {
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue()) {
                            this.fetchHostId(this._processingRow);
                        }
                        this._state = 1;
                        break;
                    }
                    case 1: {
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue()) {
                            LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 6);
                            if (status.inProgress()) {
                                this._licStr = (String)this._table.getValueAt(this._processingRow, 4) + ".lic";
                                this.fetchLic(this._processingRow);
                            } else {
                                this._state = 2;
                            }
                        }
                        this._state = 2;
                        break;
                    }
                    case 2: {
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue()) {
                            LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 6);
                            if (status.inProgress()) {
                                this.startFlashCopy(this._processingRow);
                            } else {
                                this._state = 3;
                            }
                        }
                        this._state = 3;
                        break;
                    }
                    case 3: {
                        LicenseFinalPanel.Status status;
                        int copyInProgress = 0;
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue() && (status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 6)).inProgress()) {
                            ++copyInProgress;
                            this.pollFlashCopy(this._processingRow);
                        }
                        if (copyInProgress != 0) break;
                        this._state = 4;
                    }
                    case 4: {
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue()) {
                            this.installLic(this._processingRow);
                        }
                        this._state = 5;
                        break;
                    }
                    case 5: {
                        LicenseFinalPanel.Status status;
                        int installInProgress = 0;
                        if (!this.isDone(this._processingRow) && ((Boolean)this._table.getValueAt(this._processingRow, 0)).booleanValue() && (status = (LicenseFinalPanel.Status)this._model.getValueAt(this._processingRow, 6)).inProgress()) {
                            ++installInProgress;
                            this.pollLic(this._processingRow);
                        }
                        if (installInProgress != 0) break;
                        this._state = 6;
                    }
                }
            }
            if (this._state != 6) {
                this.setStatus("Elapsed " + this._timeElapsed + " secs");
            } else {
                this.doNextRow();
            }
        } else if (e.getSource() instanceof JButton) {
            String cmd = ((JButton)e.getSource()).getText();
            switch (cmd.charAt(0)) {
                case 'C': {
                    if (this._timer != null) {
                        this._timer.stop();
                        this._timer = null;
                    }
                    if (this._tftp != null) {
                        this._tftp.stopServer();
                        this._tftp = null;
                    }
                    this._parent.dispose();
                }
            }
        }
    }

    @Override
    public void doCancel() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        if (this._tftp != null) {
            this._tftp.stopServer();
            this._tftp = null;
        }
        this._wizard.setVisible(false);
    }

    @Override
    public void doPrevious() {
        this._wizard.show("basePanel");
    }

    @Override
    public void doFinish() {
        int j = 0;
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        this.setStatus(" ");
        int[] selected = new int[this._table.getRowCount()];
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            this._model.setValueAt(new LicenseFinalPanel.Status(this, ""), i, 6);
            boolean b = (Boolean)this._table.getValueAt(i, 0);
            if (!b) continue;
            String pak = (String)this._table.getValueAt(i, 4);
            if (pak.trim().length() == 0) {
                Util.errorMessage((Component)this._parent, "Please enter PAK for all selected switches");
                return;
            }
            selected[j++] = i;
        }
        if (j == 0) {
            Util.errorMessage((Component)this._parent, "No switch chosen");
            return;
        }
        this._rows = new int[j];
        System.arraycopy(selected, 0, this._rows, 0, j);
        if (this._proto > 0) {
            this._userStr = this._user.getText();
            if (this._userStr == null || this._userStr.length() == 0) {
                Util.errorMessage((Component)this._parent, "Please enter a user name");
                return;
            }
            this._passStr = new String(this._pass.getPassword());
            if (this._passStr == null || this._passStr.length() == 0) {
                Util.errorMessage((Component)this._parent, "Please enter a password");
                return;
            }
            this._proto = this._rbp.getSelected() + 5;
        }
        if (this._proto == 0) {
            try {
                this._tftp = TFTP.getInstance();
                this._tftp.startServer(SnmpSession.isTrace());
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this._parent, ex);
                this._tftp = null;
                return;
            }
        } else {
            this._tftp = null;
        }
        if (this._timer == null) {
            this._timer = new Timer(2000, this);
        }
        this._timeElapsed = 0;
        this._timer.setInitialDelay(0);
        this._timer.start();
        this._wizard.getNavigator().getNextBtn().setEnabled(false);
        this._wizard.getNavigator().getBackBtn().setEnabled(false);
        this._wizard.getNavigator().getCancel().setEnabled(true);
        this.doNextRow();
    }

    void doNextRow() {
        if (this._rows.length == 0) {
            return;
        }
        if (this._processingRow == this._rows[this._rows.length - 1]) {
            if (this._timer != null) {
                this._timer.stop();
            }
            this._timer = null;
            if (this._tftp != null) {
                this._tftp.stopServer();
                this._tftp = null;
            }
            BrowserFrame.getDataView().refresh();
            this._wizard.getNavigator().getNextBtn().setEnabled(false);
            this._wizard.getNavigator().getBackBtn().setEnabled(false);
            this._wizard.getNavigator().getCancel().setText("Close");
            this._wizard.getNavigator().getCancel().setEnabled(true);
            return;
        }
        this._licSourceName.setText("");
        this._licDestinationName.setText("");
        if (this._processingRow != -1) {
            for (int i = 0; i < this._rows.length; ++i) {
                if (this._processingRow != this._rows[i]) continue;
                this._processingRow = this._rows[i + 1];
                break;
            }
        } else {
            this._table.setEnabled(false);
            this._table.getTableHeader().removeMouseListener(this._headerListener);
            this._processingRow = this._rows[0];
        }
        this._state = 0;
    }

    void fetchHostId(int row) {
        Switch sw = (Switch)this._model.getValueAt(row, 1);
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 6);
        SnmpPeer peer = sw.getPeer();
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(_spinLockOid, 0));
        try {
            SnmpPDU respPDU = peer.send(pdu);
            VarBindList vbl = respPDU.getVariables();
            SnmpInt spinLock = (SnmpInt)vbl.getVb(0).getVar();
            status.setSpinLock(spinLock);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void fetchLic(int row) {
        try {
            String pak = (String)this._model.getValueAt(row, 4);
            String hostid = (String)this._model.getValueAt(row, 3);
            int vdhIndex = hostid.indexOf("VDH=");
            if (vdhIndex != -1) {
                hostid = hostid.substring(vdhIndex + 4).trim();
            }
            Switch sw = (Switch)this._model.getValueAt(row, 1);
            LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 6);
            SnmpPeer peer = sw.getPeer();
            OneClickXMLClient client = new OneClickXMLClient(row, peer, this._licStr, pak, hostid, "Standard", "");
            ++this._pending;
            status.setStatus("Fetching licenses");
            client.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void startFlashCopy(int row) {
        Switch sw = (Switch)this._model.getValueAt(row, 1);
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 6);
        SnmpPeer peer = sw.getPeer();
        if (peer == null) {
            status.setStatus("Error could not find peer");
            return;
        }
        String server = this._localhost;
        String srcFile = peer.toString() + "_" + this._licStr;
        String path = LicenseAutomatic.getPath(peer, this._licStr);
        this._licSourceName.setText(path);
        this._licSourceName.setSize(new Dimension(path.length() + 2, (int)this._licSourceName.getPreferredSize().getHeight()));
        String destString = "bootflash:/" + this._licStr;
        this._licDestinationName.setText(destString);
        this._licDestinationName.setSize(destString.length() + 2, (int)this._licDestinationName.getPreferredSize().getHeight());
        if (this._proto == 0) {
            this._tftp.addIpAccess(peer.getAddress().getHostAddress(), "true", "true", "true");
            this._tftp.addFileMapping(srcFile, path);
            try {
                server = NetUtil.detectSourceAddress(peer.getAddress()).getHostAddress();
            }
            catch (Exception ex) {
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            srcFile = path;
        }
        int[] index = new int[]{(int)(Math.random() * 2.14748364E8) + 1};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_flashRowStatusOid, index), new SnmpInt(4));
        try {
            pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyServerAddress"), index), new SnmpIpAddress(server));
        }
        catch (SnmpException ex) {
            status.setStatus("Error " + ex.getMessage());
            return;
        }
        pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopySourceName"), index), new SnmpString(LicenseAutomatic.escapify(srcFile)));
        pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyDestinationName"), index), new SnmpString("bootflash:/" + this._licStr));
        pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyCommand"), index), new SnmpInt(1));
        if (this._proto == 0) {
            pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(1));
        } else {
            pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyProtocol"), index), new SnmpInt(this._proto));
            pdu.addVar(new SnmpOID(LicenseAutomatic.getOids("ciscoFlashCopyRemoteUserName"), index), new SnmpString(this._userStr));
            pdu.addVar(new SnmpOID(sw.isVersionGreaterThanEqual("6.2(1)") ? LicenseAutomatic.getOids("ciscoFlashCopyRemotePassword") : ciscoFlashCopyRemotePasswordOid_pre_6_2_1, index), new SnmpString(this._passStr));
            pdu.setVarBindMask(new int[]{pdu.getVariables().size() - 1});
        }
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.addVar(new SnmpOID(_flashStatusOid, index));
        status.setPollPdu(pollPdu);
        status.setInProgress(true);
        try {
            ++this._pending;
            status.setStatus("Flash copy started");
            peer.send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void installLic(int row) {
        Switch sw = (Switch)this._model.getValueAt(row, 1);
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 6);
        SnmpPeer peer = sw.getPeer();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_spinLockOid, 0), status.getSpinLock());
        pdu.addVar(new SnmpOID(_licUriOid, 0), new SnmpString("bootflash:/" + this._licStr));
        pdu.addVar(new SnmpOID(_licNameOid, 0), new SnmpString(this._licStr));
        pdu.addVar(new SnmpOID(_licCmdOid, 0), new SnmpInt(this.getInstallCmd(row)));
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.addVar(new SnmpOID(_licStatusOid, 0));
        status.setPollPdu(pollPdu);
        status.setInProgress(true);
        try {
            ++this._pending;
            status.setStatus("Install/Update license");
            peer.send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        int row = this.findRow(peer);
        if (row == -1) {
            Util.errorMessage((Component)this._parent, peer + " is not manageable, " + "close install dialog and reopen.");
            this._state = 6;
            this._pending = 0;
            return;
        }
        --this._pending;
        LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)this._model.getValueAt(row, 6);
        if (timedOut) {
            if (this._state != 3 || this._state != 5) {
                status.setStatus("Error timeout");
            } else {
                status.setStatus("Timeout");
            }
        } else if (pdu.getError() != 0) {
            status.setStatus("Error " + SnmpException.toError(pdu.getError()));
        } else {
            VarBindList vbl = pdu.getVariables();
            int[] firstOid = vbl.getVb(0).getOid().getValue();
            if (SnmpOID.startsWith(firstOid, _hostIdOid)) {
                String hostid = vbl.stringValue(0);
                if (hostid.length() != 0) {
                    this._model.setValueAt(hostid, row, 3);
                } else {
                    status.setStatus("Error - no host id");
                }
            } else if (SnmpOID.startsWith(firstOid, _spinLockOid)) {
                SnmpInt spinLock = (SnmpInt)vbl.getVb(0).getVar();
                status.setSpinLock(spinLock);
            } else if (SnmpOID.startsWith(firstOid, _flashRowStatusOid)) {
                status.setStatus("Flash Copy Started");
            } else if (SnmpOID.startsWith(firstOid, _flashStatusOid)) {
                int flashStatus = vbl.intValue(0);
                switch (flashStatus) {
                    case 1: {
                        status.setStatus("Flash Copy InProgress");
                        break;
                    }
                    case 2: {
                        status.setStatus("Flash Copy Done");
                        status.setInProgress(false);
                        break;
                    }
                    default: {
                        status.setStatus("Error " + LicenseWizard.getEnum("ciscoFlashCopyStatus", flashStatus));
                        status.setInProgress(false);
                        break;
                    }
                }
            } else if (SnmpOID.startsWith(firstOid, _spinLockOid)) {
                status.setStatus("Installing/Updating license");
            } else if (SnmpOID.startsWith(firstOid, _licStatusOid)) {
                int licStatus = vbl.intValue(0);
                String msg = LicenseWizard.getEnum("clmLicenseConfigCommandStatus", licStatus);
                switch (licStatus) {
                    case 2: {
                        status.setStatus("Install/Update Status " + msg);
                        break;
                    }
                    case 1: {
                        status.setStatus("Success");
                        status.setInProgress(false);
                        if (this._numOfSuccessInstall != 0) break;
                        Switch s = (Switch)this._model.getValueAt(row, 1);
                        try {
                            ModelFacadeRif model = ClientController.getInstance().assertModelFacade();
                            model.rediscoverFabric((FabricPK)s.getFabric().getPK());
                            ++this._numOfSuccessInstall;
                        }
                        catch (Exception ex) {
                            DefaultLogger._DefLogger.error((Object)ex);
                        }
                        break;
                    }
                    default: {
                        status.setStatus("Error " + msg);
                        status.setInProgress(false);
                    }
                }
            }
        }
    }

    class SmLmTableModel
    extends SnmpTableModel {
        SmLmTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 4 || col == 5) {
                return LicenseAutomatic.this._model.getValueAt(row, 0) != null && (Boolean)LicenseAutomatic.this._model.getValueAt(row, 0) != false;
            }
            return super.getEditable()[col];
        }

        @Override
        public boolean isCellActive(int row, int col) {
            boolean b = (Boolean)LicenseAutomatic.this._table.getValueAt(row, 0);
            return col == 0 || b;
        }
    }

    class OneClickXMLClient
    extends Thread {
        private HttpsURLConnection _conn;
        private String _xmlRequest;
        SnmpPeer _peer;
        int _row;
        String _licenseName;
        String _uri = System.getProperty("mds.licenseServer");
        String _dtd;

        OneClickXMLClient(int row, SnmpPeer peer, String licenseName, String pak, String hostId, String licenseType, String emailAddress) {
            if (this._uri == null || this._uri.length() == 0) {
                this._uri = "https://tools.cisco.com/SWIFT/Licensing/LicenseRequestServlet";
            }
            this._dtd = "'https://tools.cisco.com/SWIFT/Licensing/DTD/SWIFTLicenseRequest.dtd'";
            this._conn = null;
            this._xmlRequest = this.createXmlRequest(pak, hostId, licenseType, emailAddress);
            System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
            this._row = row;
            this._peer = peer;
            this._licenseName = licenseName;
        }

        String createXmlRequest(String pak, String hostId, String licenseType, String emailAddress) {
            StringBuffer buff = new StringBuffer();
            buff.append("<?xml version='1.0'?><!DOCTYPE SWIFTLicenseRequest SYSTEM " + this._dtd + ">" + "<SWIFTLicenseRequest><LicenseRequest>" + "<Entitlement><ProductAuthorizationKey>");
            buff.append(pak);
            buff.append("</ProductAuthorizationKey></Entitlement><LicensingParameters><HostId>");
            buff.append(hostId);
            buff.append("</HostId><LicenseType>");
            buff.append(licenseType);
            buff.append("</LicenseType></LicensingParameters>");
            if (emailAddress.length() == 0) {
                buff.append(XMLFRAG);
            } else {
                buff.append("<RequestingUserInformation><UserInformation><Email>");
                buff.append(emailAddress);
                buff.append("</Email></UserInformation></RequestingUserInformation>" + XMLFRAG);
            }
            buff.append("</LicenseRequest></SWIFTLicenseRequest>");
            return buff.toString();
        }

        @Override
        public void run() {
            block5: {
                LicenseFinalPanel.Status status = (LicenseFinalPanel.Status)LicenseAutomatic.this._model.getValueAt(this._row, 6);
                try {
                    String licKey = this.getLicenseKey();
                    String path = LicenseFinalPanel.getPath(this._peer, this._licenseName);
                    FileOutputStream out = new FileOutputStream(path);
                    out.write(licKey.getBytes(), 0, licKey.length());
                    String newLine = "\n";
                    out.write(newLine.getBytes());
                    out.close();
                    if (LicenseAutomatic.this._timer != null) {
                        status.setStatus("Got License");
                    }
                }
                catch (Exception ex) {
                    if (LicenseAutomatic.this._timer != null) {
                        status.setStatus("Error " + ex.getMessage());
                        status.setInProgress(false);
                    }
                    if (!SnmpSession.isTrace()) break block5;
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (LicenseAutomatic.this._pending > 0) {
                --LicenseAutomatic.this._pending;
            }
        }

        String getLicenseKey() throws Exception {
            this.getConnection();
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.error((Object)("Made http connection to " + this._uri));
                DefaultLogger._DefLogger.error((Object)("Sending request " + this._xmlRequest));
            }
            Document replyDoc = this.issuePost(this._xmlRequest);
            String licenseKey = this.parseReply(replyDoc);
            this.releaseConnection();
            return licenseKey;
        }

        void getConnection() throws Exception {
            try {
                URL targetURL = new URL(this._uri);
                this._conn = (HttpsURLConnection)targetURL.openConnection();
            }
            catch (Exception ex) {
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.error((Object)ex.toString(), (Throwable)ex);
                }
                throw new Exception("Failed to open SWIFT URL");
            }
            try {
                this._conn.setRequestMethod("POST");
                this._conn.setRequestProperty("Content-type", "text/xml");
                this._conn.setDoOutput(true);
                this._conn.setDoInput(true);
                this._conn.connect();
            }
            catch (Exception ex) {
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.error((Object)ex.toString(), (Throwable)ex);
                }
                throw new Exception("Connect failed");
            }
        }

        void releaseConnection() {
            this._conn = null;
            this._xmlRequest = null;
        }

        Document issuePost(String xmlToPost) throws IOException, ProtocolException {
            Document replyDocument = null;
            PrintWriter xmlOut = new PrintWriter(this._conn.getOutputStream());
            xmlOut.println(xmlToPost);
            xmlOut.flush();
            InputStream xmlReply = this._conn.getInputStream();
            String xmlReplyString = "";
            byte[] b = new byte[100];
            try {
                int num_bytes;
                while ((num_bytes = xmlReply.read(b, 0, 80)) != -1) {
                    xmlReplyString = xmlReplyString + new String(b, 0, num_bytes, "UTF8");
                }
                DefaultLogger._DefLogger.error((Object)("Got reply " + xmlReplyString));
                ByteArrayInputStream newIn = new ByteArrayInputStream(xmlReplyString.getBytes());
                InputSource insource = new InputSource(newIn);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                replyDocument = builder.parse(insource);
                return replyDocument;
            }
            catch (Exception e) {
                DefaultLogger._DefLogger.error((Object)("XML Reply was " + xmlReplyString));
                DefaultLogger._DefLogger.error((Object)("    issuePost() reply failed: " + e.toString()));
                return null;
            }
        }

        String getTaggedParameter(Document reqDoc, String parmTag) {
            String parmValue = null;
            NodeList elements = reqDoc.getElementsByTagName(parmTag);
            if (elements.getLength() > 0) {
                Element eleNode = (Element)elements.item(0);
                Node textNode = eleNode.getFirstChild();
                parmValue = textNode.getNodeValue();
            }
            return parmValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        String parseReply(Document replyDoc) throws Exception {
            if (replyDoc == null) throw new Exception("No System Status found ");
            String systemStatus = this.getTaggedParameter(replyDoc, "SystemStatus");
            if (systemStatus == null) throw new Exception("System Status " + systemStatus);
            if (Integer.parseInt(systemStatus) != 0) throw new Exception("System Status " + systemStatus);
            String requestStatus = this.getTaggedParameter(replyDoc, "RequestStatus");
            if (requestStatus != null && Integer.parseInt(requestStatus) == 0) {
                return this.getTaggedParameter(replyDoc, "LicenseKey");
            }
            String message = this.getTaggedParameter(replyDoc, "Message");
            throw new Exception(message);
        }
    }
}

